/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.run;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.execution.filters.UrlFilter;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.util.ProgramParametersConfigurator;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.terminal.TerminalExecutionConsole;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BaseOutputReader;
import com.jetbrains.python.actions.PyExecuteSelectionAction;
import com.jetbrains.python.console.PyCodeExecutor;
import com.jetbrains.python.console.PyConsoleOptions;
import com.jetbrains.python.console.PydevConsoleRunner;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.run.CommandLinePatcher;
import com.jetbrains.python.run.PythonCommandLineState;
import com.jetbrains.python.run.PythonRunConfiguration;
import com.jetbrains.python.run.PythonTracebackFilter;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonScriptCommandLineState
extends PythonCommandLineState {
    private static final String INPUT_FILE_MESSAGE = "Input is being redirected from ";
    private final PythonRunConfiguration myConfig;

    public PythonScriptCommandLineState(PythonRunConfiguration runConfiguration, ExecutionEnvironment env) {
        super(runConfiguration, env);
        this.myConfig = runConfiguration;
    }

    @Override
    @Nullable
    public ExecutionResult execute(Executor executor, PythonCommandLineState.PythonProcessStarter processStarter, CommandLinePatcher ... patchers2) throws ExecutionException {
        Project project = this.myConfig.getProject();
        if (this.myConfig.showCommandLineAfterwards() && !this.emulateTerminal()) {
            if (executor.getId() != "Debug" && executor.getId() != "Run") {
                return super.execute(executor, processStarter, patchers2);
            }
            if (executor.getId() == "Debug") {
                return super.execute(executor, processStarter, (CommandLinePatcher[])ArrayUtil.append((Object[])patchers2, (Object)new CommandLinePatcher(){

                    @Override
                    public void patchCommandLine(GeneralCommandLine commandLine) {
                        commandLine.getParametersList().getParamsGroup("Debugger").addParameterAt(1, "--cmd-line");
                    }
                }));
            }
            String runFileText = this.buildScriptWithConsoleRun();
            boolean useExistingConsole = PyConsoleOptions.getInstance(project).isUseExistingConsole();
            Sdk sdk = this.myConfig.getSdk();
            if (useExistingConsole && sdk != null && PyExecuteSelectionAction.canFindConsole(project, sdk.getHomePath())) {
                PyExecuteSelectionAction.selectConsoleAndExecuteCode(project, runFileText);
            } else {
                PyExecuteSelectionAction.startNewConsoleInstance(project, (Consumer<? super PyCodeExecutor>)((Consumer)codeExecutor -> PyExecuteSelectionAction.executeInConsole(codeExecutor, runFileText, null)), runFileText, this.myConfig);
            }
            return null;
        }
        if (this.emulateTerminal()) {
            this.setRunWithPty(true);
            ProcessHandler processHandler2 = this.startProcess(processStarter, patchers2);
            TerminalExecutionConsole executeConsole = new TerminalExecutionConsole(this.myConfig.getProject(), processHandler2);
            executeConsole.addMessageFilter((Filter)new PythonTracebackFilter(this.myConfig.getProject()));
            executeConsole.addMessageFilter((Filter)new UrlFilter());
            processHandler2.startNotify();
            return new DefaultExecutionResult((ExecutionConsole)executeConsole, processHandler2, AnAction.EMPTY_ARRAY);
        }
        ExecutionResult executionResult = super.execute(executor, processStarter, patchers2);
        if (this.myConfig.isRedirectInput()) {
            this.addInputRedirectionMessage(project, executionResult);
        }
        return executionResult;
    }

    private void addInputRedirectionMessage(final @NotNull Project project, @NotNull ExecutionResult executionResult) {
        if (project == null) {
            PythonScriptCommandLineState.$$$reportNull$$$0(0);
        }
        if (executionResult == null) {
            PythonScriptCommandLineState.$$$reportNull$$$0(1);
        }
        final String filePath = FileUtil.toSystemDependentName((String)new File(this.myConfig.getInputFile()).getAbsolutePath());
        final ProcessHandler processHandler2 = executionResult.getProcessHandler();
        processHandler2.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void startNotified(@NotNull ProcessEvent event2) {
                if (event2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                processHandler2.notifyTextAvailable(PythonScriptCommandLineState.INPUT_FILE_MESSAGE + filePath + "\n", ProcessOutputTypes.SYSTEM);
            }

            public void processTerminated(@NotNull ProcessEvent event2) {
                if (event2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                processHandler2.removeProcessListener((ProcessListener)this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/jetbrains/python/run/PythonScriptCommandLineState$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "startNotified";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        ExecutionConsole console = executionResult.getExecutionConsole();
        if (console instanceof ConsoleView) {
            ((ConsoleView)console).addMessageFilter(new Filter(){

                @Nullable
                public Filter.Result applyFilter(@NotNull String line2, int entireLength) {
                    int position;
                    if (line2 == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if ((position = line2.indexOf(PythonScriptCommandLineState.INPUT_FILE_MESSAGE)) >= 0) {
                        VirtualFile file2 = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(filePath));
                        if (file2 == null) {
                            return null;
                        }
                        return new Filter.Result(entireLength - filePath.length() - 1, entireLength, (HyperlinkInfo)new OpenFileHyperlinkInfo(new OpenFileDescriptor(project, file2)));
                    }
                    return null;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/jetbrains/python/run/PythonScriptCommandLineState$3", "applyFilter"));
                }
            });
        }
    }

    private boolean emulateTerminal() {
        return this.myConfig.emulateTerminal() && !PythonSdkUtil.isRemote(this.getSdk());
    }

    @Override
    public void customizeEnvironmentVars(Map<String, String> envs, boolean passParentEnvs) {
        super.customizeEnvironmentVars(envs, passParentEnvs);
        if (this.emulateTerminal() && !SystemInfo.isWindows) {
            envs.put("TERM", "xterm-256color");
        }
    }

    @Override
    protected ProcessHandler doCreateProcess(GeneralCommandLine commandLine) throws ExecutionException {
        if (this.emulateTerminal()) {
            return new OSProcessHandler(commandLine){

                @NotNull
                protected BaseOutputReader.Options readerOptions() {
                    return new BaseOutputReader.Options(){

                        public BaseDataReader.SleepingPolicy policy() {
                            return BaseDataReader.SleepingPolicy.BLOCKING;
                        }

                        public boolean splitToLines() {
                            return false;
                        }

                        public boolean withSeparators() {
                            return true;
                        }
                    };
                }
            };
        }
        return super.doCreateProcess(commandLine);
    }

    @Override
    protected void buildCommandLineParameters(GeneralCommandLine commandLine) {
        ParametersList parametersList = commandLine.getParametersList();
        ParamsGroup exeOptions = parametersList.getParamsGroup("Exe Options");
        assert (exeOptions != null);
        exeOptions.addParametersString(this.myConfig.getInterpreterOptions());
        ParamsGroup scriptParameters = parametersList.getParamsGroup("Script");
        assert (scriptParameters != null);
        if (this.myConfig.isModuleMode()) {
            ParamsGroup moduleParameters = parametersList.getParamsGroup("Module");
            assert (moduleParameters != null);
            moduleParameters.addParameter("-m");
            moduleParameters.addParameters(new String[]{this.myConfig.getScriptName()});
        } else if (!StringUtil.isEmptyOrSpaces((String)this.myConfig.getScriptName())) {
            scriptParameters.addParameter(this.myConfig.getScriptName());
        }
        scriptParameters.addParameters(this.getExpandedScriptParameters());
        if (!StringUtil.isEmptyOrSpaces((String)this.myConfig.getWorkingDirectory())) {
            commandLine.setWorkDirectory(this.myConfig.getWorkingDirectory());
        }
        String inputFile = this.myConfig.getInputFile();
        if (this.myConfig.isRedirectInput() && !StringUtil.isEmptyOrSpaces((String)inputFile)) {
            commandLine.withInput(new File(inputFile));
        }
    }

    @NotNull
    private List<String> getExpandedScriptParameters() {
        String parameters = this.myConfig.getScriptParameters();
        List list = ProgramParametersConfigurator.expandMacrosAndParseParameters((String)parameters);
        if (list == null) {
            PythonScriptCommandLineState.$$$reportNull$$$0(2);
        }
        return list;
    }

    private static String escape(String s) {
        return StringUtil.escapeCharCharacters((String)s);
    }

    private String buildScriptWithConsoleRun() {
        StringBuilder sb = new StringBuilder();
        Map configEnvs = this.myConfig.getEnvs();
        configEnvs.remove("PYTHONUNBUFFERED");
        if (configEnvs.size() > 0) {
            sb.append("import os\n");
            for (Map.Entry entry : configEnvs.entrySet()) {
                sb.append("os.environ['").append(PythonScriptCommandLineState.escape((String)entry.getKey())).append("'] = '").append(PythonScriptCommandLineState.escape((String)entry.getValue())).append("'\n");
            }
        }
        Project project = this.myConfig.getProject();
        Sdk sdk = this.myConfig.getSdk();
        PyRemotePathMapper pathMapper = PydevConsoleRunner.getPathMapper(project, sdk, PyConsoleOptions.getInstance(project).getPythonConsoleSettings());
        String scriptPath = this.myConfig.getScriptName();
        String workingDir = this.myConfig.getWorkingDirectory();
        if (PythonSdkUtil.isRemote(sdk) && pathMapper != null) {
            scriptPath = pathMapper.convertToRemote(scriptPath);
            workingDir = pathMapper.convertToRemote(workingDir);
        }
        sb.append("runfile('").append(PythonScriptCommandLineState.escape(scriptPath)).append("'");
        List<String> scriptParameters = this.getExpandedScriptParameters();
        if (scriptParameters.size() != 0) {
            sb.append(", args=[");
            for (int i = 0; i < scriptParameters.size(); ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append("'").append(PythonScriptCommandLineState.escape(scriptParameters.get(i))).append("'");
            }
            sb.append("]");
        }
        if (!workingDir.isEmpty()) {
            sb.append(", wdir='").append(PythonScriptCommandLineState.escape(workingDir)).append("'");
        }
        if (this.myConfig.isModuleMode()) {
            sb.append(", is_module=True");
        }
        sb.append(")");
        return sb.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionResult";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/run/PythonScriptCommandLineState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/run/PythonScriptCommandLineState";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpandedScriptParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addInputRedirectionMessage";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

