/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.remote.sdk.add.wizard;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.remote.RemoteSdkException;
import com.intellij.ssh.SshSession;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.util.ExceptionUtil;
import com.jetbrains.plugins.webDeployment.config.GroupedServersConfigManager;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.python.remote.sdk.add.SshSdkCreationUtilKt;
import com.jetbrains.python.remote.sdk.add.wizard.AbstractFinishState;
import com.jetbrains.python.remote.sdk.add.wizard.CreateSshInterpreterWizardState;
import com.jetbrains.python.remote.sdk.add.wizard.DeploymentConfigurationUtil;
import com.jetbrains.python.remote.sdk.add.wizard.InternalStateListener;
import com.jetbrains.python.remote.sdk.add.wizard.ui.SshAdditionalConfigurationForm;
import com.jetbrains.python.remote.sdk.add.wizard.ui.ValidationStatusListener;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u0000 !2\u00020\u0001:\u0001!B_\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u001f\u001a\u00020\u0011H\u0016J\b\u0010 \u001a\u00020\u0015H\u0016R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u0018X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006\""}, d2={"Lcom/jetbrains/python/remote/sdk/add/wizard/FinishExistingSshConfigState;", "Lcom/jetbrains/python/remote/sdk/add/wizard/AbstractFinishState;", "username", "", "host", "port", "", "listener", "Lcom/jetbrains/python/remote/sdk/add/wizard/InternalStateListener;", "sshSession", "Lcom/intellij/ssh/SshSession;", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "existingSdks", "", "Lcom/intellij/openapi/projectRoots/Sdk;", "existingSshConfig", "Lcom/intellij/ssh/config/unified/SshConfig;", "previousState", "Lcom/jetbrains/python/remote/sdk/add/wizard/CreateSshInterpreterWizardState;", "(Ljava/lang/String;Ljava/lang/String;ILcom/jetbrains/python/remote/sdk/add/wizard/InternalStateListener;Lcom/intellij/ssh/SshSession;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/module/Module;Ljava/util/List;Lcom/intellij/ssh/config/unified/SshConfig;Lcom/jetbrains/python/remote/sdk/add/wizard/CreateSshInterpreterWizardState;)V", "form", "Lcom/jetbrains/python/remote/sdk/add/wizard/ui/SshAdditionalConfigurationForm;", "getForm", "()Lcom/jetbrains/python/remote/sdk/add/wizard/ui/SshAdditionalConfigurationForm;", "getListener", "()Lcom/jetbrains/python/remote/sdk/add/wizard/InternalStateListener;", "getProject", "()Lcom/intellij/openapi/project/Project;", "finish", "previous", "Companion", "intellij.python.remoteInterpreter"})
public final class FinishExistingSshConfigState
extends AbstractFinishState {
    @NotNull
    private final SshAdditionalConfigurationForm form;
    @NotNull
    private final InternalStateListener listener;
    @Nullable
    private final Project project;
    private final Module module;
    private final List<Sdk> existingSdks;
    private final SshConfig existingSshConfig;
    private final CreateSshInterpreterWizardState previousState;
    private static final Logger LOG;
    public static final Companion Companion;

    @Override
    @NotNull
    public CreateSshInterpreterWizardState previous() {
        return this.previousState;
    }

    @Override
    @NotNull
    protected SshAdditionalConfigurationForm getForm() {
        return this.form;
    }

    @Override
    @NotNull
    public Sdk finish() {
        try {
            WebServerConfig server = new WebServerConfig(WebServerConfig.getNextId());
            server.setName(this.existingSshConfig.getName());
            server.getFileTransferConfig().setSshConfig(this.existingSshConfig);
            GroupedServersConfigManager.getInstance((Project)this.getProject()).addServer(server);
            DeploymentConfigurationUtil.notifyLaterThatDeploymentConfigurationCreated(this.getProject(), server);
            Project project = this.getProject();
            String string = this.getForm().getInterpreterPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"form.interpreterPath");
            Sdk sdk = SshSdkCreationUtilKt.createSdkFromExistingServerConfiguration(project, this.module, this.existingSshConfig, server, this.existingSdks, string, this.getForm().isRunAsRootViaSudo());
            this.savePathMappingSettingsOnFinish(server);
            return sdk;
        }
        catch (RemoteSdkException e) {
            if (!ExceptionUtil.causedBy((Throwable)e, InterruptedException.class)) {
                LOG.debug((Throwable)e);
            }
            throw (Throwable)e;
        }
    }

    @Override
    @NotNull
    public InternalStateListener getListener() {
        return this.listener;
    }

    @Override
    @Nullable
    protected Project getProject() {
        return this.project;
    }

    public FinishExistingSshConfigState(@NotNull String username, @NotNull String host, int port, @NotNull InternalStateListener listener2, @NotNull SshSession sshSession, @Nullable Project project, @Nullable Module module, @NotNull List<? extends Sdk> existingSdks, @NotNull SshConfig existingSshConfig, @NotNull CreateSshInterpreterWizardState previousState) {
        Intrinsics.checkParameterIsNotNull((Object)username, (String)"username");
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
        Intrinsics.checkParameterIsNotNull((Object)sshSession, (String)"sshSession");
        Intrinsics.checkParameterIsNotNull(existingSdks, (String)"existingSdks");
        Intrinsics.checkParameterIsNotNull((Object)existingSshConfig, (String)"existingSshConfig");
        Intrinsics.checkParameterIsNotNull((Object)previousState, (String)"previousState");
        this.listener = listener2;
        this.project = project;
        this.module = module;
        this.existingSdks = existingSdks;
        this.existingSshConfig = existingSshConfig;
        this.previousState = previousState;
        this.form = new SshAdditionalConfigurationForm(this.getProject(), this.existingSshConfig.copyToCredentials(), username, host, port);
        this.getForm().setListener(new ValidationStatusListener(){

            @Override
            public void onValidationStatusChanged() {
                this.getListener().onControlsChanged();
            }
        });
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(FinishExistingSshConfigState.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(Finis\u2026hConfigState::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/python/remote/sdk/add/wizard/FinishExistingSshConfigState$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.python.remoteInterpreter"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

