/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.remote.sdk.add;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.VagrantBasedCredentialsHolder;
import com.intellij.remote.VagrantSupport;
import com.intellij.ui.StatusPanel;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.AsyncProducer;
import com.intellij.util.Consumer;
import com.intellij.util.ui.FormBuilder;
import com.jetbrains.plugins.remotesdk.VagrantCredentialsType;
import com.jetbrains.plugins.remotesdk.ui.RemoteBrowseActionListener;
import com.jetbrains.plugins.remotesdk.ui.VagrantCredentialsEditor;
import com.jetbrains.python.PythonProBundle;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalData;
import com.jetbrains.python.remote.PySshInterpreterBundle;
import com.jetbrains.python.remote.sdk.add.RemoteSdkCreationUtilKt;
import com.jetbrains.python.remote.sdk.add.SshSdkCreationUtilKt;
import com.jetbrains.python.sdk.add.PyAddSdkPanel;
import icons.PythonIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\n\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002J\n\u0010\u001a\u001a\u0004\u0018\u00010\u0006H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/python/remote/sdk/add/PyAddVagrantSdkPanel;", "Lcom/jetbrains/python/sdk/add/PyAddSdkPanel;", "project", "Lcom/intellij/openapi/project/Project;", "existingSdks", "", "Lcom/intellij/openapi/projectRoots/Sdk;", "vagrantSupport", "Lcom/intellij/remote/VagrantSupport;", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Lcom/intellij/remote/VagrantSupport;)V", "credentialsEditor", "Lcom/jetbrains/plugins/remotesdk/ui/VagrantCredentialsEditor;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "interpreterPathField", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "panelName", "", "getPanelName", "()Ljava/lang/String;", "statusPanel", "Lcom/intellij/ui/StatusPanel;", "computeRemoteCredentials", "Lcom/intellij/remote/RemoteCredentials;", "getOrCreateSdk", "onSelected", "", "intellij.python.remoteInterpreter"})
public final class PyAddVagrantSdkPanel
extends PyAddSdkPanel {
    private final StatusPanel statusPanel;
    @NotNull
    private final Icon icon;
    private final VagrantCredentialsEditor credentialsEditor;
    private final TextFieldWithBrowseButton interpreterPathField;
    private final Project project;
    private final List<Sdk> existingSdks;
    private final VagrantSupport vagrantSupport;

    @Override
    @NotNull
    public String getPanelName() {
        String string = PySshInterpreterBundle.message("python.add.sdk.panel.name.pipenv.vagrant", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"com.jetbrains.python.rem\u2026nel.name.pipenv.vagrant\")");
        return string;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    @Nullable
    public Sdk getOrCreateSdk() {
        PyRemoteSdkAdditionalData sdkAdditionalData = new PyRemoteSdkAdditionalData(this.interpreterPathField.getText(), false);
        VagrantBasedCredentialsHolder credentials = new VagrantBasedCredentialsHolder();
        VagrantBasedCredentialsHolder sourceCredentials = this.credentialsEditor.getVagrantCredentials();
        if (sourceCredentials != null) {
            credentials.setVagrantFolder(sourceCredentials.getVagrantFolder());
            credentials.setMachineName(sourceCredentials.getMachineName());
        }
        sdkAdditionalData.setCredentials(VagrantCredentialsType.Companion.getInstance().getCredentialsKey(), credentials);
        SshSdkCreationUtilKt.initializeHelpersPath(this.project, sdkAdditionalData);
        Sdk createAndInitRemoteSdk = RemoteSdkCreationUtilKt.createAndInitRemoteSdk$default(null, sdkAdditionalData, this.existingSdks, null, 9, null);
        return createAndInitRemoteSdk;
    }

    @Override
    public void onSelected() {
        this.credentialsEditor.onSelected();
    }

    private final RemoteCredentials computeRemoteCredentials() {
        RemoteCredentials remoteCredentials;
        VagrantBasedCredentialsHolder vagrantBasedCredentialsHolder = this.credentialsEditor.getVagrantCredentials();
        if (vagrantBasedCredentialsHolder != null) {
            VagrantBasedCredentialsHolder vagrantBasedCredentialsHolder2 = vagrantBasedCredentialsHolder;
            boolean bl = false;
            boolean bl2 = false;
            VagrantBasedCredentialsHolder it = vagrantBasedCredentialsHolder2;
            boolean bl3 = false;
            VagrantBasedCredentialsHolder vagrantBasedCredentialsHolder3 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)vagrantBasedCredentialsHolder3, (String)"it");
            remoteCredentials = this.vagrantSupport.getCredentials(vagrantBasedCredentialsHolder3.getVagrantFolder(), it.getMachineName());
        } else {
            remoteCredentials = null;
        }
        return remoteCredentials;
    }

    public PyAddVagrantSdkPanel(@Nullable Project project, @NotNull List<? extends Sdk> existingSdks, @NotNull VagrantSupport vagrantSupport) {
        Intrinsics.checkParameterIsNotNull(existingSdks, (String)"existingSdks");
        Intrinsics.checkParameterIsNotNull((Object)vagrantSupport, (String)"vagrantSupport");
        this.project = project;
        this.existingSdks = existingSdks;
        this.vagrantSupport = vagrantSupport;
        this.statusPanel = new StatusPanel();
        Icon icon = PythonIcons.Python.Vagrant;
        Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"PythonIcons.Python.Vagrant");
        this.icon = icon;
        this.credentialsEditor = new VagrantCredentialsEditor(this.vagrantSupport, this.project, this.statusPanel);
        this.interpreterPathField = new TextFieldWithBrowseButton((JTextField)new JBTextField("/usr/bin/python"));
        this.setLayout(new BorderLayout());
        JBLabel interpreterPathLabel = new JBLabel(PythonProBundle.message("python.interpreter.path"));
        FormBuilder form = new FormBuilder().addComponent((JComponent)this.credentialsEditor.getPanel()).addLabeledComponent((JComponent)interpreterPathLabel, (JComponent)this.interpreterPathField).addComponent((JComponent)this.statusPanel);
        this.credentialsEditor.setAnchor((JComponent)interpreterPathLabel);
        RemoteBrowseActionListener.addShowBrowseRemoteDialogAction((TextFieldWithBrowseButton)this.interpreterPathField, (String)"Select Python Interpreter", (AsyncProducer)((AsyncProducer)new AsyncProducer<RemoteCredentials>(){

            public final void produce(@NotNull Consumer<? super RemoteCredentials> consumer) {
                block0: {
                    Intrinsics.checkParameterIsNotNull(consumer, (String)"consumer");
                    RemoteCredentials remoteCredentials = this.computeRemoteCredentials();
                    if (remoteCredentials == null) break block0;
                    RemoteCredentials remoteCredentials2 = remoteCredentials;
                    boolean bl = false;
                    boolean bl2 = false;
                    RemoteCredentials it = remoteCredentials2;
                    boolean bl3 = false;
                    consumer.consume((Object)it);
                }
            }
        }));
        FormBuilder formBuilder = form;
        Intrinsics.checkExpressionValueIsNotNull((Object)formBuilder, (String)"form");
        this.add((Component)formBuilder.getPanel(), "North");
    }
}

