/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.remote;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.ui.Messages;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.CredentialsTypeUtil;
import com.intellij.remote.VagrantSupport;
import com.intellij.util.ArrayUtilRt;
import com.jetbrains.python.console.PyConsoleProcessHandler;
import com.jetbrains.python.console.PydevConsoleCommunication;
import com.jetbrains.python.console.PythonConsoleView;
import com.jetbrains.python.remote.PyCreateRemoteInterpreterDialog;
import com.jetbrains.python.remote.PyCredentialsContribution;
import com.jetbrains.python.remote.PyEditRemoteInterpreterDialog;
import com.jetbrains.python.remote.PyRemoteFilesChooser;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalData;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.remote.PyRemoteSdkEditor;
import com.jetbrains.python.remote.PyRemoteSocketToLocalHostProvider;
import com.jetbrains.python.remote.PythonRemoteInterpreterManager;
import com.jetbrains.python.remote.console.PyRemoteConsoleProcessHandler;
import java.nio.charset.Charset;
import java.util.Collection;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyRemoteInterpreterManagerImpl
extends PythonRemoteInterpreterManager {
    @Override
    @NotNull
    public SdkAdditionalData loadRemoteSdkData(@NotNull Sdk sdk, @Nullable Element additional) {
        if (sdk == null) {
            PyRemoteInterpreterManagerImpl.$$$reportNull$$$0(0);
        }
        PyRemoteSdkAdditionalData pyRemoteSdkAdditionalData = PyRemoteSdkAdditionalData.loadRemote(sdk, additional);
        if (pyRemoteSdkAdditionalData == null) {
            PyRemoteInterpreterManagerImpl.$$$reportNull$$$0(1);
        }
        return pyRemoteSdkAdditionalData;
    }

    @Override
    @NotNull
    public PyConsoleProcessHandler createConsoleProcessHandler(@NotNull Process process2, @NotNull PythonConsoleView view, @NotNull PydevConsoleCommunication consoleCommunication, @NotNull String commandLine, @NotNull Charset charset, @Nullable PyRemotePathMapper pathMapper, @NotNull PyRemoteSocketToLocalHostProvider remoteSocketProvider) {
        if (process2 == null) {
            PyRemoteInterpreterManagerImpl.$$$reportNull$$$0(2);
        }
        if (view == null) {
            PyRemoteInterpreterManagerImpl.$$$reportNull$$$0(3);
        }
        if (consoleCommunication == null) {
            PyRemoteInterpreterManagerImpl.$$$reportNull$$$0(4);
        }
        if (commandLine == null) {
            PyRemoteInterpreterManagerImpl.$$$reportNull$$$0(5);
        }
        if (charset == null) {
            PyRemoteInterpreterManagerImpl.$$$reportNull$$$0(6);
        }
        if (remoteSocketProvider == null) {
            PyRemoteInterpreterManagerImpl.$$$reportNull$$$0(7);
        }
        return new PyRemoteConsoleProcessHandler(process2, view, consoleCommunication, commandLine, charset, pathMapper, remoteSocketProvider);
    }

    @Override
    public boolean editSdk(@NotNull Project project, @NotNull SdkModificator sdkModificator, @NotNull Collection<Sdk> existingSdks) {
        if (project == null) {
            PyRemoteInterpreterManagerImpl.$$$reportNull$$$0(8);
        }
        if (sdkModificator == null) {
            PyRemoteInterpreterManagerImpl.$$$reportNull$$$0(9);
        }
        if (existingSdks == null) {
            PyRemoteInterpreterManagerImpl.$$$reportNull$$$0(10);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (sdkModificator.getSdkAdditionalData() instanceof PyRemoteSdkAdditionalData) {
            Sdk newSdk;
            PyRemoteSdkAdditionalData newData;
            PyRemoteSdkAdditionalData data = (PyRemoteSdkAdditionalData)sdkModificator.getSdkAdditionalData();
            CredentialsType credentialsType = data.connectionCredentials().getRemoteConnectionType();
            if (!CredentialsTypeUtil.isCredentialsTypeSupportedForLanguage((CredentialsType)credentialsType, PyCredentialsContribution.class)) {
                Messages.showErrorDialog((Project)project, (String)ExecutionBundle.message((String)"remote.interpreter.cannot.load.interpreter.message", (Object[])new Object[]{credentialsType.getName()}), (String)ExecutionBundle.message((String)"remote.interpreter.cannot.load.interpreter.title", (Object[])new Object[0]));
                return false;
            }
            PyEditRemoteInterpreterDialog dialog = PyRemoteSdkEditor.Companion.sdkEditor(data, project, existingSdks);
            if (dialog == null) {
                dialog = new PyCreateRemoteInterpreterDialog(project, existingSdks);
            }
            dialog.setEditing(data);
            dialog.setSdkName(sdkModificator.getName());
            if (!(!dialog.showAndGet() || (newData = (PyRemoteSdkAdditionalData)(newSdk = dialog.getSdk()).getSdkAdditionalData()) == null || newData.equals(data) && newSdk.getName().equals(sdkModificator.getName()))) {
                newData.copyTo(data);
                sdkModificator.setName(newSdk.getName());
                sdkModificator.setHomePath(newSdk.getHomePath());
                return true;
            }
        } else {
            throw new IllegalStateException("Not implemented yet");
        }
        return false;
    }

    @Override
    public void runVagrant(@NotNull String vagrantFolder, @Nullable String machineName) throws ExecutionException {
        VagrantSupport vs;
        if (vagrantFolder == null) {
            PyRemoteInterpreterManagerImpl.$$$reportNull$$$0(11);
        }
        if ((vs = VagrantSupport.getInstance()) == null) {
            throw new IllegalStateException("Vagrant Support unavailable");
        }
        vs.runVagrant(vagrantFolder, machineName);
    }

    @Override
    public String @NotNull [] chooseRemoteFiles(@NotNull Project project, @NotNull PyRemoteSdkAdditionalDataBase data, boolean foldersOnly) throws ExecutionException, InterruptedException {
        PyRemoteFilesChooser chooser;
        if (project == null) {
            PyRemoteInterpreterManagerImpl.$$$reportNull$$$0(12);
        }
        if (data == null) {
            PyRemoteInterpreterManagerImpl.$$$reportNull$$$0(13);
        }
        if (data instanceof PyRemoteSdkAdditionalData && (chooser = PyRemoteSdkEditor.Companion.filesChooser((PyRemoteSdkAdditionalData)data)) != null) {
            String[] stringArray = chooser.chooseRemoteFiles(project, data, foldersOnly);
            if (stringArray == null) {
                PyRemoteInterpreterManagerImpl.$$$reportNull$$$0(14);
            }
            return stringArray;
        }
        if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
            PyRemoteInterpreterManagerImpl.$$$reportNull$$$0(15);
        }
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 1: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/remote/PyRemoteInterpreterManagerImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleCommunication";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteSocketProvider";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkModificator";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingSdks";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vagrantFolder";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/remote/PyRemoteInterpreterManagerImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "loadRemoteSdkData";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "chooseRemoteFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadRemoteSdkData";
                break;
            }
            case 1: 
            case 14: 
            case 15: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createConsoleProcessHandler";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "editSdk";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "runVagrant";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "chooseRemoteFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

