/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.remote;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remote.RemoteSdkFactoryImpl;
import com.jetbrains.python.remote.PyRemoteInterpreterUtil;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalData;
import com.jetbrains.python.sdk.PythonSdkType;
import java.awt.Component;
import java.util.Collection;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyRemoteInterpreterFactory
extends RemoteSdkFactoryImpl<PyRemoteSdkAdditionalData> {
    @Nullable
    protected String getSdkVersion(Project project, @NotNull PyRemoteSdkAdditionalData data) throws RemoteSdkException {
        if (data == null) {
            PyRemoteInterpreterFactory.$$$reportNull$$$0(0);
        }
        return PyRemoteInterpreterUtil.getInterpreterVersion(project, data, true);
    }

    @NotNull
    protected ProjectJdkImpl createSdk(@NotNull Collection<Sdk> existingSdks, @NotNull SdkType sdkType, @NotNull PyRemoteSdkAdditionalData data, @Nullable String sdkName) {
        if (existingSdks == null) {
            PyRemoteInterpreterFactory.$$$reportNull$$$0(1);
        }
        if (sdkType == null) {
            PyRemoteInterpreterFactory.$$$reportNull$$$0(2);
        }
        if (data == null) {
            PyRemoteInterpreterFactory.$$$reportNull$$$0(3);
        }
        ProjectJdkImpl projectJdkImpl = SdkConfigurationUtil.createSdk(existingSdks, (String)this.generateSdkHomePath(data), (SdkType)sdkType, (SdkAdditionalData)data, (String)sdkName);
        if (projectJdkImpl == null) {
            PyRemoteInterpreterFactory.$$$reportNull$$$0(4);
        }
        return projectJdkImpl;
    }

    public String getDefaultUnfinishedName() {
        return PyRemoteInterpreterFactory.getDefaultUnfinishedInterpreterName((String)this.sdkName());
    }

    @NotNull
    public String sdkName() {
        return "Python";
    }

    @NotNull
    protected SdkType getSdkType(@NotNull PyRemoteSdkAdditionalData data) {
        if (data == null) {
            PyRemoteInterpreterFactory.$$$reportNull$$$0(5);
        }
        PythonSdkType pythonSdkType = PythonSdkType.getInstance();
        if (pythonSdkType == null) {
            PyRemoteInterpreterFactory.$$$reportNull$$$0(6);
        }
        return pythonSdkType;
    }

    public boolean canSaveUnfinished() {
        return true;
    }

    @NotNull
    protected String getSdkName(@NotNull PyRemoteSdkAdditionalData data, String version) {
        if (data == null) {
            PyRemoteInterpreterFactory.$$$reportNull$$$0(7);
        }
        if (version == null) {
            version = " unknown interpreter";
        }
        String string = "Remote " + version + " " + data.getPresentableDetails();
        if (string == null) {
            PyRemoteInterpreterFactory.$$$reportNull$$$0(8);
        }
        return string;
    }

    public void initSdk(@NotNull Sdk sdk, @Nullable Project project, @Nullable Component ownerComponent) throws RemoteSdkException {
        if (sdk == null) {
            PyRemoteInterpreterFactory.$$$reportNull$$$0(9);
        }
        try {
            ((PythonSdkType)sdk.getSdkType()).setupSdkPaths(sdk);
        }
        catch (Exception e) {
            throw new RemoteSdkException(e.getMessage(), (Throwable)e);
        }
    }

    @NotNull
    public static PyRemoteInterpreterFactory getInstance() {
        PyRemoteInterpreterFactory pyRemoteInterpreterFactory = (PyRemoteInterpreterFactory)((Object)Objects.requireNonNull(ApplicationManager.getApplication().getService(PyRemoteInterpreterFactory.class)));
        if (pyRemoteInterpreterFactory == null) {
            PyRemoteInterpreterFactory.$$$reportNull$$$0(10);
        }
        return pyRemoteInterpreterFactory;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingSdks";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkType";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/remote/PyRemoteInterpreterFactory";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/remote/PyRemoteInterpreterFactory";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createSdk";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSdkVersion";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createSdk";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSdkType";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSdkName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "initSdk";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

