/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.remote;

import com.google.common.collect.Lists;
import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.remote.RemoteSdkCredentials;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.remotesdk.CredentialsDeployable;
import com.jetbrains.plugins.remotesdk.RemoteTransfer;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.ExecutionContext;
import com.jetbrains.plugins.webDeployment.PublishUtils;
import com.jetbrains.plugins.webDeployment.TransferOperation;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import com.jetbrains.python.remote.PyRemoteSdkCredentials;
import com.jetbrains.python.remote.PyRemoteSourceItem;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyHelpersDownload
extends RemoteTransfer {
    private static final Logger LOG = Logger.getInstance(PyHelpersDownload.class);

    private PyHelpersDownload(@Nullable Project project, @Nullable Component component, @NotNull RemoteSdkCredentials remoteSdkCredentials) {
        if (remoteSdkCredentials == null) {
            PyHelpersDownload.$$$reportNull$$$0(0);
        }
        super(project, component, remoteSdkCredentials);
    }

    public void downloadFromRemote(final @NotNull List<PathMappingSettings.PathMapping> mappings) {
        if (mappings == null) {
            PyHelpersDownload.$$$reportNull$$$0(1);
        }
        String myTitle = "Copying remote files...";
        Project project = this.getProject();
        Task.Backgroundable process2 = new Task.Backgroundable(project, "Copying remote files...", false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                indicator.setFraction(0.0);
                PerformanceWatcher.Snapshot snapshot = PerformanceWatcher.takeSnapshot();
                CredentialsDeployable deployable = new CredentialsDeployable();
                PyHelpersDownload.this.getHelpersTransferConfig().createFileTransferConfig(deployable);
                deployable.setId("CopyFromRemote" + deployable.toString());
                try {
                    RemoteConnection connection = PyHelpersDownload.this.openConnection(this.myTitle, (Deployable)deployable, indicator);
                    RemoteTransfer.RemoteSdkExecutionContext context = PyHelpersDownload.this.getRemoteSdkExecutionContext(indicator, connection, (Deployable)deployable);
                    context.setServerSideModification(false);
                    ArrayList operations = Lists.newArrayList();
                    for (PathMappingSettings.PathMapping mapping : mappings) {
                        FileObject source2 = connection.resolveFile(mapping.getRemoteRoot());
                        FileObject target = DeploymentPathUtils.getLocalFile((String)mapping.getLocalRoot());
                        operations.add(new TransferOperation.Copy(source2, target));
                    }
                    RemoteTransfer.executeOperationsBatch((ProgressIndicator)indicator, (RemoteTransfer.RemoteSdkExecutionContext)context, (List)operations);
                }
                catch (FileSystemException e) {
                    LOG.warn((Throwable)e);
                    PublishUtils.showLoginDialogAfterAuthFail((Throwable)e, (Deployable)deployable);
                }
                PyHelpersDownload.this.getHelpersTransferConfig().setHelpersVersionChecked(true);
                snapshot.logResponsivenessSinceCreation("Downloading remote files");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/remote/PyHelpersDownload$1", "run"));
            }
        };
        if (!ProgressManager.getInstance().hasProgressIndicator()) {
            UIUtil.invokeAndWaitIfNeeded(() -> ProgressManager.getInstance().run((Task)process2));
        } else {
            process2.run(ProgressManager.getInstance().getProgressIndicator());
        }
    }

    public void transferSources(Collection<PyRemoteSourceItem> list, String localFolder) throws FileSystemException {
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        CredentialsDeployable deployable = new CredentialsDeployable();
        deployable.setId("DownloadSkeletons" + deployable.toString());
        this.getHelpersTransferConfig().createFileTransferConfig(deployable);
        RemoteConnection connection = this.openConnection("Downloading remote skeletons and libraries", (Deployable)deployable, indicator);
        ArrayList transferOperations = Lists.newArrayList();
        for (PyRemoteSourceItem item : list) {
            if (!item.shouldCopy(localFolder)) continue;
            transferOperations.add(PyHelpersDownload.createCopyOperation(item, connection, localFolder));
        }
        RemoteTransfer.RemoteSdkExecutionContext context = this.getRemoteSdkExecutionContext(indicator, connection, (Deployable)deployable);
        context.setServerSideModification(false);
        for (TransferOperation operation : transferOperations) {
            context.getProgressIndicator().checkCanceled();
            context.getProgressIndicator().setText(operation.getProgressText((ExecutionContext)context));
            operation.execute((ExecutionContext)context);
        }
    }

    public static void downloadFromRemote(@Nullable Project project, @Nullable Component component, @NotNull RemoteSdkCredentials data, @NotNull List<PathMappingSettings.PathMapping> mappings) {
        if (data == null) {
            PyHelpersDownload.$$$reportNull$$$0(2);
        }
        if (mappings == null) {
            PyHelpersDownload.$$$reportNull$$$0(3);
        }
        new PyHelpersDownload(project, component, data).downloadFromRemote(mappings);
    }

    public static void transferSources(Sdk sdk, Project project, Component component, PyRemoteSdkCredentials data, Collection<PyRemoteSourceItem> sources, String folder) throws FileSystemException {
        new PyHelpersDownload(project, component, data).transferSources(sources, folder);
    }

    private static TransferOperation createCopyOperation(PyRemoteSourceItem item, RemoteConnection connection, String localFolder) throws FileSystemException {
        FileObject source2 = connection.resolveFile(item.getPath());
        FileObject target = DeploymentPathUtils.getLocalFile((String)item.getLocalFile(localFolder).getPath());
        return new TransferOperation.Copy(source2, target);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteSdkCredentials";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/remote/PyHelpersDownload";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "downloadFromRemote";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

