/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.changeSignature;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.ParameterInfo;
import com.intellij.refactoring.changeSignature.ParameterTableModelBase;
import com.intellij.refactoring.changeSignature.ParameterTableModelItemBase;
import com.intellij.refactoring.ui.CodeFragmentTableCellRenderer;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.EditorTextField;
import com.intellij.util.ui.ColumnInfo;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.refactoring.changeSignature.PyExpressionCodeFragment;
import com.jetbrains.python.refactoring.changeSignature.PyParameterInfo;
import com.jetbrains.python.refactoring.changeSignature.PyParameterTableModelItem;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.AbstractCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.Nullable;

public class PyParameterTableModel
extends ParameterTableModelBase<PyParameterInfo, PyParameterTableModelItem> {
    private final Project myProject;

    public PyParameterTableModel(PyParameterList typeContext, PsiElement defaultValueContext, Project project) {
        super((PsiElement)typeContext, defaultValueContext, PyParameterTableModel.getColumns(project));
        this.myProject = project;
    }

    private static ColumnInfo[] getColumns(Project project) {
        ArrayList<Object> result = new ArrayList<Object>();
        result.add((Object)new PyParameterColumn(project));
        result.add((Object)new PyDefaultValueColumn(project));
        return result.toArray(ColumnInfo.EMPTY_ARRAY);
    }

    protected PyParameterTableModelItem createRowItem(@Nullable PyParameterInfo parameterInfo) {
        if (parameterInfo == null) {
            parameterInfo = new PyParameterInfo(-1);
        }
        String defaultValue = parameterInfo.getDefaultValue();
        PyExpressionCodeFragment defaultValueFragment = new PyExpressionCodeFragment(this.myProject, StringUtil.notNullize((String)defaultValue), StringUtil.notNullize((String)defaultValue));
        boolean defaultInSignature = parameterInfo.getDefaultInSignature();
        return new PyParameterTableModelItem(parameterInfo, defaultValueFragment, defaultValueFragment, defaultInSignature);
    }

    private static class MyCodeFragmentTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private Document myDocument;
        protected PsiCodeFragment myCodeFragment;
        private final Project myProject;
        private final FileType myFileType;
        protected EditorTextField myEditorTextField;

        MyCodeFragmentTableCellEditor(Project project) {
            this.myProject = project;
            this.myFileType = PythonFileType.INSTANCE;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value2, boolean isSelected, int row, int column) {
            this.myCodeFragment = (PsiCodeFragment)((Pair)value2).getFirst();
            this.myDocument = PsiDocumentManager.getInstance((Project)this.myProject).getDocument((PsiFile)this.myCodeFragment);
            JPanel panel2 = new JPanel();
            this.myEditorTextField = this.createEditorField(this.myDocument);
            if (this.myEditorTextField != null) {
                this.myEditorTextField.setDocument(this.myDocument);
                this.myEditorTextField.setBorder((Border)new LineBorder(table.getSelectionBackground()));
            }
            panel2.add((Component)this.myEditorTextField);
            panel2.add(new JCheckBox());
            return panel2;
        }

        protected EditorTextField createEditorField(Document document) {
            EditorTextField field = new EditorTextField(document, this.myProject, this.myFileType){

                protected boolean shouldHaveBorder() {
                    return false;
                }
            };
            field.setBorder((Border)new EmptyBorder(1, 1, 1, 1));
            return field;
        }

        public PsiCodeFragment getCellEditorValue() {
            return this.myCodeFragment;
        }
    }

    private static class MyCodeFragmentTableCellRenderer
    extends CodeFragmentTableCellRenderer {
        MyCodeFragmentTableCellRenderer(Project project) {
            super(project);
        }

        public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
            JPanel panel2 = new JPanel();
            Component component = super.getTableCellRendererComponent(table, ((Pair)value2).getFirst(), isSelected, hasFocus, row, column);
            panel2.add(component);
            Component component1 = new BooleanTableCellRenderer().getTableCellRendererComponent(table, ((Pair)value2).getSecond(), isSelected, hasFocus, row, column);
            panel2.add(component1);
            return panel2;
        }
    }

    protected static class PyDefaultValueColumn<P extends ParameterInfo, TableItem extends ParameterTableModelItemBase<P>>
    extends ParameterTableModelBase.ColumnInfoBase<P, TableItem, Pair<PsiCodeFragment, Boolean>> {
        private final Project myProject;

        public PyDefaultValueColumn(Project project) {
            super(RefactoringBundle.message((String)"column.name.default.value"));
            this.myProject = project;
        }

        public boolean isCellEditable(TableItem item) {
            return true;
        }

        public Pair<PsiCodeFragment, Boolean> valueOf(TableItem item) {
            return new Pair((Object)((ParameterTableModelItemBase)item).defaultValueCodeFragment, (Object)((PyParameterTableModelItem)((Object)item)).isDefaultInSignature());
        }

        public void setValue(TableItem item, Pair<PsiCodeFragment, Boolean> value2) {
            PyParameterInfo parameter = (PyParameterInfo)((ParameterTableModelItemBase)item).parameter;
            parameter.setDefaultValue(((PsiCodeFragment)value2.getFirst()).getText().trim());
            parameter.setDefaultInSignature((Boolean)value2.getSecond());
        }

        public TableCellRenderer doCreateRenderer(TableItem item) {
            return new MyCodeFragmentTableCellRenderer(this.myProject);
        }

        public TableCellEditor doCreateEditor(TableItem item) {
            return new MyCodeFragmentTableCellEditor(this.myProject);
        }
    }

    private static class PyParameterColumn
    extends ParameterTableModelBase.NameColumn<PyParameterInfo, PyParameterTableModelItem> {
        PyParameterColumn(Project project) {
            super(project);
        }
    }
}

