/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyStringFormatParser;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyConditionalExpression;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyLambdaExpression;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyPrefixExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySliceExpression;
import com.jetbrains.python.psi.PyStarArgument;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyStringLiteralUtil;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.PyTypeParser;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyReplaceExpressionUtil
implements PyElementTypes {
    public static final Key<Pair<PsiElement, TextRange>> SELECTION_BREAKS_AST_NODE = new Key("python.selection.breaks.ast.node");

    private PyReplaceExpressionUtil() {
    }

    public static boolean isNeedParenthesis(@NotNull PyElement oldExpr, @NotNull PyElement newExpr) {
        PyBinaryExpression binaryExpression;
        PyElement parentExpr;
        if (oldExpr == null) {
            PyReplaceExpressionUtil.$$$reportNull$$$0(0);
        }
        if (newExpr == null) {
            PyReplaceExpressionUtil.$$$reportNull$$$0(1);
        }
        if ((parentExpr = (PyElement)oldExpr.getParent()) instanceof PyArgumentList) {
            return newExpr instanceof PyTupleExpression;
        }
        if (parentExpr instanceof PyParenthesizedExpression || !(parentExpr instanceof PyExpression)) {
            return false;
        }
        int newPriority = PyReplaceExpressionUtil.getExpressionPriority(newExpr);
        int parentPriority = PyReplaceExpressionUtil.getExpressionPriority(parentExpr);
        if (parentPriority > newPriority) {
            return true;
        }
        return parentPriority == newPriority && parentPriority != 0 && parentExpr instanceof PyBinaryExpression ? PyReplaceExpressionUtil.isNotAssociative(binaryExpression = (PyBinaryExpression)parentExpr) && oldExpr == PyReplaceExpressionUtil.getLeastPrioritySide(binaryExpression) : newExpr instanceof PyConditionalExpression && parentExpr instanceof PyConditionalExpression;
    }

    @Nullable
    private static PyExpression getLeastPrioritySide(@NotNull PyBinaryExpression expression) {
        if (expression == null) {
            PyReplaceExpressionUtil.$$$reportNull$$$0(2);
        }
        if (expression.isOperator("**")) {
            return expression.getLeftExpression();
        }
        return expression.getRightExpression();
    }

    public static PsiElement replaceExpression(@NotNull PsiElement oldExpression, @NotNull PsiElement newExpression) {
        Pair data;
        if (oldExpression == null) {
            PyReplaceExpressionUtil.$$$reportNull$$$0(3);
        }
        if (newExpression == null) {
            PyReplaceExpressionUtil.$$$reportNull$$$0(4);
        }
        if ((data = (Pair)oldExpression.getUserData(SELECTION_BREAKS_AST_NODE)) != null) {
            PsiElement element = (PsiElement)data.first;
            TextRange textRange = (TextRange)data.second;
            String parentText = element.getText();
            String prefix = parentText.substring(0, textRange.getStartOffset());
            String suffix = parentText.substring(textRange.getEndOffset(), element.getTextLength());
            PyElementGenerator generator = PyElementGenerator.getInstance(oldExpression.getProject());
            LanguageLevel languageLevel = LanguageLevel.forElement(oldExpression);
            if (element instanceof PyStringLiteralExpression) {
                return PyReplaceExpressionUtil.replaceSubstringInStringLiteral((PyStringLiteralExpression)element, newExpression, textRange);
            }
            PyElement newElement = generator.createFromText(languageLevel, PyElement.class, prefix + newExpression.getText() + suffix);
            return element.replace((PsiElement)newElement);
        }
        return oldExpression.replace(newExpression);
    }

    @Nullable
    private static PsiElement replaceSubstringInStringLiteral(@NotNull PyStringLiteralExpression oldExpression, @NotNull PsiElement newExpression, @NotNull TextRange textRange) {
        boolean hasSubstitutions;
        String fullText;
        Pair detectedQuotes;
        if (oldExpression == null) {
            PyReplaceExpressionUtil.$$$reportNull$$$0(5);
        }
        if (newExpression == null) {
            PyReplaceExpressionUtil.$$$reportNull$$$0(6);
        }
        if (textRange == null) {
            PyReplaceExpressionUtil.$$$reportNull$$$0(7);
        }
        Pair quotes = (detectedQuotes = PyStringLiteralUtil.getQuotes(fullText = oldExpression.getText())) != null ? detectedQuotes : Pair.create((Object)"'", (Object)"'");
        String prefix = fullText.substring(0, textRange.getStartOffset());
        String suffix = fullText.substring(textRange.getEndOffset(), oldExpression.getTextLength());
        PyExpression formatValue = PyStringFormatParser.getFormatValueExpression(oldExpression);
        PyArgumentList newStyleFormatValue = PyStringFormatParser.getNewStyleFormatValueExpression(oldExpression);
        String newText = newExpression.getText();
        List<PyStringFormatParser.SubstitutionChunk> substitutions = newStyleFormatValue != null ? PyStringFormatParser.filterSubstitutions(PyStringFormatParser.parseNewStyleFormat(fullText)) : PyStringFormatParser.filterSubstitutions(PyStringFormatParser.parsePercentFormat(fullText));
        boolean bl = hasSubstitutions = substitutions.size() > 0;
        if (formatValue != null && !PyReplaceExpressionUtil.containsStringFormatting(substitutions, textRange)) {
            if (formatValue instanceof PyTupleExpression) {
                return PyReplaceExpressionUtil.replaceSubstringWithTupleFormatting(oldExpression, newExpression, textRange, prefix, suffix, (PyTupleExpression)formatValue, substitutions);
            }
            if (formatValue instanceof PyDictLiteralExpression) {
                return PyReplaceExpressionUtil.replaceSubstringWithDictFormatting(oldExpression, (Pair<String, String>)quotes, prefix, suffix, formatValue, newText);
            }
            TypeEvalContext context = TypeEvalContext.userInitiated(oldExpression.getProject(), oldExpression.getContainingFile());
            PyType valueType = context.getType(formatValue);
            PyBuiltinCache builtinCache = PyBuiltinCache.getInstance(oldExpression);
            PyClassType tupleType = builtinCache.getTupleType();
            PyType mappingType = PyTypeParser.getTypeByName(null, "collections.Mapping", context);
            if (!PyTypeChecker.match((PyType)tupleType, valueType, context) || mappingType != null && !PyTypeChecker.match(mappingType, valueType, context)) {
                return PyReplaceExpressionUtil.replaceSubstringWithSingleValueFormatting(oldExpression, textRange, prefix, suffix, formatValue, newText, substitutions);
            }
        }
        if (newStyleFormatValue != null && hasSubstitutions && !PyReplaceExpressionUtil.containsStringFormatting(substitutions, textRange)) {
            PyExpression[] arguments = newStyleFormatValue.getArguments();
            boolean hasStarArguments = false;
            for (PyExpression argument : arguments) {
                if (!(argument instanceof PyStarArgument)) continue;
                hasStarArguments = true;
                break;
            }
            if (!hasStarArguments) {
                return PyReplaceExpressionUtil.replaceSubstringWithNewStyleFormatting(oldExpression, textRange, prefix, suffix, newStyleFormatValue, newText, substitutions);
            }
        }
        if (PyReplaceExpressionUtil.isConcatFormatting(oldExpression) || hasSubstitutions) {
            return PyReplaceExpressionUtil.replaceSubstringWithConcatFormatting(oldExpression, (Pair<String, String>)quotes, prefix, suffix, newText, hasSubstitutions);
        }
        return PyReplaceExpressionUtil.replaceSubstringWithoutFormatting(oldExpression, prefix, suffix, newText);
    }

    private static PsiElement replaceSubstringWithSingleValueFormatting(PyStringLiteralExpression oldExpression, TextRange textRange, String prefix, String suffix, PyExpression formatValue, String newText, List<PyStringFormatParser.SubstitutionChunk> substitutions) {
        int pos;
        PyElementGenerator generator = PyElementGenerator.getInstance(oldExpression.getProject());
        LanguageLevel languageLevel = LanguageLevel.forElement(oldExpression);
        String newLiteralText = prefix + "%s" + suffix;
        PyStringLiteralExpression newLiteralExpression = generator.createStringLiteralAlreadyEscaped(newLiteralText);
        oldExpression.replace(newLiteralExpression);
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        int i = PyReplaceExpressionUtil.getPositionInRanges(PyStringFormatParser.substitutionsToRanges(substitutions), textRange);
        if (i == 0) {
            pos = builder.toString().length();
            builder.append(newText);
            builder.append(",");
            builder.append(formatValue.getText());
        } else {
            builder.append(formatValue.getText());
            builder.append(",");
            pos = builder.toString().length();
            builder.append(newText);
        }
        builder.append(")");
        PsiElement newElement = formatValue.replace((PsiElement)generator.createExpressionFromText(languageLevel, builder.toString()));
        return newElement.findElementAt(pos);
    }

    private static PsiElement replaceSubstringWithDictFormatting(PyStringLiteralExpression oldExpression, Pair<String, String> quotes, String prefix, String suffix, PyExpression formatValue, String newText) {
        PyElementGenerator generator = PyElementGenerator.getInstance(oldExpression.getProject());
        LanguageLevel languageLevel = LanguageLevel.forElement(oldExpression);
        String newLiteralText = prefix + "%(" + newText + ")s" + suffix;
        PyStringLiteralExpression newLiteralExpression = generator.createStringLiteralAlreadyEscaped(newLiteralText);
        oldExpression.replace(newLiteralExpression);
        PyDictLiteralExpression dict = (PyDictLiteralExpression)formatValue;
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        Object[] elements = dict.getElements();
        builder.append(StringUtil.join((Object[])elements, expression -> expression.getText(), (String)","));
        if (elements.length > 0) {
            builder.append(",");
        }
        builder.append((String)quotes.getSecond());
        builder.append(newText);
        builder.append((String)quotes.getSecond());
        builder.append(":");
        int pos = builder.toString().length();
        builder.append(newText);
        builder.append("}");
        PyExpression newDictLiteral = generator.createExpressionFromText(languageLevel, builder.toString());
        PsiElement newElement = formatValue.replace((PsiElement)newDictLiteral);
        return newElement.findElementAt(pos);
    }

    private static PsiElement replaceSubstringWithTupleFormatting(PyStringLiteralExpression oldExpression, PsiElement newExpression, TextRange textRange, String prefix, String suffix, PyTupleExpression tupleFormatValue, List<PyStringFormatParser.SubstitutionChunk> substitutions) {
        String newLiteralText = prefix + "%s" + suffix;
        PyElementGenerator generator = PyElementGenerator.getInstance(oldExpression.getProject());
        PyStringLiteralExpression newLiteralExpression = generator.createStringLiteralAlreadyEscaped(newLiteralText);
        oldExpression.replace(newLiteralExpression);
        PyExpression[] members = tupleFormatValue.getElements();
        int n = members.length;
        int i = Math.min(n, Math.max(0, PyReplaceExpressionUtil.getPositionInRanges(PyStringFormatParser.substitutionsToRanges(substitutions), textRange)));
        boolean last = i == n;
        PsiElement trailingComma = PyPsiUtils.getNextComma((PsiElement)members[n - 1]);
        if (trailingComma != null) {
            trailingComma.delete();
        }
        PyExpression before = last ? null : members[i];
        PyUtil.addListNode((PsiElement)tupleFormatValue, newExpression, before != null ? before.getNode() : null, i == 0 || !last, last, !last);
        return newExpression;
    }

    private static PsiElement replaceSubstringWithoutFormatting(@NotNull PyStringLiteralExpression oldExpression, @NotNull String prefix, @NotNull String suffix, @NotNull String newText) {
        if (oldExpression == null) {
            PyReplaceExpressionUtil.$$$reportNull$$$0(8);
        }
        if (prefix == null) {
            PyReplaceExpressionUtil.$$$reportNull$$$0(9);
        }
        if (suffix == null) {
            PyReplaceExpressionUtil.$$$reportNull$$$0(10);
        }
        if (newText == null) {
            PyReplaceExpressionUtil.$$$reportNull$$$0(11);
        }
        PyElementGenerator generator = PyElementGenerator.getInstance(oldExpression.getProject());
        LanguageLevel languageLevel = LanguageLevel.forElement(oldExpression);
        PsiElement parent = oldExpression.getParent();
        boolean parensNeeded = parent instanceof PyExpression && !(parent instanceof PyParenthesizedExpression);
        StringBuilder builder = new StringBuilder();
        if (parensNeeded) {
            builder.append("(");
        }
        builder.append(prefix);
        builder.append("%s");
        builder.append(suffix);
        builder.append(" % ");
        int pos = builder.toString().length();
        builder.append(newText);
        if (parensNeeded) {
            builder.append(")");
        }
        PyExpression expression = generator.createExpressionFromText(languageLevel, builder.toString());
        PsiElement newElement = oldExpression.replace((PsiElement)expression);
        return newElement.findElementAt(pos);
    }

    private static PsiElement replaceSubstringWithConcatFormatting(@NotNull PyStringLiteralExpression oldExpression, @NotNull Pair<String, String> quotes, @NotNull String prefix, @NotNull String suffix, @NotNull String newText, boolean hasSubstitutions) {
        if (oldExpression == null) {
            PyReplaceExpressionUtil.$$$reportNull$$$0(12);
        }
        if (quotes == null) {
            PyReplaceExpressionUtil.$$$reportNull$$$0(13);
        }
        if (prefix == null) {
            PyReplaceExpressionUtil.$$$reportNull$$$0(14);
        }
        if (suffix == null) {
            PyReplaceExpressionUtil.$$$reportNull$$$0(15);
        }
        if (newText == null) {
            PyReplaceExpressionUtil.$$$reportNull$$$0(16);
        }
        PyElementGenerator generator = PyElementGenerator.getInstance(oldExpression.getProject());
        LanguageLevel languageLevel = LanguageLevel.forElement(oldExpression);
        String leftQuote = (String)quotes.getFirst();
        String rightQuote = (String)quotes.getSecond();
        StringBuilder builder = new StringBuilder();
        if (hasSubstitutions) {
            builder.append("(");
        }
        if (!leftQuote.endsWith(prefix)) {
            builder.append(prefix).append(rightQuote).append(" + ");
        }
        int pos = builder.toString().length();
        builder.append(newText);
        if (!rightQuote.startsWith(suffix)) {
            builder.append(" + ").append(leftQuote).append(suffix);
        }
        if (hasSubstitutions) {
            builder.append(")");
        }
        PyExpression expression = generator.createExpressionFromText(languageLevel, builder.toString());
        PsiElement newElement = oldExpression.replace((PsiElement)expression);
        return newElement.findElementAt(pos);
    }

    private static PsiElement replaceSubstringWithNewStyleFormatting(@NotNull PyStringLiteralExpression oldExpression, @NotNull TextRange textRange, @NotNull String prefix, @NotNull String suffix, @NotNull PyArgumentList newStyleFormatValue, @NotNull String newText, @NotNull List<PyStringFormatParser.SubstitutionChunk> substitutions) {
        PyStringLiteralExpression newLiteralExpression;
        String newLiteralText;
        if (oldExpression == null) {
            PyReplaceExpressionUtil.$$$reportNull$$$0(17);
        }
        if (textRange == null) {
            PyReplaceExpressionUtil.$$$reportNull$$$0(18);
        }
        if (prefix == null) {
            PyReplaceExpressionUtil.$$$reportNull$$$0(19);
        }
        if (suffix == null) {
            PyReplaceExpressionUtil.$$$reportNull$$$0(20);
        }
        if (newStyleFormatValue == null) {
            PyReplaceExpressionUtil.$$$reportNull$$$0(21);
        }
        if (newText == null) {
            PyReplaceExpressionUtil.$$$reportNull$$$0(22);
        }
        if (substitutions == null) {
            PyReplaceExpressionUtil.$$$reportNull$$$0(23);
        }
        PyElementGenerator generator = PyElementGenerator.getInstance(oldExpression.getProject());
        LanguageLevel languageLevel = LanguageLevel.forElement(oldExpression);
        PyExpression[] arguments = newStyleFormatValue.getArguments();
        boolean hasKeywords = false;
        int maxPosition = -1;
        for (PyStringFormatParser.SubstitutionChunk substitution : substitutions) {
            Integer position;
            if (substitution.getMappingKey() != null) {
                hasKeywords = true;
            }
            if ((position = substitution.getManualPosition()) == null || position <= maxPosition) continue;
            maxPosition = position;
        }
        if (hasKeywords) {
            newLiteralText = prefix + "{" + newText + "}" + suffix;
            newLiteralExpression = generator.createStringLiteralAlreadyEscaped(newLiteralText);
            oldExpression.replace(newLiteralExpression);
            PyKeywordArgument kwarg = generator.createKeywordArgument(languageLevel, newText, newText);
            newStyleFormatValue.addArgument(kwarg);
            return kwarg.getValueExpression();
        }
        if (maxPosition >= 0) {
            newLiteralText = prefix + "{" + (maxPosition + 1) + "}" + suffix;
            newLiteralExpression = generator.createStringLiteralAlreadyEscaped(newLiteralText);
            oldExpression.replace(newLiteralExpression);
            PyExpression arg = generator.createExpressionFromText(languageLevel, newText);
            newStyleFormatValue.addArgument(arg);
            return arg;
        }
        newLiteralText = prefix + "{}" + suffix;
        newLiteralExpression = generator.createStringLiteralAlreadyEscaped(newLiteralText);
        oldExpression.replace(newLiteralExpression);
        int i = PyReplaceExpressionUtil.getPositionInRanges(PyStringFormatParser.substitutionsToRanges(substitutions), textRange);
        PyExpression arg = generator.createExpressionFromText(languageLevel, newText);
        if (i == 0) {
            newStyleFormatValue.addArgumentFirst(arg);
        } else if (i < arguments.length) {
            newStyleFormatValue.addArgumentAfter(arg, arguments[i - 1]);
        } else {
            newStyleFormatValue.addArgument(arg);
        }
        return arg;
    }

    private static int getPositionInRanges(@NotNull List<TextRange> ranges, @NotNull TextRange range) {
        if (ranges == null) {
            PyReplaceExpressionUtil.$$$reportNull$$$0(24);
        }
        if (range == null) {
            PyReplaceExpressionUtil.$$$reportNull$$$0(25);
        }
        int end = range.getEndOffset();
        int size = ranges.size();
        for (int i = 0; i < size; ++i) {
            TextRange r = ranges.get(i);
            if (end >= r.getStartOffset()) continue;
            return i;
        }
        return size;
    }

    private static boolean containsStringFormatting(@NotNull List<PyStringFormatParser.SubstitutionChunk> substitutions, @NotNull TextRange range) {
        if (substitutions == null) {
            PyReplaceExpressionUtil.$$$reportNull$$$0(26);
        }
        if (range == null) {
            PyReplaceExpressionUtil.$$$reportNull$$$0(27);
        }
        List<TextRange> ranges = PyStringFormatParser.substitutionsToRanges(substitutions);
        for (TextRange r : ranges) {
            if (!range.contains(r)) continue;
            return true;
        }
        return false;
    }

    private static boolean isConcatFormatting(PyStringLiteralExpression element) {
        PsiElement parent = element.getParent();
        return parent instanceof PyBinaryExpression && ((PyBinaryExpression)parent).isOperator("+");
    }

    private static boolean isNotAssociative(@NotNull PyBinaryExpression binaryExpression) {
        IElementType opType;
        if (binaryExpression == null) {
            PyReplaceExpressionUtil.$$$reportNull$$$0(28);
        }
        return PyTokenTypes.COMPARISON_OPERATIONS.contains(opType = PyReplaceExpressionUtil.getOperationType(binaryExpression)) || binaryExpression instanceof PySliceExpression || opType == PyTokenTypes.DIV || opType == PyTokenTypes.FLOORDIV || opType == PyTokenTypes.PERC || opType == PyTokenTypes.EXP || opType == PyTokenTypes.MINUS;
    }

    private static int getExpressionPriority(PyElement expr) {
        int priority = 0;
        if (expr instanceof PyReferenceExpression || expr instanceof PySubscriptionExpression || expr instanceof PySliceExpression || expr instanceof PyCallExpression) {
            priority = 1;
        } else if (expr instanceof PyPrefixExpression) {
            IElementType opType = PyReplaceExpressionUtil.getOperationType(expr);
            if (opType == PyTokenTypes.PLUS || opType == PyTokenTypes.MINUS || opType == PyTokenTypes.TILDE) {
                priority = 2;
            }
            if (opType == PyTokenTypes.NOT_KEYWORD) {
                priority = 11;
            }
        } else if (expr instanceof PyBinaryExpression) {
            IElementType opType = PyReplaceExpressionUtil.getOperationType(expr);
            if (opType == PyTokenTypes.EXP) {
                priority = 3;
            }
            if (opType == PyTokenTypes.MULT || opType == PyTokenTypes.AT || opType == PyTokenTypes.DIV || opType == PyTokenTypes.PERC || opType == PyTokenTypes.FLOORDIV) {
                priority = 4;
            }
            if (opType == PyTokenTypes.PLUS || opType == PyTokenTypes.MINUS) {
                priority = 5;
            }
            if (opType == PyTokenTypes.LTLT || opType == PyTokenTypes.GTGT) {
                priority = 6;
            }
            if (opType == PyTokenTypes.AND) {
                priority = 7;
            }
            if (opType == PyTokenTypes.XOR) {
                priority = 8;
            }
            if (opType == PyTokenTypes.OR) {
                priority = 9;
            }
            if (PyTokenTypes.COMPARISON_OPERATIONS.contains(opType)) {
                priority = 10;
            }
            if (opType == PyTokenTypes.AND_KEYWORD) {
                priority = 12;
            }
            if (opType == PyTokenTypes.OR_KEYWORD) {
                priority = 13;
            }
        } else if (expr instanceof PyConditionalExpression) {
            priority = 14;
        } else if (expr instanceof PyLambdaExpression) {
            priority = 15;
        }
        return -priority;
    }

    @Nullable
    private static IElementType getOperationType(@NotNull PyElement expr) {
        if (expr == null) {
            PyReplaceExpressionUtil.$$$reportNull$$$0(29);
        }
        if (expr instanceof PyBinaryExpression) {
            return ((PyBinaryExpression)expr).getOperator();
        }
        return ((PyPrefixExpression)expr).getOperator();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldExpr";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newExpr";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldExpression";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newExpression";
                break;
            }
            case 7: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 9: 
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 10: 
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 11: 
            case 16: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newText";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quotes";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newStyleFormatValue";
                break;
            }
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutions";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryExpression";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/refactoring/PyReplaceExpressionUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isNeedParenthesis";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getLeastPrioritySide";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceExpression";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceSubstringInStringLiteral";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceSubstringWithoutFormatting";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceSubstringWithConcatFormatting";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceSubstringWithNewStyleFormatting";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "getPositionInRanges";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "containsStringFormatting";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[2] = "isNotAssociative";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[2] = "getOperationType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

