/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi;

import com.google.common.collect.Iterables;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PythonCodeStyleService;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyIndentUtil {
    @NonNls
    public static final String TWO_SPACES = "  ";
    @NonNls
    public static final String FOUR_SPACES = "    ";

    private PyIndentUtil() {
    }

    public static int getLineIndentSize(@NotNull CharSequence line2) {
        char c;
        int stop2;
        if (line2 == null) {
            PyIndentUtil.$$$reportNull$$$0(0);
        }
        for (stop2 = 0; stop2 < line2.length() && ((c = line2.charAt(stop2)) == ' ' || c == '\t'); ++stop2) {
        }
        return stop2;
    }

    @NotNull
    public static String getLineIndent(@NotNull String line2) {
        if (line2 == null) {
            PyIndentUtil.$$$reportNull$$$0(1);
        }
        String string = line2.substring(0, PyIndentUtil.getLineIndentSize(line2));
        if (string == null) {
            PyIndentUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static CharSequence getLineIndent(@NotNull CharSequence line2) {
        if (line2 == null) {
            PyIndentUtil.$$$reportNull$$$0(3);
        }
        CharSequence charSequence = line2.subSequence(0, PyIndentUtil.getLineIndentSize(line2));
        if (charSequence == null) {
            PyIndentUtil.$$$reportNull$$$0(4);
        }
        return charSequence;
    }

    @NotNull
    public static String getElementIndent(@NotNull PsiElement anchor) {
        if (anchor == null) {
            PyIndentUtil.$$$reportNull$$$0(5);
        }
        if (anchor instanceof PsiFile) {
            return "";
        }
        PyStatementList statementList = PyIndentUtil.getAnchorStatementList(anchor);
        if (statementList == null) {
            return "";
        }
        PsiElement prevSibling = statementList.getPrevSibling();
        String whitespace = prevSibling instanceof PsiWhiteSpace ? prevSibling.getText() : "";
        int i = whitespace.lastIndexOf("\n");
        if (i >= 0 && statementList.getStatements().length != 0) {
            String string = whitespace.substring(i + 1);
            if (string == null) {
                PyIndentUtil.$$$reportNull$$$0(6);
            }
            return string;
        }
        return PyIndentUtil.getExpectedBlockIndent(statementList);
    }

    @NotNull
    private static String getExpectedBlockIndent(@NotNull PyStatementList anchor) {
        if (anchor == null) {
            PyIndentUtil.$$$reportNull$$$0(7);
        }
        String indentStep = PyIndentUtil.getIndentFromSettings(anchor.getContainingFile());
        PyStatementList parentBlock = (PyStatementList)PsiTreeUtil.getParentOfType((PsiElement)anchor, PyStatementList.class, (boolean)true);
        if (parentBlock != null) {
            String string = PyIndentUtil.getElementIndent((PsiElement)parentBlock) + indentStep;
            if (string == null) {
                PyIndentUtil.$$$reportNull$$$0(8);
            }
            return string;
        }
        String string = indentStep;
        if (string == null) {
            PyIndentUtil.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Nullable
    private static PyStatementList getAnchorStatementList(@NotNull PsiElement element) {
        if (element == null) {
            PyIndentUtil.$$$reportNull$$$0(10);
        }
        PyStatementList statementList = null;
        if (element instanceof PsiWhiteSpace) {
            statementList = PyUtil.as(element.getNextSibling(), PyStatementList.class);
        }
        if (statementList == null) {
            statementList = (PyStatementList)PsiTreeUtil.getParentOfType((PsiElement)element, PyStatementList.class, (boolean)false);
        }
        return statementList;
    }

    public static boolean areTabsUsedForIndentation(@NotNull PsiFile file2) {
        if (file2 == null) {
            PyIndentUtil.$$$reportNull$$$0(11);
        }
        return PythonCodeStyleService.getInstance().isTabIndentation(file2);
    }

    public static int getIndentSizeFromSettings(@NotNull PsiFile file2) {
        if (file2 == null) {
            PyIndentUtil.$$$reportNull$$$0(12);
        }
        return PythonCodeStyleService.getInstance().getIndentSize(file2);
    }

    @NotNull
    public static String getIndentFromSettings(@NotNull PsiFile file2) {
        boolean useTabs;
        if (file2 == null) {
            PyIndentUtil.$$$reportNull$$$0(13);
        }
        String string = (useTabs = PyIndentUtil.areTabsUsedForIndentation(file2)) ? "\t" : StringUtil.repeatSymbol((char)' ', (int)PyIndentUtil.getIndentSizeFromSettings(file2));
        if (string == null) {
            PyIndentUtil.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    public static List<String> removeCommonIndent(@NotNull Iterable<String> lines, boolean ignoreFirstLine) {
        if (lines == null) {
            PyIndentUtil.$$$reportNull$$$0(15);
        }
        return PyIndentUtil.changeIndent(lines, ignoreFirstLine, "");
    }

    @NotNull
    public static String removeCommonIndent(@NotNull String s, boolean ignoreFirstLine) {
        if (s == null) {
            PyIndentUtil.$$$reportNull$$$0(16);
        }
        List<String> trimmed = PyIndentUtil.removeCommonIndent(LineTokenizer.tokenizeIntoList((CharSequence)s, (boolean)false, (boolean)false), ignoreFirstLine);
        String string = StringUtil.join(trimmed, (String)"\n");
        if (string == null) {
            PyIndentUtil.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    public static String changeIndent(@NotNull String s, boolean ignoreFirstLine, String newIndent) {
        if (s == null) {
            PyIndentUtil.$$$reportNull$$$0(18);
        }
        List<String> trimmed = PyIndentUtil.changeIndent(LineTokenizer.tokenizeIntoList((CharSequence)s, (boolean)false, (boolean)false), ignoreFirstLine, newIndent);
        String string = StringUtil.join(trimmed, (String)"\n");
        if (string == null) {
            PyIndentUtil.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    public static List<String> changeIndent(@NotNull Iterable<String> lines, boolean ignoreFirstLine, String newIndent) {
        if (lines == null) {
            PyIndentUtil.$$$reportNull$$$0(20);
        }
        String oldIndent = PyIndentUtil.findCommonIndent(lines, ignoreFirstLine);
        if (Iterables.isEmpty(lines)) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                PyIndentUtil.$$$reportNull$$$0(21);
            }
            return list;
        }
        List result = ContainerUtil.map((Iterable)Iterables.skip(lines, (int)(ignoreFirstLine ? 1 : 0)), line2 -> {
            if (StringUtil.isEmptyOrSpaces((String)line2)) {
                return "";
            }
            return newIndent + line2.substring(oldIndent.length());
        });
        if (ignoreFirstLine) {
            List list = ContainerUtil.prepend((List)result, (Object[])new String[]{(String)Iterables.get(lines, (int)0)});
            if (list == null) {
                PyIndentUtil.$$$reportNull$$$0(22);
            }
            return list;
        }
        List list = result;
        if (list == null) {
            PyIndentUtil.$$$reportNull$$$0(23);
        }
        return list;
    }

    @NotNull
    public static String findCommonIndent(@NotNull String s, boolean ignoreFirstLine) {
        if (s == null) {
            PyIndentUtil.$$$reportNull$$$0(24);
        }
        return PyIndentUtil.findCommonIndent(LineTokenizer.tokenizeIntoList((CharSequence)s, (boolean)false, (boolean)false), ignoreFirstLine);
    }

    @NotNull
    public static String findCommonIndent(@NotNull Iterable<String> lines, boolean ignoreFirstLine) {
        if (lines == null) {
            PyIndentUtil.$$$reportNull$$$0(25);
        }
        String minIndent = null;
        boolean allLinesEmpty = true;
        if (Iterables.isEmpty(lines)) {
            return "";
        }
        boolean hasBadEmptyLineIndent = false;
        for (String line2 : Iterables.skip(lines, (int)(ignoreFirstLine ? 1 : 0))) {
            boolean lineEmpty = StringUtil.isEmptyOrSpaces((String)line2);
            if (lineEmpty && !allLinesEmpty) continue;
            String indent = PyIndentUtil.getLineIndent(line2);
            if (minIndent == null || !lineEmpty && allLinesEmpty || minIndent.startsWith(indent)) {
                minIndent = indent;
            } else if (!indent.startsWith(minIndent)) {
                if (lineEmpty) {
                    hasBadEmptyLineIndent = true;
                } else {
                    return "";
                }
            }
            allLinesEmpty &= lineEmpty;
        }
        if (allLinesEmpty && hasBadEmptyLineIndent) {
            return "";
        }
        String string = StringUtil.notNullize(minIndent);
        if (string == null) {
            PyIndentUtil.$$$reportNull$$$0(26);
        }
        return string;
    }

    @NotNull
    public static String getLineIndent(@NotNull Document document, int lineNumber) {
        if (document == null) {
            PyIndentUtil.$$$reportNull$$$0(27);
        }
        TextRange lineRange = TextRange.create((int)document.getLineStartOffset(lineNumber), (int)document.getLineEndOffset(lineNumber));
        String line2 = document.getText(lineRange);
        return PyIndentUtil.getLineIndent(line2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/PyIndentUtil";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: 
            case 20: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 16: 
            case 18: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/PyIndentUtil";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineIndent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementIndent";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedBlockIndent";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndentFromSettings";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "removeCommonIndent";
                break;
            }
            case 19: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "changeIndent";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "findCommonIndent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLineIndentSize";
                break;
            }
            case 1: 
            case 3: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getLineIndent";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 26: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getElementIndent";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getExpectedBlockIndent";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getAnchorStatementList";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "areTabsUsedForIndentation";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getIndentSizeFromSettings";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getIndentFromSettings";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "removeCommonIndent";
                break;
            }
            case 18: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "changeIndent";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findCommonIndent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

