/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.profiler.lines;

import com.intellij.codeInsight.hint.EditorFragmentComponent;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.coverage.LineMarkerRendererWithErrorStripe;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.ActiveGutterRenderer;
import com.intellij.openapi.editor.markup.LineMarkerRendererEx;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ColoredSideBorder;
import com.intellij.ui.HintHint;
import com.intellij.ui.LightweightHint;
import com.intellij.util.Function;
import com.jetbrains.python.profiler.PythonProfilerBundle;
import com.jetbrains.python.profiler.lines.HideProfileInfoAction;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.TreeMap;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProfileLineMarkerRenderer
implements ActiveGutterRenderer,
LineMarkerRendererWithErrorStripe {
    private static final int THICKNESS = 8;
    private final int myLineNumer;
    private final TreeMap<Integer, LineData> myLines;
    private final Function<? super Integer, Integer> myNewToOldConverter;
    private final Function<? super Integer, Integer> myOldToNewConverter;
    private final boolean mySubCoverageActive;

    protected ProfileLineMarkerRenderer(int lineNumer, TreeMap<Integer, LineData> lines, Function<? super Integer, Integer> newToOldConverter, Function<? super Integer, Integer> oldToNewConverter, boolean subCoverageActive) {
        this.myLineNumer = lineNumer;
        this.myLines = lines;
        this.myNewToOldConverter = newToOldConverter;
        this.myOldToNewConverter = oldToNewConverter;
        this.mySubCoverageActive = subCoverageActive;
    }

    public void paint(Editor editor2, Graphics g, Rectangle r) {
        TextAttributes attrs = ProfileLineMarkerRenderer.getTextAttributes(this.myLineNumer, this.myLines, editor2);
        Color bgColor = attrs.getBackgroundColor();
        if (bgColor == null) {
            bgColor = attrs.getForegroundColor();
        }
        if ((editor2.getSettings().isLineNumbersShown() || ((EditorGutterComponentEx)editor2.getGutter()).isAnnotationsShown()) && bgColor != null) {
            bgColor = ColorUtil.toAlpha((Color)bgColor, (int)150);
        }
        if (bgColor != null) {
            g.setColor(bgColor);
        }
        g.fillRect(r.x, r.y, r.width, r.height);
        LineData lineData = this.getLineData(editor2.xyToLogicalPosition((Point)new Point((int)0, (int)r.y)).line);
        if (lineData != null && lineData.isCoveredByOneTest()) {
            AllIcons.Gutter.Unique.paintIcon(editor2.getComponent(), g, r.x, r.y);
        }
    }

    private static TextAttributes getTextAttributes(int line2, TreeMap<Integer, LineData> lines, Editor editor2) {
        TextAttributes attrs = editor2.getColorsScheme().getAttributes(ProfileLineMarkerRenderer.getAttributesKey(line2, lines));
        int maxHits = 1;
        for (LineData d : lines.values()) {
            if (maxHits >= d.getHits()) continue;
            maxHits = d.getHits();
        }
        attrs = attrs.clone();
        attrs.setBackgroundColor(ProfileLineMarkerRenderer.colorIntensity(lines.get(line2).getHits(), maxHits));
        return attrs;
    }

    private static Color colorIntensity(int hits, int totalHits) {
        double power = 1.0 - 1.0 * (double)hits / (double)totalHits;
        double H = power * 0.15;
        double S = 0.8;
        double B = 1.0;
        return Color.getHSBColor((float)H, (float)S, (float)B);
    }

    public static ProfileLineMarkerRenderer getRenderer(int lineNumber, @Nullable String className, TreeMap<Integer, LineData> lines, boolean coverageByTestApplicable, Function<? super Integer, Integer> newToOldConverter, Function<? super Integer, Integer> oldToNewConverter, boolean subCoverageActive) {
        return new ProfileLineMarkerRenderer(lineNumber, lines, newToOldConverter, oldToNewConverter, subCoverageActive);
    }

    public static TextAttributesKey getAttributesKey(int lineNumber, TreeMap<Integer, LineData> lines) {
        return ProfileLineMarkerRenderer.getAttributesKey(lines.get(lineNumber));
    }

    private static TextAttributesKey getAttributesKey(LineData lineData) {
        return CodeInsightColors.LINE_FULL_COVERAGE;
    }

    public boolean canDoAction(@NotNull MouseEvent e) {
        Component component;
        if (e == null) {
            ProfileLineMarkerRenderer.$$$reportNull$$$0(0);
        }
        if ((component = e.getComponent()) instanceof EditorGutterComponentEx) {
            EditorGutterComponentEx gutter = (EditorGutterComponentEx)component;
            return e.getX() > gutter.getLineMarkerAreaOffset() && e.getX() < gutter.getIconAreaOffset();
        }
        return false;
    }

    public void doAction(@NotNull Editor editor2, @NotNull MouseEvent e) {
        if (editor2 == null) {
            ProfileLineMarkerRenderer.$$$reportNull$$$0(1);
        }
        if (e == null) {
            ProfileLineMarkerRenderer.$$$reportNull$$$0(2);
        }
        e.consume();
        JComponent comp = (JComponent)e.getComponent();
        JRootPane rootPane = comp.getRootPane();
        JLayeredPane layeredPane = rootPane.getLayeredPane();
        Point point = SwingUtilities.convertPoint(comp, 8, e.getY(), layeredPane);
        this.showHint(editor2, point, editor2.xyToLogicalPosition((Point)e.getPoint()).line);
    }

    private void showHint(Editor editor2, Point point, int lineNumber) {
        EditorImpl uEditor;
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)this.createActionsToolbar(editor2, lineNumber), "North");
        LineData lineData = this.getLineData(lineNumber);
        if (lineData != null && lineData.getStatus() != 0) {
            EditorFactory factory = EditorFactory.getInstance();
            Document doc = factory.createDocument((CharSequence)this.getReport(editor2, lineNumber));
            doc.setReadOnly(true);
            uEditor = (EditorImpl)factory.createEditor(doc, editor2.getProject());
            panel2.add((Component)EditorFragmentComponent.createEditorFragmentComponent((Editor)uEditor, (int)0, (int)doc.getLineCount(), (boolean)false, (boolean)false), "Center");
        } else {
            uEditor = null;
        }
        LightweightHint hint = new LightweightHint(panel2){

            public void hide() {
                if (uEditor != null) {
                    EditorFactory.getInstance().releaseEditor((Editor)uEditor);
                }
                super.hide();
            }
        };
        HintManagerImpl.getInstanceImpl().showEditorHint(hint, editor2, point, 58, -1, false, new HintHint(editor2, point));
    }

    private String getReport(Editor editor2, int lineNumber) {
        LineData lineData = this.getLineData(lineNumber);
        Document document = editor2.getDocument();
        Project project = editor2.getProject();
        assert (project != null);
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        assert (psiFile != null);
        int lineStartOffset = document.getLineStartOffset(lineNumber);
        int lineEndOffset = document.getLineEndOffset(lineNumber);
        return this.generateBriefReport(editor2, psiFile, lineNumber, lineStartOffset, lineEndOffset, lineData);
    }

    private String generateBriefReport(Editor editor2, PsiFile file2, int number, int offset, int offset1, LineData data) {
        int totalHits = 0;
        for (LineData d : this.myLines.values()) {
            totalHits += d.getHits();
        }
        int hits = data.getHits();
        return "Line " + data.getLineNumber() + ": " + 100 * hits / totalHits + "% (" + hits + " of " + totalHits + ") hits";
    }

    protected JComponent createActionsToolbar(Editor editor2, int lineNumber) {
        DefaultActionGroup group2 = new DefaultActionGroup();
        group2.add((AnAction)new HideProfileInfoAction());
        LineData lineData = this.getLineData(lineNumber);
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("FileHistoryViewToolbar", (ActionGroup)group2, true);
        JComponent toolbarComponent = toolbar.getComponent();
        Color background = ((EditorEx)editor2).getBackgroundColor();
        Color foreground = editor2.getColorsScheme().getColor(EditorColors.CARET_COLOR);
        toolbarComponent.setBackground(background);
        toolbarComponent.setBorder((Border)new ColoredSideBorder(foreground, foreground, lineData == null || lineData.getStatus() == 0 || this.mySubCoverageActive ? foreground : null, foreground, 1));
        toolbar.updateActionsImmediately();
        return toolbarComponent;
    }

    @Nullable
    public LineData getLineData(int lineNumber) {
        return this.myLines != null ? this.myLines.get(this.myNewToOldConverter != null ? (Integer)this.myNewToOldConverter.fun((Object)lineNumber) : lineNumber) : null;
    }

    public Color getErrorStripeColor(Editor editor2) {
        return ProfileLineMarkerRenderer.getTextAttributes(this.myLineNumer, this.myLines, editor2).getErrorStripeColor();
    }

    @NotNull
    public LineMarkerRendererEx.Position getPosition() {
        LineMarkerRendererEx.Position position = LineMarkerRendererEx.Position.LEFT;
        if (position == null) {
            ProfileLineMarkerRenderer.$$$reportNull$$$0(3);
        }
        return position;
    }

    @NotNull
    public String getAccessibleName() {
        String string = PythonProfilerBundle.message("python.profile.line.marker.accessible.name", new Object[0]);
        if (string == null) {
            ProfileLineMarkerRenderer.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/profiler/lines/ProfileLineMarkerRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/profiler/lines/ProfileLineMarkerRenderer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPosition";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessibleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canDoAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doAction";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

