/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.profiler;

import com.jetbrains.python.profiler.FunctionSample;
import com.jetbrains.python.profiler.ProfilerLogKt;
import com.jetbrains.python.profiler.Sample;
import java.text.NumberFormat;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001aE\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002\"\u000e\b\u0001\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00030\u00042!\u0010\u0005\u001a\u001d\u0012\u0013\u0012\u0011H\u0002\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u0002H\u00030\u0006\u001a\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u001aJ\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u000226\u0010\u000f\u001a2\u0012\u0013\u0012\u0011H\u0002\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u0011\u0012\u0013\u0012\u0011H\u0002\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u00130\u0010\u001a\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\u000b\u001a\u0016\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0013\u00a8\u0006\u0019"}, d2={"fieldComparator", "Ljava/util/Comparator;", "T", "V", "", "getComparableField", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "o", "formatPercent", "", "percentValue", "", "nullableComparator", "compareFunc", "Lkotlin/Function2;", "o1", "o2", "", "parseVmProfSampleName", "Lcom/jetbrains/python/profiler/Sample;", "percent", "value", "total", "intellij.python.profiler"})
public final class UtilsKt {
    @NotNull
    public static final <T> Comparator<T> nullableComparator(@NotNull Function2<? super T, ? super T, Integer> compareFunc) {
        Intrinsics.checkParameterIsNotNull(compareFunc, (String)"compareFunc");
        return new Comparator<T>(compareFunc){
            final /* synthetic */ Function2 $compareFunc;

            public final int compare(T o1, T o2) {
                return o1 != null && o2 != null ? ((Number)this.$compareFunc.invoke(o1, o2)).intValue() : (o1 != null ? 1 : -1);
            }
            {
                this.$compareFunc = function2;
            }
        };
    }

    @NotNull
    public static final <T, V extends Comparable<? super V>> Comparator<T> fieldComparator(@NotNull Function1<? super T, ? extends V> getComparableField) {
        Intrinsics.checkParameterIsNotNull(getComparableField, (String)"getComparableField");
        return new Comparator<T>(getComparableField){
            final /* synthetic */ Function1 $getComparableField;

            public final int compare(T o1, T o2) {
                return o1 != null && o2 != null ? ((Comparable)this.$getComparableField.invoke(o1)).compareTo(this.$getComparableField.invoke(o2)) : (o1 != null ? 1 : -1);
            }
            {
                this.$getComparableField = function1;
            }
        };
    }

    @NotNull
    public static final String percent(int value2, int total) {
        return UtilsKt.formatPercent((double)value2 / (double)total);
    }

    @NotNull
    public static final String formatPercent(double percentValue) {
        String format;
        NumberFormat numberFormat;
        NumberFormat numberFormat2 = numberFormat = NumberFormat.getPercentInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)numberFormat2, (String)"numberFormat");
        numberFormat2.setMinimumFractionDigits(1);
        String string = format = numberFormat.format(percentValue);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"format");
        return string;
    }

    @NotNull
    public static final Sample parseVmProfSampleName(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        List parts = StringsKt.split$default((CharSequence)name, (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null);
        if (parts.size() == 1) {
            String funname = (String)parts.get(0);
            return new FunctionSample(funname, null, null);
        }
        if (parts.size() >= 4) {
            String funname = (String)parts.get(1);
            String string = (String)parts.get(2);
            boolean bl = false;
            int funline = Integer.parseInt(string);
            String filename = parts.size() == 5 ? (String)parts.get(3) + (String)parts.get(4) : (String)parts.get(3);
            return new FunctionSample(funname, funline, filename);
        }
        ProfilerLogKt.getLOG().warn("Unrecognized node with name '" + name + '\'');
        return new FunctionSample(null, null, name);
    }
}

