/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.profiler;

import com.google.common.collect.Lists;
import com.jetbrains.python.profiler.CallStatData;
import com.jetbrains.python.profiler.FuncStat;
import com.jetbrains.python.profiler.FunctionStat;
import com.jetbrains.python.profiler.ProfileStatData;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B=\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0011J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0002J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u0018H\u0016R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/python/profiler/FunctionStatData;", "Lcom/jetbrains/python/profiler/CallStatData;", "Lcom/jetbrains/python/profiler/FunctionStat;", "stats", "Lcom/jetbrains/python/profiler/FuncStat;", "profileStatData", "Lcom/jetbrains/python/profiler/ProfileStatData;", "(Lcom/jetbrains/python/profiler/FuncStat;Lcom/jetbrains/python/profiler/ProfileStatData;)V", "fileName", "", "funcName", "lineNumber", "", "callCnt", "totalTimes", "", "ownTimes", "(Ljava/lang/String;Ljava/lang/String;IIDDLcom/jetbrains/python/profiler/ProfileStatData;)V", "callersList", "Ljava/util/ArrayList;", "addCaller", "", "func", "getCallers", "", "intellij.python.profiler"})
public class FunctionStatData
extends CallStatData
implements FunctionStat {
    private final ArrayList<FunctionStat> callersList;

    public final void addCaller(@NotNull FunctionStat func) {
        Intrinsics.checkParameterIsNotNull((Object)func, (String)"func");
        this.callersList.add(func);
    }

    @Override
    @NotNull
    public List<FunctionStat> getCallers() {
        CopyOnWriteArrayList copyOnWriteArrayList = Lists.newCopyOnWriteArrayList((Iterable)this.callersList);
        Intrinsics.checkExpressionValueIsNotNull((Object)copyOnWriteArrayList, (String)"Lists.newCopyOnWriteArrayList(callersList)");
        return copyOnWriteArrayList;
    }

    public FunctionStatData(@NotNull String fileName, @NotNull String funcName, int lineNumber, int callCnt, double totalTimes, double ownTimes, @NotNull ProfileStatData profileStatData) {
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        Intrinsics.checkParameterIsNotNull((Object)funcName, (String)"funcName");
        Intrinsics.checkParameterIsNotNull((Object)profileStatData, (String)"profileStatData");
        super(fileName, funcName, lineNumber, callCnt, totalTimes, ownTimes, profileStatData);
        this.callersList = new ArrayList();
    }

    public FunctionStatData(@NotNull FuncStat stats, @NotNull ProfileStatData profileStatData) {
        Intrinsics.checkParameterIsNotNull((Object)stats, (String)"stats");
        Intrinsics.checkParameterIsNotNull((Object)profileStatData, (String)"profileStatData");
        String string = stats.file;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"stats.file");
        String string2 = stats.func_name;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"stats.func_name");
        this(string, string2, stats.line, stats.calls_count, stats.total_time, stats.own_time, profileStatData);
    }
}

