/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.lexer;

import com.intellij.lexer.FlexAdapter;
import com.intellij.lexer.FlexLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.MergingLexerAdapter;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonDialectsTokenSetProvider;
import com.jetbrains.python.psi.PyStringLiteralUtil;
import gnu.trove.TIntStack;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonIndentingProcessor
extends MergingLexerAdapter {
    protected final TIntStack myIndentStack = new TIntStack();
    protected int myBraceLevel;
    protected boolean myLineHasSignificantTokens;
    protected int myLastNewLineIndent = -1;
    private int myCurrentNewLineIndent = 0;
    protected List<PendingToken> myTokenQueue = new ArrayList<PendingToken>();
    private int myLineBreakBeforeFirstCommentIndex = -1;
    protected boolean myProcessSpecialTokensPending = false;
    private final Stack<String> myFStringStack = new Stack();
    private static final boolean DUMP_TOKENS = false;
    private final TokenSet RECOVERY_TOKENS = PythonDialectsTokenSetProvider.INSTANCE.getUnbalancedBracesRecoveryTokens();

    public PythonIndentingProcessor(FlexLexer lexer, TokenSet tokens) {
        super((Lexer)new FlexAdapter(lexer), tokens);
    }

    @Nullable
    protected IElementType getBaseTokenType() {
        return super.getTokenType();
    }

    protected int getBaseTokenStart() {
        return super.getTokenStart();
    }

    protected int getBaseTokenEnd() {
        return super.getTokenEnd();
    }

    @NotNull
    private String getBaseTokenText() {
        String string = this.getBufferSequence().subSequence(this.getBaseTokenStart(), this.getBaseTokenEnd()).toString();
        if (string == null) {
            PythonIndentingProcessor.$$$reportNull$$$0(0);
        }
        return string;
    }

    private boolean isBaseAt(IElementType tokenType) {
        return this.getBaseTokenType() == tokenType;
    }

    public IElementType getTokenType() {
        if (this.myTokenQueue.size() > 0) {
            return this.myTokenQueue.get(0).getType();
        }
        return super.getTokenType();
    }

    public int getTokenStart() {
        if (this.myTokenQueue.size() > 0) {
            return this.myTokenQueue.get(0).getStart();
        }
        return super.getTokenStart();
    }

    public int getTokenEnd() {
        if (this.myTokenQueue.size() > 0) {
            return this.myTokenQueue.get(0).getEnd();
        }
        return super.getTokenEnd();
    }

    public void advance() {
        if (this.getTokenType() == PyTokenTypes.LINE_BREAK) {
            String text2 = this.getTokenText();
            int spaces = 0;
            for (int i = text2.length() - 1; i >= 0; --i) {
                if (text2.charAt(i) == ' ') {
                    ++spaces;
                    continue;
                }
                if (text2.charAt(i) != '\t') continue;
                spaces += 8;
            }
            this.myCurrentNewLineIndent = spaces;
        } else if (this.getTokenType() == PyTokenTypes.TAB) {
            this.myCurrentNewLineIndent += 8;
        }
        if (this.myTokenQueue.size() > 0) {
            this.myTokenQueue.remove(0);
            if (this.myProcessSpecialTokensPending) {
                this.myProcessSpecialTokensPending = false;
                this.processSpecialTokens();
            }
        } else {
            this.advanceBase();
            this.processSpecialTokens();
        }
        this.adjustBraceLevel();
    }

    protected void advanceBase() {
        super.advance();
        this.checkSignificantTokens();
        this.checkFString();
    }

    private void checkFString() {
        block3: {
            String lastOpeningQuotes;
            String tokenText;
            block2: {
                tokenText = this.getBaseTokenText();
                if (!this.isBaseAt(PyTokenTypes.FSTRING_START)) break block2;
                int prefixLength = PyStringLiteralUtil.getPrefixLength(tokenText);
                String openingQuotes = tokenText.substring(prefixLength);
                assert (!openingQuotes.isEmpty());
                this.myFStringStack.push((Object)openingQuotes);
                break block3;
            }
            if (!this.isBaseAt(PyTokenTypes.FSTRING_END)) break block3;
            while (!this.myFStringStack.isEmpty() && !(lastOpeningQuotes = (String)this.myFStringStack.pop()).equals(tokenText)) {
            }
        }
    }

    protected void pushToken(IElementType type, int start, int end) {
        this.myTokenQueue.add(new PendingToken(type, start, end));
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            PythonIndentingProcessor.$$$reportNull$$$0(1);
        }
        this.checkStartState(startOffset, initialState);
        super.start(buffer, startOffset, endOffset, initialState);
        this.setStartState();
    }

    protected void checkStartState(int startOffset, int initialState) {
    }

    private void setStartState() {
        this.myIndentStack.clear();
        this.myIndentStack.push(0);
        this.myBraceLevel = 0;
        this.adjustBraceLevel();
        this.myLineHasSignificantTokens = false;
        this.checkSignificantTokens();
        this.checkFString();
        if (this.isBaseAt(PyTokenTypes.SPACE)) {
            this.processIndent(0, PyTokenTypes.SPACE);
        }
    }

    private void adjustBraceLevel() {
        IElementType tokenType = this.getTokenType();
        if (PyTokenTypes.OPEN_BRACES.contains(tokenType)) {
            ++this.myBraceLevel;
        } else if (PyTokenTypes.CLOSE_BRACES.contains(tokenType)) {
            --this.myBraceLevel;
        } else if (this.myBraceLevel != 0 && this.RECOVERY_TOKENS.contains(tokenType)) {
            int indent;
            this.myBraceLevel = 0;
            int pos = this.getTokenStart();
            this.pushToken(PyTokenTypes.STATEMENT_BREAK, pos, pos);
            int indents = this.myIndentStack.size();
            for (int i = 0; i < indents - 1 && this.myCurrentNewLineIndent < (indent = this.myIndentStack.peek()); ++i) {
                if (this.myIndentStack.size() <= 1) continue;
                this.myIndentStack.pop();
                this.pushToken(PyTokenTypes.DEDENT, pos, pos);
            }
            this.pushToken(PyTokenTypes.LINE_BREAK, pos, pos);
        }
    }

    protected void checkSignificantTokens() {
        IElementType tokenType = this.getBaseTokenType();
        if (!PyTokenTypes.WHITESPACE_OR_LINEBREAK.contains(tokenType) && tokenType != this.getCommentTokenType()) {
            this.myLineHasSignificantTokens = true;
        }
    }

    protected void processSpecialTokens() {
        int tokenStart = this.getBaseTokenStart();
        if (this.isBaseAt(PyTokenTypes.LINE_BREAK)) {
            this.processLineBreak(tokenStart);
            if (this.isBaseAt(this.getCommentTokenType())) {
                this.myLineBreakBeforeFirstCommentIndex = this.myTokenQueue.size() - 1;
                while (this.isBaseAt(this.getCommentTokenType())) {
                    int commentEnd = this.getBaseTokenEnd();
                    this.myTokenQueue.add(new PendingCommentToken(this.getBaseTokenType(), this.getBaseTokenStart(), commentEnd, this.myLastNewLineIndent));
                    this.advanceBase();
                    if (this.isBaseAt(PyTokenTypes.LINE_BREAK)) {
                        this.processLineBreak(this.getBaseTokenStart());
                        continue;
                    }
                    if (this.getBaseTokenType() != null) break;
                    this.closeDanglingSuitesWithComments(0, commentEnd);
                }
                this.myLineBreakBeforeFirstCommentIndex = -1;
            }
        } else if (this.isBaseAt(PyTokenTypes.BACKSLASH)) {
            this.processBackslash(tokenStart);
        } else if (this.isBaseAt(PyTokenTypes.SPACE)) {
            this.processSpace();
        }
    }

    private void processSpace() {
        int start = this.getBaseTokenStart();
        int end = this.getBaseTokenEnd();
        while (this.getBaseTokenType() == PyTokenTypes.SPACE) {
            end = this.getBaseTokenEnd();
            this.advanceBase();
        }
        if (this.getBaseTokenType() == PyTokenTypes.LINE_BREAK) {
            this.processLineBreak(start);
        } else if (this.getBaseTokenType() == PyTokenTypes.BACKSLASH) {
            this.processBackslash(start);
        } else {
            this.myTokenQueue.add(new PendingToken(PyTokenTypes.SPACE, start, end));
        }
    }

    private void processBackslash(int tokenStart) {
        PendingToken backslashToken = new PendingToken(this.getBaseTokenType(), tokenStart, this.getBaseTokenEnd());
        this.myTokenQueue.add(backslashToken);
        this.advanceBase();
        while (PyTokenTypes.WHITESPACE.contains(this.getBaseTokenType())) {
            this.pushCurrentToken();
            this.advanceBase();
        }
        if (this.getBaseTokenType() == PyTokenTypes.LINE_BREAK) {
            backslashToken.setType(PyTokenTypes.SPACE);
            this.processInsignificantLineBreak(this.getBaseTokenStart(), true);
        }
        this.myProcessSpecialTokensPending = true;
    }

    protected void processLineBreak(int startPos) {
        boolean shouldTerminateFStrings;
        boolean allFStringsAreTripleQuoted = ContainerUtil.and(this.myFStringStack, quotes -> quotes.length() == 3);
        boolean insideImplicitFragmentParentheses = !this.myFStringStack.isEmpty() && allFStringsAreTripleQuoted;
        boolean bl = shouldTerminateFStrings = !this.myFStringStack.isEmpty() && !allFStringsAreTripleQuoted;
        if (this.myBraceLevel == 0 && !insideImplicitFragmentParentheses || shouldTerminateFStrings) {
            if (this.myLineHasSignificantTokens || shouldTerminateFStrings) {
                this.pushToken(PyTokenTypes.STATEMENT_BREAK, startPos, startPos);
                this.myFStringStack.clear();
            }
            this.myLineHasSignificantTokens = false;
            this.advanceBase();
            this.processIndent(startPos, PyTokenTypes.LINE_BREAK);
        } else {
            this.processInsignificantLineBreak(startPos, false);
        }
    }

    protected void processInsignificantLineBreak(int startPos, boolean breakStatementOnLineBreak) {
        int end = this.getBaseTokenEnd();
        this.advanceBase();
        while (this.getBaseTokenType() == PyTokenTypes.SPACE || this.getBaseTokenType() == PyTokenTypes.TAB || !breakStatementOnLineBreak && this.getBaseTokenType() == PyTokenTypes.LINE_BREAK) {
            end = this.getBaseTokenEnd();
            this.advanceBase();
        }
        this.myTokenQueue.add(new PendingToken(PyTokenTypes.LINE_BREAK, startPos, end));
        this.myProcessSpecialTokensPending = true;
    }

    protected void processIndent(int whiteSpaceStart, IElementType whitespaceTokenType) {
        int whiteSpaceEnd;
        int indent;
        int lastIndent = this.myIndentStack.peek();
        this.myLastNewLineIndent = indent = this.getNextLineIndent();
        if (this.getBaseTokenType() == this.getCommentTokenType()) {
            indent = lastIndent;
        }
        int n = whiteSpaceEnd = this.getBaseTokenType() == null ? super.getBufferEnd() : this.getBaseTokenStart();
        if (indent > lastIndent) {
            this.myIndentStack.push(indent);
            this.myTokenQueue.add(new PendingToken(whitespaceTokenType, whiteSpaceStart, whiteSpaceEnd));
            int insertIndex = this.skipPrecedingCommentsWithIndent(indent, this.myTokenQueue.size() - 1);
            int indentOffset = insertIndex == this.myTokenQueue.size() ? whiteSpaceEnd : this.myTokenQueue.get(insertIndex).getStart();
            this.myTokenQueue.add(insertIndex, new PendingToken(PyTokenTypes.INDENT, indentOffset, indentOffset));
        } else if (indent < lastIndent) {
            this.closeDanglingSuitesWithComments(indent, whiteSpaceStart);
            this.myTokenQueue.add(new PendingToken(whitespaceTokenType, whiteSpaceStart, whiteSpaceEnd));
        } else {
            this.myTokenQueue.add(new PendingToken(whitespaceTokenType, whiteSpaceStart, whiteSpaceEnd));
        }
    }

    private void closeDanglingSuitesWithComments(int indent, int whiteSpaceStart) {
        int insertIndex;
        int lastIndent = this.myIndentStack.peek();
        int n = insertIndex = this.myLineBreakBeforeFirstCommentIndex == -1 ? this.myTokenQueue.size() : this.myLineBreakBeforeFirstCommentIndex;
        while (indent < lastIndent) {
            int lastSuiteIndent = this.myIndentStack.pop();
            lastIndent = this.myIndentStack.peek();
            int dedentOffset = whiteSpaceStart;
            if (indent > lastIndent) {
                this.myTokenQueue.add(new PendingToken(PyTokenTypes.INCONSISTENT_DEDENT, whiteSpaceStart, whiteSpaceStart));
                insertIndex = this.myTokenQueue.size();
            } else {
                insertIndex = this.skipPrecedingCommentsWithSameIndentOnSuiteClose(lastSuiteIndent, insertIndex);
            }
            if (insertIndex != this.myTokenQueue.size()) {
                dedentOffset = this.myTokenQueue.get(insertIndex).getStart();
            }
            this.myTokenQueue.add(insertIndex, new PendingToken(PyTokenTypes.DEDENT, dedentOffset, dedentOffset));
            ++insertIndex;
        }
    }

    protected int skipPrecedingCommentsWithIndent(int indent, int index) {
        PendingCommentToken commentToken;
        boolean foundComment = false;
        while (index > 0 && this.myTokenQueue.get(index - 1) instanceof PendingCommentToken && (commentToken = (PendingCommentToken)this.myTokenQueue.get(index - 1)).getIndent() == indent) {
            foundComment = true;
            if (--index <= 1 || this.myTokenQueue.get(index - 1).getType() != PyTokenTypes.LINE_BREAK || !(this.myTokenQueue.get(index - 2) instanceof PendingCommentToken)) continue;
            --index;
        }
        return foundComment ? index : this.myTokenQueue.size();
    }

    protected int skipPrecedingCommentsWithSameIndentOnSuiteClose(int indent, int anchorIndex) {
        int result = anchorIndex;
        for (int i = anchorIndex; i < this.myTokenQueue.size(); ++i) {
            PendingToken token = this.myTokenQueue.get(i);
            if (!(token instanceof PendingCommentToken)) continue;
            if (((PendingCommentToken)token).getIndent() < indent) break;
            result = i + 1;
        }
        return result;
    }

    protected int getNextLineIndent() {
        int indent = 0;
        while (this.getBaseTokenType() != null && PyTokenTypes.WHITESPACE_OR_LINEBREAK.contains(this.getBaseTokenType())) {
            if (this.getBaseTokenType() == PyTokenTypes.TAB) {
                indent = (indent / 8 + 1) * 8;
            } else if (this.getBaseTokenType() == PyTokenTypes.SPACE) {
                ++indent;
            } else if (this.getBaseTokenType() == PyTokenTypes.LINE_BREAK) {
                indent = 0;
            }
            this.advanceBase();
        }
        if (this.getBaseTokenType() == null) {
            return 0;
        }
        return indent;
    }

    private void pushCurrentToken() {
        this.myTokenQueue.add(new PendingToken(this.getBaseTokenType(), this.getBaseTokenStart(), this.getBaseTokenEnd()));
    }

    protected IElementType getCommentTokenType() {
        return PyTokenTypes.END_OF_LINE_COMMENT;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/lexer/PythonIndentingProcessor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseTokenText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/lexer/PythonIndentingProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PendingCommentToken
    extends PendingToken {
        private final int myIndent;

        PendingCommentToken(IElementType type, int start, int end, int indent) {
            super(type, start, end);
            this.myIndent = indent;
        }

        public int getIndent() {
            return this.myIndent;
        }
    }

    protected static class PendingToken {
        private IElementType _type;
        private final int _start;
        private final int _end;

        public PendingToken(IElementType type, int start, int end) {
            this._type = type;
            this._start = start;
            this._end = end;
        }

        public IElementType getType() {
            return this._type;
        }

        public int getStart() {
            return this._start;
        }

        public int getEnd() {
            return this._end;
        }

        public void setType(IElementType type) {
            this._type = type;
        }

        public String toString() {
            return this._type + ":" + this._start + "-" + this._end;
        }
    }
}

