/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.unresolvedReference;

import com.google.common.collect.Sets;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ui.ListEditForm;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.Consumer;
import com.intellij.util.PlatformUtils;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyPsiPackageUtil;
import com.jetbrains.python.PythonRuntimeService;
import com.jetbrains.python.codeInsight.PyCodeInsightSettings;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.codeInsight.imports.AutoImportHintAction;
import com.jetbrains.python.codeInsight.imports.AutoImportQuickFix;
import com.jetbrains.python.codeInsight.imports.OptimizeImportsQuickFix;
import com.jetbrains.python.codeInsight.imports.PythonImportUtils;
import com.jetbrains.python.console.PydevConsoleRunner;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionExtension;
import com.jetbrains.python.inspections.PyPackageRequirementsInspection;
import com.jetbrains.python.inspections.PyUnresolvedReferenceQuickFixProvider;
import com.jetbrains.python.inspections.quickfix.AddFieldQuickFix;
import com.jetbrains.python.inspections.quickfix.AddFunctionQuickFix;
import com.jetbrains.python.inspections.quickfix.AddIgnoredIdentifierQuickFix;
import com.jetbrains.python.inspections.quickfix.AddMethodQuickFix;
import com.jetbrains.python.inspections.quickfix.CreateClassQuickFix;
import com.jetbrains.python.inspections.quickfix.GenerateBinaryStubsFix;
import com.jetbrains.python.inspections.quickfix.PyRenameUnresolvedRefQuickFix;
import com.jetbrains.python.inspections.quickfix.UnresolvedRefCreateFunctionQuickFix;
import com.jetbrains.python.inspections.quickfix.UnresolvedRefTrueFalseQuickFix;
import com.jetbrains.python.inspections.quickfix.UnresolvedReferenceAddParameterQuickFix;
import com.jetbrains.python.inspections.quickfix.UnresolvedReferenceAddSelfQuickFix;
import com.jetbrains.python.inspections.unresolvedReference.PyPackageAliasesProvider;
import com.jetbrains.python.inspections.unresolvedReference.PyUnresolvedReferencesVisitor;
import com.jetbrains.python.packaging.PyPIPackageUtil;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.packaging.PyRequirementsKt;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionCodeFragment;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyIfStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyImportedNameDefiner;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyReferenceOwner;
import com.jetbrains.python.psi.PyStarImportElement;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTryExceptStatement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.references.PyImportReference;
import com.jetbrains.python.psi.impl.references.PyOperatorReference;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyModuleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.sdk.skeletons.PySkeletonRefresher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.JComponent;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyUnresolvedReferencesInspection
extends PyInspection {
    private static final Key<Visitor> KEY = Key.create((String)"PyUnresolvedReferencesInspection.Visitor");
    public static final Key<PyUnresolvedReferencesInspection> SHORT_NAME_KEY = Key.create((String)PyUnresolvedReferencesInspection.class.getSimpleName());
    public List<String> ignoredIdentifiers = new ArrayList<String>();

    public static PyUnresolvedReferencesInspection getInstance(PsiElement element) {
        InspectionProfileImpl inspectionProfile = InspectionProjectProfileManager.getInstance((Project)element.getProject()).getCurrentProfile();
        return (PyUnresolvedReferencesInspection)inspectionProfile.getUnwrappedTool(SHORT_NAME_KEY.toString(), element);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyUnresolvedReferencesInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PyUnresolvedReferencesInspection.$$$reportNull$$$0(1);
        }
        Visitor visitor2 = new Visitor(holder, session, this.ignoredIdentifiers);
        Visitor existingVisitor = (Visitor)((Object)session.getUserData(KEY));
        if (existingVisitor == null) {
            session.putUserData(KEY, (Object)visitor2);
        }
        Visitor visitor3 = visitor2;
        if (visitor3 == null) {
            PyUnresolvedReferencesInspection.$$$reportNull$$$0(2);
        }
        return visitor3;
    }

    public void inspectionFinished(@NotNull LocalInspectionToolSession session, @NotNull ProblemsHolder holder) {
        if (session == null) {
            PyUnresolvedReferencesInspection.$$$reportNull$$$0(3);
        }
        if (holder == null) {
            PyUnresolvedReferencesInspection.$$$reportNull$$$0(4);
        }
        Visitor visitor2 = (Visitor)((Object)session.getUserData(KEY));
        assert (visitor2 != null);
        if (PyCodeInsightSettings.getInstance().HIGHLIGHT_UNUSED_IMPORTS) {
            visitor2.highlightUnusedImports();
        }
        visitor2.highlightImportsInsideGuards();
        session.putUserData(KEY, null);
    }

    public JComponent createOptionsPanel() {
        ListEditForm form = new ListEditForm("Ignore references", this.ignoredIdentifiers);
        return form.getContentPanel();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/unresolvedReference/PyUnresolvedReferencesInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/unresolvedReference/PyUnresolvedReferencesInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "inspectionFinished";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Visitor
    extends PyUnresolvedReferencesVisitor {
        private volatile Boolean myIsEnabled;

        public Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session, List<String> ignoredIdentifiers) {
            if (session == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, session, ignoredIdentifiers);
            this.myIsEnabled = null;
        }

        @Override
        public boolean isEnabled(@NotNull PsiElement anchor) {
            if (anchor == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            if (this.myIsEnabled == null) {
                boolean isPyCharm = PlatformUtils.isPyCharm();
                Boolean overridden = Visitor.overriddenUnresolvedReferenceInspection(anchor.getContainingFile());
                this.myIsEnabled = overridden != null ? overridden : (PySkeletonRefresher.isGeneratingSkeletons() ? Boolean.valueOf(false) : (isPyCharm ? Boolean.valueOf(PythonSdkUtil.findPythonSdk(anchor) != null || PythonRuntimeService.getInstance().isInScratchFile(anchor)) : Boolean.valueOf(true)));
            }
            return this.myIsEnabled;
        }

        @Nullable
        private static Boolean overriddenUnresolvedReferenceInspection(@NotNull PsiFile file2) {
            if (file2 == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            return PyInspectionExtension.EP_NAME.getExtensionList().stream().map(e -> e.overrideUnresolvedReferenceInspection(file2)).filter(Objects::nonNull).findFirst().orElse(null);
        }

        public void highlightUnusedImports() {
            List extensions = PyInspectionExtension.EP_NAME.getExtensionList();
            List<PsiElement> unused = this.collectUnusedImportElements();
            for (PsiElement element : unused) {
                if (extensions.stream().anyMatch(extension -> extension.ignoreUnused(element, this.myTypeEvalContext)) || element.getTextLength() <= 0) continue;
                OptimizeImportsQuickFix fix = new OptimizeImportsQuickFix();
                this.registerProblem(element, PyBundle.message("INSP.unused.import.statement", new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, null, fix);
            }
        }

        public void highlightImportsInsideGuards() {
            HashSet usedImportsInsideImportGuards = Sets.newHashSet(this.getImportsInsideGuard());
            usedImportsInsideImportGuards.retainAll(this.getUsedImports());
            for (PyImportedNameDefiner definer : usedImportsInsideImportGuards) {
                PyImportElement importElement = PyUtil.as(definer, PyImportElement.class);
                if (importElement == null) continue;
                PyTargetExpression asElement = importElement.getAsNameElement();
                PyReferenceOwner toHighlight = asElement != null ? asElement : importElement.getImportReferenceExpression();
                this.registerProblem((PsiElement)toHighlight, PyBundle.message("INSP.try.except.import.error", importElement.getVisibleName()), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
            }
        }

        private List<PsiElement> collectUnusedImportElements() {
            if (this.getAllImports().isEmpty()) {
                return Collections.emptyList();
            }
            PyImportedNameDefiner first = this.getAllImports().iterator().next();
            if (first.getContainingFile() instanceof PyExpressionCodeFragment || PydevConsoleRunner.isInPydevConsole((PsiElement)first)) {
                return Collections.emptyList();
            }
            ArrayList<PsiElement> result = new ArrayList<PsiElement>();
            HashSet<PyImportedNameDefiner> unusedImports = new HashSet<PyImportedNameDefiner>(this.getAllImports());
            unusedImports.removeAll(this.getUsedImports());
            HashSet<PyImportedNameDefiner> unusedImportToSkip = new HashSet<PyImportedNameDefiner>();
            for (PyImportedNameDefiner pyImportedNameDefiner : unusedImports) {
                if (!PyInspectionExtension.EP_NAME.getExtensionList().stream().anyMatch(o -> o.ignoreUnusedImports(pyImportedNameDefiner))) continue;
                unusedImportToSkip.add(pyImportedNameDefiner);
            }
            unusedImports.removeAll(unusedImportToSkip);
            HashSet<String> usedImportNames = new HashSet<String>();
            for (PyImportedNameDefiner usedImport : this.getUsedImports()) {
                for (PyElement e : usedImport.iterateNames()) {
                    usedImportNames.add(e.getName());
                }
            }
            HashSet<PyImportStatementBase> hashSet = new HashSet<PyImportStatementBase>();
            PyUnresolvedReferencesInspection suppressableInspection = new PyUnresolvedReferencesInspection();
            QualifiedName packageQName = null;
            List<String> dunderAll = null;
            block3: for (PyImportedNameDefiner unusedImport : unusedImports) {
                QualifiedName importedQName;
                PsiFileSystemItem importedElement;
                PyImportStatementBase importStatement;
                if (packageQName == null) {
                    PsiFile file2 = unusedImport.getContainingFile();
                    if (file2 instanceof PyFile) {
                        dunderAll = ((PyFile)file2).getDunderAll();
                    }
                    if (file2 != null && PyUtil.isPackage(file2)) {
                        packageQName = QualifiedNameFinder.findShortestImportableQName((PsiFileSystemItem)file2);
                    }
                }
                if ((importStatement = (PyImportStatementBase)PsiTreeUtil.getParentOfType((PsiElement)unusedImport, PyImportStatementBase.class)) == null || hashSet.contains(importStatement) || this.getUsedImports().contains(unusedImport) || suppressableInspection.isSuppressedFor((PsiElement)importStatement) || PsiTreeUtil.getParentOfType((PsiElement)importStatement, PyTryExceptStatement.class) != null) continue;
                if (PsiTreeUtil.getParentOfType((PsiElement)unusedImport, PyIfStatement.class) != null) {
                    for (PyElement e : unusedImport.iterateNames()) {
                        if (!usedImportNames.contains(e.getName())) continue;
                        continue block3;
                    }
                }
                if (unusedImport instanceof PyImportElement) {
                    PyImportElement importElement = (PyImportElement)unusedImport;
                    PsiElement element = importElement.resolve();
                    if (element == null) {
                        if (importElement.getImportedQName() == null) continue;
                        if (Visitor.areAllImportsUnused(importStatement, unusedImports)) {
                            result.add((PsiElement)importStatement);
                            continue;
                        }
                        result.add((PsiElement)importElement);
                        continue;
                    }
                    if (dunderAll != null && dunderAll.contains(importElement.getVisibleName())) continue;
                    importedElement = element.getContainingFile();
                } else {
                    assert (importStatement instanceof PyFromImportStatement);
                    importedElement = ((PyFromImportStatement)importStatement).resolveImportSource();
                    if (importedElement == null) continue;
                }
                if (packageQName != null && importedElement != null && (importedQName = QualifiedNameFinder.findShortestImportableQName(importedElement)) != null && importedQName.matchesPrefix(packageQName)) continue;
                if (unusedImport instanceof PyStarImportElement || Visitor.areAllImportsUnused(importStatement, unusedImports)) {
                    hashSet.add(importStatement);
                    result.add((PsiElement)importStatement);
                    continue;
                }
                result.add((PsiElement)unusedImport);
            }
            return result;
        }

        private static boolean areAllImportsUnused(PyImportStatementBase importStatement, Set<PyImportedNameDefiner> unusedImports) {
            PyImportElement[] elements;
            for (PyImportElement element : elements = importStatement.getImportElements()) {
                if (unusedImports.contains(element)) continue;
                return false;
            }
            return true;
        }

        public void optimizeImports() {
            List<PsiElement> elementsToDelete = this.collectUnusedImportElements();
            for (PsiElement element : elementsToDelete) {
                PyPsiUtils.assertValid(element);
                element.delete();
            }
        }

        @Override
        boolean ignoreUnresolved(@NotNull PyElement node, @NotNull PsiReference reference) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(3);
            }
            if (reference == null) {
                Visitor.$$$reportNull$$$0(4);
            }
            boolean ignoreUnresolved = false;
            for (PyInspectionExtension extension : PyInspectionExtension.EP_NAME.getExtensionList()) {
                if (!extension.ignoreUnresolvedReference(node, reference, this.myTypeEvalContext)) continue;
                ignoreUnresolved = true;
                break;
            }
            return ignoreUnresolved;
        }

        @Override
        public Iterable<LocalQuickFix> getInstallPackageQuickFixes(@NotNull PyElement node, @NotNull PsiReference reference, String refName) {
            QualifiedName qname;
            List components;
            if (node == null) {
                Visitor.$$$reportNull$$$0(5);
            }
            if (reference == null) {
                Visitor.$$$reportNull$$$0(6);
            }
            if (reference instanceof PyImportReference && !(components = (qname = QualifiedName.fromDottedString((String)refName)).getComponents()).isEmpty()) {
                String packageName = (String)components.get(0);
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)node);
                Sdk sdk = PythonSdkUtil.findPythonSdk(module);
                if (module != null && sdk != null && PyPackageUtil.packageManagementEnabled(sdk)) {
                    return ((StreamEx)StreamEx.of((Object)packageName).append((Collection)PyPsiPackageUtil.PACKAGES_TOPLEVEL.getOrDefault((Object)packageName, Collections.emptyList())).filter(PyPIPackageUtil.INSTANCE::isInPyPI)).map(pkg -> Visitor.getInstallPackageAction(pkg, module, sdk));
                }
            }
            return Collections.emptyList();
        }

        @Override
        public Iterable<LocalQuickFix> getAddIgnoredIdentifierQuickFixes(List<QualifiedName> qualifiedNames) {
            ArrayList<LocalQuickFix> result = new ArrayList<LocalQuickFix>(2);
            if (qualifiedNames.size() == 1) {
                QualifiedName qualifiedName = qualifiedNames.get(0);
                result.add(new AddIgnoredIdentifierQuickFix(qualifiedName, false));
                if (qualifiedName.getComponentCount() > 1) {
                    result.add(new AddIgnoredIdentifierQuickFix(qualifiedName.removeLastComponent(), true));
                }
            }
            return result;
        }

        @Override
        public Iterable<LocalQuickFix> getImportStatementQuickFixes(PsiElement element) {
            PyImportStatementBase importStatementBase = (PyImportStatementBase)PsiTreeUtil.getParentOfType((PsiElement)element, PyImportStatementBase.class);
            if (importStatementBase != null && GenerateBinaryStubsFix.isApplicable(importStatementBase)) {
                return GenerateBinaryStubsFix.generateFixes(importStatementBase);
            }
            return Collections.emptyList();
        }

        @Override
        public LocalQuickFix getRenameUnresolvedRefQuickFix() {
            return new PyRenameUnresolvedRefQuickFix();
        }

        @Override
        public LocalQuickFix getAddParameterQuickFix(String refName, PyReferenceExpression expr) {
            PyFunction parentFunction = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)expr, PyFunction.class);
            PyDecorator decorator = (PyDecorator)PsiTreeUtil.getParentOfType((PsiElement)expr, PyDecorator.class);
            PyAnnotation annotation = (PyAnnotation)PsiTreeUtil.getParentOfType((PsiElement)expr, PyAnnotation.class);
            PyImportStatement importStatement = (PyImportStatement)PsiTreeUtil.getParentOfType((PsiElement)expr, PyImportStatement.class);
            if (parentFunction != null && decorator == null && annotation == null && importStatement == null) {
                return new UnresolvedReferenceAddParameterQuickFix(refName);
            }
            return null;
        }

        @Override
        public LocalQuickFix getCreateFunctionQuickFix(PyReferenceExpression expr) {
            PyCallExpression callExpression = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)expr, PyCallExpression.class);
            if (!(callExpression == null || callExpression.getCallee() instanceof PyQualifiedExpression && ((PyQualifiedExpression)callExpression.getCallee()).getQualifier() != null)) {
                return new UnresolvedRefCreateFunctionQuickFix(callExpression, expr);
            }
            return null;
        }

        @Override
        public LocalQuickFix getTrueFalseQuickFix(PyReferenceExpression expr, String refText) {
            if (refText.equals("true") || refText.equals("false")) {
                return new UnresolvedRefTrueFalseQuickFix((PsiElement)expr);
            }
            return null;
        }

        private static LocalQuickFix getInstallPackageAction(String packageName, Module module, Sdk sdk) {
            List<PyRequirement> requirements2 = Collections.singletonList(PyRequirementsKt.pyRequirement(packageName));
            String name = "Install package " + packageName;
            return new PyPackageRequirementsInspection.PyInstallRequirementsFix(name, module, sdk, requirements2);
        }

        @Override
        public Iterable<LocalQuickFix> getCreateMemberFromUsageFixes(TypeEvalContext typeEvalContext, PyType type, PsiReference reference, String refText) {
            ArrayList<LocalQuickFix> result = new ArrayList<LocalQuickFix>();
            PsiElement element = reference.getElement();
            if (type instanceof PyClassTypeImpl) {
                PyClass cls = ((PyClassType)type).getPyClass();
                if (!PyBuiltinCache.getInstance(element).isBuiltin((PsiElement)cls)) {
                    if (element.getParent() instanceof PyCallExpression) {
                        result.add(new AddMethodQuickFix(refText, cls.getName(), true));
                    } else if (!(reference instanceof PyOperatorReference)) {
                        result.add(new AddFieldQuickFix(refText, "None", type.getName(), true));
                    }
                }
            } else if (type instanceof PyModuleType) {
                PyFile file2 = ((PyModuleType)type).getModule();
                result.add(new AddFunctionQuickFix(refText, file2.getName()));
                this.getCreateClassFix(typeEvalContext, refText, element);
            }
            return result;
        }

        @Override
        public Iterable<LocalQuickFix> getAddSelfFixes(TypeEvalContext typeEvalContext, PyElement node, PyReferenceExpression expr) {
            ArrayList<LocalQuickFix> result = new ArrayList<LocalQuickFix>();
            PyClass containedClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)node, PyClass.class);
            PyFunction function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)node, PyFunction.class);
            if (containedClass != null && function != null) {
                PyParameter[] parameters = function.getParameterList().getParameters();
                if (parameters.length == 0) {
                    return Collections.emptyList();
                }
                String qualifier = parameters[0].getText();
                PyDecoratorList decoratorList = function.getDecoratorList();
                boolean isClassMethod = false;
                if (decoratorList != null) {
                    for (PyDecorator decorator : decoratorList.getDecorators()) {
                        PyExpression callee = decorator.getCallee();
                        if (callee == null || !"classmethod".equals(callee.getText())) continue;
                        isClassMethod = true;
                    }
                }
                for (PyTargetExpression target : containedClass.getInstanceAttributes()) {
                    if (isClassMethod || !Comparing.strEqual((String)node.getName(), (String)target.getName())) continue;
                    result.add(new UnresolvedReferenceAddSelfQuickFix(expr, qualifier));
                }
                for (PyStatement statement : containedClass.getStatementList().getStatements()) {
                    PyType type;
                    PyExpression assignedValue;
                    PyExpression lhsExpression;
                    if (!(statement instanceof PyAssignmentStatement) || (lhsExpression = ((PyAssignmentStatement)statement).getLeftHandSideExpression()) == null || !lhsExpression.getText().equals(expr.getText()) || !((assignedValue = ((PyAssignmentStatement)statement).getAssignedValue()) instanceof PyCallExpression) || !((type = typeEvalContext.getType(assignedValue)) instanceof PyClassTypeImpl) || !((PyCallExpression)assignedValue).isCalleeText("property")) continue;
                    result.add(new UnresolvedReferenceAddSelfQuickFix(expr, qualifier));
                }
                for (PyFunction method : containedClass.getMethods()) {
                    if (!expr.getText().equals(method.getName())) continue;
                    result.add(new UnresolvedReferenceAddSelfQuickFix(expr, qualifier));
                }
            }
            return result;
        }

        @Override
        public Iterable<LocalQuickFix> getAutoImportFixes(PyElement node, PsiReference reference, PsiElement element) {
            if (!PythonImportUtils.isImportable(element)) {
                return Collections.emptyList();
            }
            PsiFile file2 = InjectedLanguageManager.getInstance((Project)node.getProject()).getTopLevelFile((PsiElement)node);
            if (!(file2 instanceof PyFile)) {
                return Collections.emptyList();
            }
            ArrayList<LocalQuickFix> result = new ArrayList<LocalQuickFix>();
            AutoImportQuickFix importFix = PythonImportUtils.proposeImportFix(node, reference);
            if (importFix != null) {
                if (!Visitor.suppressHintForAutoImport(node, importFix) && PyCodeInsightSettings.getInstance().SHOW_IMPORT_POPUP) {
                    AutoImportHintAction autoImportHintAction = new AutoImportHintAction(importFix);
                    result.add(autoImportHintAction);
                } else {
                    result.add((LocalQuickFix)importFix);
                }
                if (ScopeUtil.getScopeOwner((PsiElement)node) instanceof PyFunction) {
                    result.add((LocalQuickFix)importFix.forLocalImport());
                }
            } else {
                String refName;
                String string = refName = node instanceof PyQualifiedExpression ? ((PyQualifiedExpression)node).getReferencedName() : node.getText();
                if (refName == null) {
                    return result;
                }
                QualifiedName qname = QualifiedName.fromDottedString((String)refName);
                List components = qname.getComponents();
                if (!components.isEmpty()) {
                    String packageName = (String)components.get(0);
                    Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)node);
                    if (PyPIPackageUtil.INSTANCE.isInPyPI(packageName) && PythonSdkUtil.findPythonSdk(module) != null) {
                        result.add(new PyPackageRequirementsInspection.InstallAndImportQuickFix(packageName, packageName, node));
                    } else {
                        String packageAlias = PyPackageAliasesProvider.commonImportAliases.get(packageName);
                        if (packageAlias != null && PyPIPackageUtil.INSTANCE.isInPyPI(packageName) && PythonSdkUtil.findPythonSdk(module) != null) {
                            result.add(new PyPackageRequirementsInspection.InstallAndImportQuickFix(packageAlias, packageName, node));
                        }
                    }
                }
            }
            return result;
        }

        private static boolean suppressHintForAutoImport(PyElement node, AutoImportQuickFix importFix) {
            if (!Visitor.isCall(node) && importFix.hasOnlyFunctions()) {
                return true;
            }
            PyClass containingClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)node, PyClass.class);
            return containingClass != null && (containingClass.findMethodByName(importFix.getNameToImport(), true, null) != null || containingClass.findInstanceAttribute(importFix.getNameToImport(), true) != null);
        }

        @Override
        public LocalQuickFix getCreateClassFix(TypeEvalContext typeEvalContext, @NonNls String refText, PsiElement element) {
            if (refText.length() > 2 && Character.isUpperCase(refText.charAt(0)) && !StringUtil.toUpperCase((String)refText).equals(refText) && PsiTreeUtil.getParentOfType((PsiElement)element, PyImportStatementBase.class) == null) {
                Object anchor = element;
                if (element instanceof PyQualifiedExpression) {
                    PyExpression expr = ((PyQualifiedExpression)element).getQualifier();
                    if (expr != null) {
                        PyType type = typeEvalContext.getType(expr);
                        anchor = type instanceof PyModuleType ? ((PyModuleType)type).getModule() : null;
                    }
                    if (anchor != null) {
                        return new CreateClassQuickFix(refText, (PsiElement)anchor);
                    }
                }
            }
            return null;
        }

        private static boolean isCall(PyElement node) {
            PyCallExpression callExpression = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)node, PyCallExpression.class);
            return callExpression != null && node == callExpression.getCallee();
        }

        @Override
        public Iterable<LocalQuickFix> getPluginQuickFixes(PsiReference reference) {
            ArrayList<LocalQuickFix> result = new ArrayList<LocalQuickFix>();
            for (PyUnresolvedReferenceQuickFixProvider provider : PyUnresolvedReferenceQuickFixProvider.EP_NAME.getExtensionList()) {
                provider.registerQuickFixes(reference, (Consumer<LocalQuickFix>)((Consumer)result::add));
            }
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "anchor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/inspections/unresolvedReference/PyUnresolvedReferencesInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabled";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "overriddenUnresolvedReferenceInspection";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "ignoreUnresolved";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getInstallPackageQuickFixes";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

