/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.override.PyMethodMember;
import com.jetbrains.python.codeInsight.override.PyOverrideImplementUtil;
import com.jetbrains.python.inspections.quickfix.PyQuickFixUtil;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PyImplementMethodsQuickFix
extends LocalQuickFixOnPsiElement {
    @NotNull
    private final Collection<PyFunction> myToImplement;

    public PyImplementMethodsQuickFix(@NotNull PyClass cls, @NotNull Collection<PyFunction> toImplement) {
        if (cls == null) {
            PyImplementMethodsQuickFix.$$$reportNull$$$0(0);
        }
        if (toImplement == null) {
            PyImplementMethodsQuickFix.$$$reportNull$$$0(1);
        }
        super((PsiElement)cls);
        this.myToImplement = toImplement;
    }

    @NotNull
    public String getText() {
        String string = PyBundle.message("QFIX.NAME.implement.methods", new Object[0]);
        if (string == null) {
            PyImplementMethodsQuickFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            PyImplementMethodsQuickFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        Editor editor2;
        if (project == null) {
            PyImplementMethodsQuickFix.$$$reportNull$$$0(4);
        }
        if (file2 == null) {
            PyImplementMethodsQuickFix.$$$reportNull$$$0(5);
        }
        if (startElement == null) {
            PyImplementMethodsQuickFix.$$$reportNull$$$0(6);
        }
        if (endElement == null) {
            PyImplementMethodsQuickFix.$$$reportNull$$$0(7);
        }
        if ((editor2 = PyQuickFixUtil.getEditor((PsiElement)file2)) != null && startElement instanceof PyClass) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                PyOverrideImplementUtil.overrideMethods(editor2, (PyClass)startElement, ContainerUtil.map(this.myToImplement, PyMethodMember::new), true);
            } else {
                PyOverrideImplementUtil.chooseAndImplementMethods(project, editor2, (PyClass)startElement, this.myToImplement);
            }
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toImplement";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/quickfix/PyImplementMethodsQuickFix";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/quickfix/PyImplementMethodsQuickFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

