/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.intentions.PyGenerateDocstringIntention;
import com.jetbrains.python.documentation.docstrings.PyDocstringGenerator;
import com.jetbrains.python.inspections.quickfix.PyQuickFixUtil;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DocstringQuickFix
implements LocalQuickFix {
    private final SmartPsiElementPointer<PyNamedParameter> myMissingParam;
    private final String myUnexpectedParamName;

    public DocstringQuickFix(@Nullable PyNamedParameter missing, @Nullable String unexpectedParamName) {
        this.myMissingParam = missing != null ? SmartPointerManager.getInstance((Project)missing.getProject()).createSmartPsiElementPointer((PsiElement)missing) : null;
        this.myUnexpectedParamName = unexpectedParamName;
    }

    @NotNull
    public String getName() {
        if (this.myMissingParam != null) {
            PyNamedParameter param = (PyNamedParameter)this.myMissingParam.getElement();
            if (param == null) {
                throw new IncorrectOperationException("Parameter was invalidates before quickfix is called");
            }
            String string = PyBundle.message("QFIX.docstring.add.$0", param.getName());
            if (string == null) {
                DocstringQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }
        if (this.myUnexpectedParamName != null) {
            String string = PyBundle.message("QFIX.docstring.remove.$0", this.myUnexpectedParamName);
            if (string == null) {
                DocstringQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = PyBundle.message("QFIX.docstring.insert.stub", new Object[0]);
        if (string == null) {
            DocstringQuickFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("QFIX.fix.docstring", new Object[0]);
        if (string == null) {
            DocstringQuickFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        PyDocStringOwner docStringOwner;
        if (project == null) {
            DocstringQuickFix.$$$reportNull$$$0(4);
        }
        if (descriptor2 == null) {
            DocstringQuickFix.$$$reportNull$$$0(5);
        }
        if ((docStringOwner = (PyDocStringOwner)PsiTreeUtil.getParentOfType((PsiElement)descriptor2.getPsiElement(), PyDocStringOwner.class)) == null) {
            return;
        }
        PyStringLiteralExpression docStringExpression = docStringOwner.getDocStringExpression();
        if (docStringExpression == null && this.myMissingParam == null && this.myUnexpectedParamName == null) {
            DocstringQuickFix.addEmptyDocstring(docStringOwner);
            return;
        }
        if (docStringExpression != null) {
            PyDocstringGenerator generator = PyDocstringGenerator.forDocStringOwner(docStringOwner);
            if (this.myMissingParam != null) {
                PyNamedParameter param = (PyNamedParameter)this.myMissingParam.getElement();
                if (param != null) {
                    generator.withParam(param);
                }
            } else if (this.myUnexpectedParamName != null) {
                generator.withoutParam(this.myUnexpectedParamName.trim());
            }
            generator.buildAndInsert();
        }
    }

    private static void addEmptyDocstring(@NotNull PyDocStringOwner docStringOwner) {
        if (docStringOwner == null) {
            DocstringQuickFix.$$$reportNull$$$0(6);
        }
        if (docStringOwner instanceof PyFunction || docStringOwner instanceof PyClass && ((PyClass)docStringOwner).findInitOrNew(false, null) != null) {
            PyGenerateDocstringIntention.generateDocstring(docStringOwner, PyQuickFixUtil.getEditor((PsiElement)docStringOwner));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/quickfix/DocstringQuickFix";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docStringOwner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/quickfix/DocstringQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addEmptyDocstring";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

