/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.inspections.PyInspectionExtension;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.ParamHelper;
import com.jetbrains.python.psi.impl.PyFunctionBuilder;
import com.jetbrains.python.psi.types.PyModuleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.ui.PyUiUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AddFunctionQuickFix
implements LocalQuickFix {
    private final String myIdentifier;
    private final String myModuleName;

    public AddFunctionQuickFix(@NotNull String identifier, String moduleName) {
        if (identifier == null) {
            AddFunctionQuickFix.$$$reportNull$$$0(0);
        }
        this.myIdentifier = identifier;
        this.myModuleName = moduleName;
    }

    @NotNull
    public String getName() {
        String string = PyBundle.message("QFIX.NAME.add.function.$0.to.module.$1", this.myIdentifier, this.myModuleName);
        if (string == null) {
            AddFunctionQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("QFIX.create.function.in.module", new Object[0]);
        if (string == null) {
            AddFunctionQuickFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        if (project == null) {
            AddFunctionQuickFix.$$$reportNull$$$0(3);
        }
        if (descriptor2 == null) {
            AddFunctionQuickFix.$$$reportNull$$$0(4);
        }
        try {
            PsiElement problemElement = descriptor2.getPsiElement();
            if (!(problemElement instanceof PyQualifiedExpression)) {
                return;
            }
            PyExpression qualifier = ((PyQualifiedExpression)problemElement).getQualifier();
            if (qualifier == null) {
                return;
            }
            PyType type = TypeEvalContext.userInitiated(problemElement.getProject(), problemElement.getContainingFile()).getType(qualifier);
            if (!(type instanceof PyModuleType)) {
                return;
            }
            PyFile file2 = ((PyModuleType)type).getModule();
            PyUtil.sure(file2);
            PyUtil.sure(FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)file2));
            PyFunctionBuilder builder = new PyFunctionBuilder(this.myIdentifier, problemElement);
            PsiElement problemParent = problemElement.getParent();
            if (problemParent instanceof PyCallExpression) {
                PyExpression[] args2;
                PyArgumentList arglist = ((PyCallExpression)problemParent).getArgumentList();
                if (arglist == null) {
                    return;
                }
                for (PyExpression arg : args2 = arglist.getArguments()) {
                    if (arg instanceof PyKeywordArgument) {
                        builder.parameter(((PyKeywordArgument)arg).getKeyword());
                        continue;
                    }
                    if (arg instanceof PyReferenceExpression) {
                        PyReferenceExpression refex = (PyReferenceExpression)arg;
                        builder.parameter(refex.getReferencedName());
                        continue;
                    }
                    builder.parameter("param");
                }
            } else if (problemParent != null) {
                for (PyInspectionExtension extension : PyInspectionExtension.EP_NAME.getExtensionList()) {
                    List<String> params = extension.getFunctionParametersFromUsage(problemElement);
                    if (params == null) continue;
                    for (String param : params) {
                        builder.parameter(param);
                    }
                    break;
                }
            }
            WriteAction.run(() -> {
                PyFunction function = builder.buildFunction();
                function = (PyFunction)file2.add(function);
                AddFunctionQuickFix.showTemplateBuilder(function, file2);
            });
        }
        catch (IncorrectOperationException ignored) {
            PyUiUtil.showBalloon(project, PyBundle.message("QFIX.failed.to.add.function", new Object[0]), MessageType.ERROR);
        }
    }

    private static void showTemplateBuilder(PyFunction method, @NotNull PsiFile file2) {
        if (file2 == null) {
            AddFunctionQuickFix.$$$reportNull$$$0(5);
        }
        method = (PyFunction)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)method);
        final TemplateBuilder builder = TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)method);
        ParamHelper.walkDownParamArray(method.getParameterList().getParameters(), new ParamHelper.ParamVisitor(){

            @Override
            public void visitNamedParameter(PyNamedParameter param, boolean first, boolean last) {
                builder.replaceElement((PsiElement)param, param.getName());
            }
        });
        builder.replaceElement((PsiElement)method.getStatementList(), "return None");
        VirtualFile virtualFile2 = file2.getVirtualFile();
        if (virtualFile2 == null) {
            return;
        }
        Editor editor2 = FileEditorManager.getInstance((Project)file2.getProject()).openTextEditor(new OpenFileDescriptor(file2.getProject(), virtualFile2), true);
        if (editor2 == null) {
            return;
        }
        builder.run(editor2, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/quickfix/AddFunctionQuickFix";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/quickfix/AddFunctionQuickFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "showTemplateBuilder";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

