/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModelKt;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.dataflow.scope.Scope;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.search.PySuperMethodsSearch;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyPsiPep8NamingInspection
extends PyInspection {
    protected static final String INSPECTION_SHORT_NAME = "PyPep8NamingInspection";
    private static final Pattern LOWERCASE_REGEX = Pattern.compile("[_\\p{javaLowerCase}][_\\p{javaLowerCase}0-9]*");
    private static final Pattern UPPERCASE_REGEX = Pattern.compile("[_\\p{javaUpperCase}][_\\p{javaUpperCase}0-9]*");
    private static final Pattern MIXEDCASE_REGEX = Pattern.compile("_?_?[\\p{javaUpperCase}][\\p{javaLowerCase}\\p{javaUpperCase}0-9]*");
    private static final Map<String, String> ERROR_CODES_DESCRIPTION = ImmutableMap.builder().put((Object)"N801", (Object)"Class names should use CamelCase convention").put((Object)"N802", (Object)"Function name should be lowercase").put((Object)"N803", (Object)"Argument name should be lowercase").put((Object)"N806", (Object)"Variable in function should be lowercase").put((Object)"N811", (Object)"Constant variable imported as non constant").put((Object)"N812", (Object)"Lowercase variable imported as non lowercase").put((Object)"N813", (Object)"CamelCase variable imported as lowercase").put((Object)"N814", (Object)"CamelCase variable imported as constant").build();
    public final List<String> ignoredErrors = new ArrayList<String>();
    public boolean ignoreOverriddenFunctions = true;
    public final List<String> ignoredBaseClasses = Lists.newArrayList((Object[])new String[]{"unittest.TestCase", "unittest.case.TestCase"});

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyPsiPep8NamingInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PyPsiPep8NamingInspection.$$$reportNull$$$0(1);
        }
        return new Visitor(holder, session);
    }

    protected LocalQuickFix[] createRenameAndIngoreErrorQuickFixes(@Nullable PsiElement node, String errorCode) {
        return new LocalQuickFix[]{new IgnoreErrorFix(errorCode)};
    }

    protected void addFunctionQuickFixes(ProblemsHolder holder, PyClass containingClass, ASTNode nameNode, List<LocalQuickFix> quickFixes, TypeEvalContext typeEvalContext) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/inspections/PyPsiPep8NamingInspection";
        objectArray[2] = "buildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected static class IgnoreErrorFix
    implements LocalQuickFix {
        private final String myCode;
        private static final String myText = "Ignore errors like this";

        IgnoreErrorFix(String code) {
            this.myCode = code;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return myText;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            if (project == null) {
                IgnoreErrorFix.$$$reportNull$$$0(0);
            }
            if (descriptor2 == null) {
                IgnoreErrorFix.$$$reportNull$$$0(1);
            }
            PsiFile file2 = descriptor2.getStartElement().getContainingFile();
            InspectionProfileModifiableModelKt.modifyAndCommitProjectProfile((Project)project, model -> {
                PyPsiPep8NamingInspection tool = (PyPsiPep8NamingInspection)model.getUnwrappedTool(PyPsiPep8NamingInspection.INSPECTION_SHORT_NAME, (PsiElement)file2);
                if (!tool.ignoredErrors.contains(this.myCode)) {
                    tool.ignoredErrors.add(this.myCode);
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "descriptor";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/python/inspections/PyPsiPep8NamingInspection$IgnoreErrorFix";
            objectArray[2] = "applyFix";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public class Visitor
    extends PyInspectionVisitor {
        public Visitor(ProblemsHolder holder, LocalInspectionToolSession session) {
            super(holder, session);
        }

        @Override
        public void visitPyAssignmentStatement(PyAssignmentStatement node) {
            PyFunction function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)node, PyFunction.class, (boolean)true, (Class[])new Class[]{PyClass.class});
            if (function == null) {
                return;
            }
            Scope scope = ControlFlowCache.getScope(function);
            for (Pair<PyExpression, PyExpression> pair : node.getTargetsToValuesMapping()) {
                PyExpression qualifier;
                String name;
                PyExpression value2 = (PyExpression)pair.getFirst();
                if (value2 == null || (name = value2.getName()) == null || scope.isGlobal(name)) continue;
                if (value2 instanceof PyTargetExpression && (qualifier = ((PyTargetExpression)value2).getQualifier()) != null) {
                    return;
                }
                PyCallExpression assignedValue = PyUtil.as(pair.getSecond(), PyCallExpression.class);
                if (assignedValue != null && assignedValue.getCallee() != null && "namedtuple".equals(assignedValue.getCallee().getName())) {
                    return;
                }
                String errorCode = "N806";
                if (LOWERCASE_REGEX.matcher(name).matches() || name.startsWith("_") || PyPsiPep8NamingInspection.this.ignoredErrors.contains("N806")) continue;
                this.registerAndAddRenameAndIgnoreErrorQuickFixes((PsiElement)value2, "N806");
            }
        }

        @Override
        public void visitPyParameter(PyParameter node) {
            String name = node.getName();
            if (name == null) {
                return;
            }
            String errorCode = "N803";
            if (!LOWERCASE_REGEX.matcher(name).matches() && !PyPsiPep8NamingInspection.this.ignoredErrors.contains("N803")) {
                this.registerAndAddRenameAndIgnoreErrorQuickFixes((PsiElement)node, "N803");
            }
        }

        protected void registerAndAddRenameAndIgnoreErrorQuickFixes(@Nullable PsiElement node, @NotNull String errorCode) {
            if (errorCode == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            if (this.getHolder() != null && this.getHolder().isOnTheFly()) {
                this.registerProblem(node, (String)ERROR_CODES_DESCRIPTION.get(errorCode), PyPsiPep8NamingInspection.this.createRenameAndIngoreErrorQuickFixes(node, errorCode));
            } else {
                this.registerProblem(node, (String)ERROR_CODES_DESCRIPTION.get(errorCode), new IgnoreErrorFix(errorCode));
            }
        }

        @Override
        public void visitPyFunction(PyFunction function) {
            ASTNode nameNode;
            PyClass containingClass = function.getContainingClass();
            if (PyPsiPep8NamingInspection.this.ignoreOverriddenFunctions && this.isOverriddenMethod(function)) {
                return;
            }
            String name = function.getName();
            if (name == null) {
                return;
            }
            if (containingClass != null && (PyUtil.isSpecialName(name) || this.isIgnoredOrHasIgnoredAncestor(containingClass))) {
                return;
            }
            if (!LOWERCASE_REGEX.matcher(name).matches() && (nameNode = function.getNameNode()) != null) {
                ArrayList quickFixes = Lists.newArrayList();
                PyPsiPep8NamingInspection.this.addFunctionQuickFixes(this.getHolder(), containingClass, nameNode, quickFixes, this.myTypeEvalContext);
                String errorCode = "N802";
                if (!PyPsiPep8NamingInspection.this.ignoredErrors.contains("N802")) {
                    quickFixes.add(new IgnoreErrorFix("N802"));
                    this.registerProblem(nameNode.getPsi(), (String)ERROR_CODES_DESCRIPTION.get("N802"), quickFixes.toArray(LocalQuickFix.EMPTY_ARRAY));
                }
            }
        }

        private boolean isOverriddenMethod(@NotNull PyFunction function) {
            if (function == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            return PySuperMethodsSearch.search(function, this.myTypeEvalContext).findFirst() != null;
        }

        private boolean isIgnoredOrHasIgnoredAncestor(@NotNull PyClass pyClass) {
            HashSet blackList;
            if (pyClass == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            if ((blackList = Sets.newHashSet(PyPsiPep8NamingInspection.this.ignoredBaseClasses)).contains(pyClass.getQualifiedName())) {
                return true;
            }
            for (PyClassLikeType ancestor : pyClass.getAncestorTypes(this.myTypeEvalContext)) {
                if (ancestor == null || !blackList.contains(ancestor.getClassQName())) continue;
                return true;
            }
            return false;
        }

        @Override
        public void visitPyClass(PyClass node) {
            String name = node.getName();
            if (name == null) {
                return;
            }
            String errorCode = "N801";
            if (!PyPsiPep8NamingInspection.this.ignoredErrors.contains("N801")) {
                ASTNode nameNode;
                boolean isLowercaseContextManagerClass;
                boolean bl = isLowercaseContextManagerClass = this.isContextManager(node) && LOWERCASE_REGEX.matcher(name).matches();
                if (!isLowercaseContextManagerClass && !MIXEDCASE_REGEX.matcher(name).matches() && (nameNode = node.getNameNode()) != null) {
                    this.registerAndAddRenameAndIgnoreErrorQuickFixes(nameNode.getPsi(), "N801");
                }
            }
        }

        private boolean isContextManager(PyClass node) {
            String[] contextManagerFunctionNames;
            for (String name : contextManagerFunctionNames = new String[]{"__enter__", "__exit__"}) {
                if (node.findMethodByName(name, false, this.myTypeEvalContext) != null) continue;
                return false;
            }
            return true;
        }

        @Override
        public void visitPyImportElement(PyImportElement node) {
            String asName = node.getAsName();
            QualifiedName importedQName = node.getImportedQName();
            if (importedQName == null) {
                return;
            }
            String name = importedQName.getLastComponent();
            if (asName == null || name == null) {
                return;
            }
            if (UPPERCASE_REGEX.matcher(name).matches()) {
                String errorCode = "N811";
                if (!UPPERCASE_REGEX.matcher(asName).matches() && !PyPsiPep8NamingInspection.this.ignoredErrors.contains("N811")) {
                    this.registerAndAddRenameAndIgnoreErrorQuickFixes(node.getAsNameElement(), "N811");
                }
            } else if (LOWERCASE_REGEX.matcher(name).matches()) {
                String errorCode = "N812";
                if (!LOWERCASE_REGEX.matcher(asName).matches() && !PyPsiPep8NamingInspection.this.ignoredErrors.contains("N812")) {
                    this.registerAndAddRenameAndIgnoreErrorQuickFixes(node.getAsNameElement(), "N812");
                }
            } else if (LOWERCASE_REGEX.matcher(asName).matches()) {
                String errorCode = "N813";
                if (!PyPsiPep8NamingInspection.this.ignoredErrors.contains("N813")) {
                    this.registerAndAddRenameAndIgnoreErrorQuickFixes(node.getAsNameElement(), "N813");
                }
            } else if (UPPERCASE_REGEX.matcher(asName).matches()) {
                String errorCode = "N814";
                if (!PyPsiPep8NamingInspection.this.ignoredErrors.contains("N814")) {
                    this.registerAndAddRenameAndIgnoreErrorQuickFixes(node.getAsNameElement(), "N814");
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorCode";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "function";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pyClass";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/inspections/PyPsiPep8NamingInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerAndAddRenameAndIgnoreErrorQuickFixes";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isOverriddenMethod";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isIgnoredOrHasIgnoredAncestor";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

