/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.google.common.collect.ImmutableSet;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.EditInspectionToolsSettingsAction;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ui.ListEditForm;
import com.intellij.core.CoreBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.idea.ActionsBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyPsiPackageUtil;
import com.jetbrains.python.codeInsight.imports.AddImportHelper;
import com.jetbrains.python.codeInsight.stdlib.PyStdlibUtil;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionExtension;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.PyInterpreterInspection;
import com.jetbrains.python.packaging.PyPIPackageUtil;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.packaging.PyPackageManagerUI;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.packaging.PyRequirementsKt;
import com.jetbrains.python.packaging.PyRequirementsTxtUtilKt;
import com.jetbrains.python.packaging.ui.PyChooseRequirementsDialog;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.sdk.pipenv.PipEnvInstallQuickFix;
import com.jetbrains.python.sdk.pipenv.PipenvKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyPackageRequirementsInspection
extends PyInspection {
    public JDOMExternalizableStringList ignoredPackages = new JDOMExternalizableStringList();
    @NotNull
    private static final NotificationGroup BALLOON_NOTIFICATIONS = new NotificationGroup("Package requirements", NotificationDisplayType.BALLOON, false);

    public JComponent createOptionsPanel() {
        ListEditForm form = new ListEditForm("Ignore packages", (List)this.ignoredPackages);
        return form.getContentPanel();
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(1);
        }
        if (!(holder.getFile() instanceof PyFile) && !(holder.getFile() instanceof PsiPlainTextFile)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                PyPackageRequirementsInspection.$$$reportNull$$$0(2);
            }
            return psiElementVisitor;
        }
        return new Visitor(holder, session, (Collection<String>)this.ignoredPackages);
    }

    @Nullable
    public static PyPackageRequirementsInspection getInstance(@NotNull PsiElement element) {
        if (element == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(3);
        }
        InspectionProfileImpl inspectionProfile = InspectionProjectProfileManager.getInstance((Project)element.getProject()).getCurrentProfile();
        String toolName = PyPackageRequirementsInspection.class.getSimpleName();
        return (PyPackageRequirementsInspection)inspectionProfile.getUnwrappedTool(toolName, element);
    }

    @Nullable
    private static Set<PyRequirement> getRequirementsInclTransitive(@NotNull PyPackageManager packageManager, @NotNull Module module) {
        List<PyRequirement> requirements2;
        if (packageManager == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(4);
        }
        if (module == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(5);
        }
        if ((requirements2 = PyPackageRequirementsInspection.getListedRequirements(packageManager, module)) == null) {
            return null;
        }
        if (requirements2.isEmpty()) {
            return Collections.emptySet();
        }
        List<PyPackage> packages = packageManager.getPackages();
        if (packages == null) {
            return null;
        }
        HashSet<PyRequirement> result = new HashSet<PyRequirement>(requirements2);
        result.addAll(PyPackageRequirementsInspection.getTransitiveRequirements(packages, requirements2, new HashSet<PyPackage>()));
        return result;
    }

    @Nullable
    private static List<PyRequirement> getListedRequirements(@NotNull PyPackageManager packageManager, @NotNull Module module) {
        if (packageManager == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(6);
        }
        if (module == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(7);
        }
        List<PyRequirement> requirements2 = packageManager.getRequirements(module);
        List<PyRequirement> extrasRequirements = PyPackageRequirementsInspection.getExtrasRequirements(module);
        if (requirements2 == null) {
            return extrasRequirements;
        }
        if (extrasRequirements == null) {
            return requirements2;
        }
        return ContainerUtil.concat(requirements2, extrasRequirements);
    }

    @Nullable
    private static List<PyRequirement> getExtrasRequirements(@NotNull Module module) {
        Map<String, List<PyRequirement>> extrasRequire;
        if (module == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(8);
        }
        return (extrasRequire = PyPackageUtil.findSetupPyExtrasRequire(module)) == null ? null : ContainerUtil.flatten(extrasRequire.values());
    }

    @NotNull
    private static Set<PyRequirement> getTransitiveRequirements(@NotNull List<PyPackage> packages, @NotNull Collection<PyRequirement> requirements2, @NotNull Set<PyPackage> visited) {
        if (packages == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(9);
        }
        if (requirements2 == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(10);
        }
        if (visited == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(11);
        }
        HashSet<PyRequirement> result = new HashSet<PyRequirement>();
        for (PyRequirement req : requirements2) {
            PyPackage pkg = req.match(packages);
            if (pkg == null || !visited.add(pkg)) continue;
            result.addAll(PyPackageRequirementsInspection.getTransitiveRequirements(packages, pkg.getRequirements(), visited));
        }
        HashSet<PyRequirement> hashSet = result;
        if (hashSet == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(12);
        }
        return hashSet;
    }

    @Nullable
    private static List<PyRequirement> findUnsatisfiedRequirements(@NotNull Module module, @NotNull Sdk sdk, @NotNull Set<String> ignoredPackages) {
        PyPackageManager manager;
        List<PyRequirement> requirements2;
        if (module == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(13);
        }
        if (sdk == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(14);
        }
        if (ignoredPackages == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(15);
        }
        if ((requirements2 = (manager = PyPackageManager.getInstance(sdk)).getRequirements(module)) != null) {
            List<PyPackage> packages = manager.getPackages();
            if (packages == null) {
                return null;
            }
            List<PyPackage> packagesInModule = PyPackageRequirementsInspection.collectPackagesInModule(module);
            ArrayList<PyRequirement> unsatisfied = new ArrayList<PyRequirement>();
            for (PyRequirement req : requirements2) {
                if (ignoredPackages.contains(req.getName()) || req.match(packages) != null || req.match(packagesInModule) != null) continue;
                unsatisfied.add(req);
            }
            return unsatisfied;
        }
        return null;
    }

    @NotNull
    private static List<PyPackage> collectPackagesInModule(@NotNull Module module) {
        if (module == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(16);
        }
        String[] metadataExtensions = new String[]{"egg-info", "dist-info"};
        SmartList result = new SmartList();
        for (VirtualFile srcRoot : PyUtil.getSourceRoots(module)) {
            for (VirtualFile metadata : VfsUtil.getChildren((VirtualFile)srcRoot, file2 -> ArrayUtil.contains((String)file2.getExtension(), (String[])metadataExtensions))) {
                String[] nameAndVersionAndRest = metadata.getNameWithoutExtension().split("-", 3);
                if (nameAndVersionAndRest.length < 2) continue;
                result.add(new PyPackage(nameAndVersionAndRest[0], nameAndVersionAndRest[1], null, Collections.emptyList()));
            }
        }
        SmartList smartList = result;
        if (smartList == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(17);
        }
        return smartList;
    }

    private static void setRunningPackagingTasks(@NotNull Module module, boolean value2) {
        if (module == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(18);
        }
        module.putUserData(PyPackageManager.RUNNING_PACKAGING_TASKS, (Object)value2);
    }

    private static boolean isRunningPackagingTasks(@NotNull Module module) {
        Boolean value2;
        if (module == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(19);
        }
        return (value2 = (Boolean)module.getUserData(PyPackageManager.RUNNING_PACKAGING_TASKS)) != null && value2 != false;
    }

    private static boolean checkAdminPermissionsAndConfigureInterpreter(@NotNull Project project, @NotNull ProblemDescriptor descriptor2, @NotNull Sdk sdk) {
        if (project == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(20);
        }
        if (descriptor2 == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(21);
        }
        if (sdk == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(22);
        }
        if (!PythonSdkUtil.isRemote(sdk) && PySdkExtKt.adminPermissionsNeeded(sdk)) {
            int answer = PyPackageRequirementsInspection.askToConfigureInterpreter(project, sdk);
            switch (answer) {
                case 0: {
                    new PyInterpreterInspection.ConfigureInterpreterFix().applyFix(project, descriptor2);
                    return true;
                }
                case -1: 
                case 2: {
                    return true;
                }
            }
        }
        return false;
    }

    private static int askToConfigureInterpreter(@NotNull Project project, @NotNull Sdk sdk) {
        if (project == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(23);
        }
        if (sdk == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(24);
        }
        String sdkName = StringUtil.shortenTextWithEllipsis((String)sdk.getName(), (int)25, (int)0);
        String text2 = PyBundle.message("INSP.package.requirements.administrator.privileges.required.description", sdkName);
        String[] options = new String[]{PyBundle.message("INSP.package.requirements.administrator.privileges.required.button.configure", new Object[0]), PyBundle.message("INSP.package.requirements.administrator.privileges.required.button.install.anyway", new Object[0]), CoreBundle.message((String)"button.cancel", (Object[])new Object[0])};
        return Messages.showIdeaMessageDialog((Project)project, (String)text2, (String)PyBundle.message("INSP.package.requirements.administrator.privileges.required", new Object[0]), (String[])options, (int)0, (Icon)Messages.getWarningIcon(), null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 12: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 12: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PyPackageRequirementsInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageManager";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 13: 
            case 16: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packages";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requirements";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 14: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoredPackages";
                break;
            }
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PyPackageRequirementsInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getTransitiveRequirements";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "collectPackagesInModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: 
            case 12: 
            case 17: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getRequirementsInclTransitive";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getListedRequirements";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getExtrasRequirements";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getTransitiveRequirements";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findUnsatisfiedRequirements";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "collectPackagesInModule";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setRunningPackagingTasks";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isRunningPackagingTasks";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "checkAdminPermissionsAndConfigureInterpreter";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "askToConfigureInterpreter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 12: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class IgnoreRequirementFix
    implements LocalQuickFix {
        @NotNull
        private final Set<String> myPackageNames;

        private IgnoreRequirementFix(@NotNull Set<String> packageNames) {
            if (packageNames == null) {
                IgnoreRequirementFix.$$$reportNull$$$0(0);
            }
            this.myPackageNames = packageNames;
        }

        @NotNull
        public String getFamilyName() {
            boolean plural = this.myPackageNames.size() > 1;
            String string = String.format("Ignore requirement%s", plural ? "s" : "");
            if (string == null) {
                IgnoreRequirementFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            PyPackageRequirementsInspection inspection;
            PsiElement element;
            if (project == null) {
                IgnoreRequirementFix.$$$reportNull$$$0(2);
            }
            if (descriptor2 == null) {
                IgnoreRequirementFix.$$$reportNull$$$0(3);
            }
            if ((element = descriptor2.getPsiElement()) != null && (inspection = PyPackageRequirementsInspection.getInstance(element)) != null) {
                HashSet<String> packagesToIgnore = new HashSet<String>(this.myPackageNames);
                for (String pkg : inspection.ignoredPackages) {
                    packagesToIgnore.remove(pkg);
                }
                if (!packagesToIgnore.isEmpty()) {
                    inspection.ignoredPackages.addAll(packagesToIgnore);
                    ProjectInspectionProfileManager profileManager = ProjectInspectionProfileManager.getInstance((Project)project);
                    profileManager.fireProfileChanged();
                    Notification notification2 = BALLOON_NOTIFICATIONS.createNotification(packagesToIgnore.size() == 1 ? PyBundle.message("INSP.package.requirements.requirement.has.been.ignored", packagesToIgnore.iterator().next()) : PyBundle.message("INSP.package.requirements.requirements.have.been.ignored", new Object[0]), NotificationType.INFORMATION);
                    notification2.addAction((AnAction)NotificationAction.createSimpleExpiring((String)ActionsBundle.message((String)"action.$Undo.text", (Object[])new Object[0]), () -> {
                        inspection.ignoredPackages.removeAll((Collection)packagesToIgnore);
                        profileManager.fireProfileChanged();
                    }));
                    notification2.addAction((AnAction)NotificationAction.createSimpleExpiring((String)InspectionsBundle.message((String)"inspection.action.edit.settings", (Object[])new Object[0]), () -> {
                        InspectionProfileImpl profile = profileManager.getCurrentProfile();
                        String toolName = PyPackageRequirementsInspection.class.getSimpleName();
                        EditInspectionToolsSettingsAction.editToolSettings((Project)project, (InspectionProfileImpl)profile, (String)toolName);
                    }));
                    notification2.notify(project);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageNames";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyPackageRequirementsInspection$IgnoreRequirementFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyPackageRequirementsInspection$IgnoreRequirementFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class RunningPackagingTasksListener
    implements PyPackageManagerUI.Listener {
        @NotNull
        private final Module myModule;

        public RunningPackagingTasksListener(@NotNull Module module) {
            if (module == null) {
                RunningPackagingTasksListener.$$$reportNull$$$0(0);
            }
            this.myModule = module;
        }

        @Override
        public void started() {
            PyPackageRequirementsInspection.setRunningPackagingTasks(this.myModule, true);
        }

        @Override
        public void finished(List<ExecutionException> exceptions) {
            PyPackageRequirementsInspection.setRunningPackagingTasks(this.myModule, false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/jetbrains/python/inspections/PyPackageRequirementsInspection$RunningPackagingTasksListener", "<init>"));
        }
    }

    public static class PyGenerateRequirementsFileQuickFix
    implements LocalQuickFix {
        private final Module myModule;

        public PyGenerateRequirementsFileQuickFix(Module module) {
            this.myModule = module;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = PyBundle.message("python.requirements.quickfix.family.name", new Object[0]);
            if (string == null) {
                PyGenerateRequirementsFileQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            if (project == null) {
                PyGenerateRequirementsFileQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor2 == null) {
                PyGenerateRequirementsFileQuickFix.$$$reportNull$$$0(2);
            }
            PyRequirementsTxtUtilKt.syncWithImports(this.myModule);
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyPackageRequirementsInspection$PyGenerateRequirementsFileQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyPackageRequirementsInspection$PyGenerateRequirementsFileQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class InstallAndImportQuickFix
    implements LocalQuickFix {
        @Nullable
        private final Sdk mySdk;
        @Nullable
        private final Module myModule;
        @NotNull
        private final String myPackageName;
        @Nullable
        private final String myAsName;
        @NotNull
        private final SmartPsiElementPointer<PyElement> myNode;

        public InstallAndImportQuickFix(@NotNull String packageName, @Nullable String asName, @NotNull PyElement node) {
            if (packageName == null) {
                InstallAndImportQuickFix.$$$reportNull$$$0(0);
            }
            if (node == null) {
                InstallAndImportQuickFix.$$$reportNull$$$0(1);
            }
            this.myPackageName = packageName;
            this.myAsName = asName;
            this.myNode = SmartPointerManager.getInstance((Project)node.getProject()).createSmartPsiElementPointer((PsiElement)node, node.getContainingFile());
            this.myModule = ModuleUtilCore.findModuleForPsiElement((PsiElement)node);
            this.mySdk = PythonSdkUtil.findPythonSdk(this.myModule);
        }

        @Nls
        @NotNull
        public String getName() {
            String string = PyBundle.message("QFIX.NAME.install.and.import.package", this.myPackageName);
            if (string == null) {
                InstallAndImportQuickFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = PyBundle.message("QFIX.install.and.import.package", new Object[0]);
            if (string == null) {
                InstallAndImportQuickFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            if (project == null) {
                InstallAndImportQuickFix.$$$reportNull$$$0(4);
            }
            if (descriptor2 == null) {
                InstallAndImportQuickFix.$$$reportNull$$$0(5);
            }
            if (this.mySdk == null || !PyPackageRequirementsInspection.checkAdminPermissionsAndConfigureInterpreter(project, descriptor2, this.mySdk)) {
                this.installAndImportPackage(project);
            }
        }

        private void installAndImportPackage(final @NotNull Project project) {
            if (project == null) {
                InstallAndImportQuickFix.$$$reportNull$$$0(6);
            }
            if (this.mySdk == null) {
                return;
            }
            PyPackageManagerUI ui2 = new PyPackageManagerUI(project, this.mySdk, new RunningPackagingTasksListener(this.myModule){

                @Override
                public void finished(List<ExecutionException> exceptions) {
                    super.finished(exceptions);
                    if (exceptions.isEmpty()) {
                        PyElement element = (PyElement)myNode.getElement();
                        if (element == null) {
                            return;
                        }
                        CommandProcessor.getInstance().executeCommand(project, () -> ApplicationManager.getApplication().runWriteAction(() -> AddImportHelper.addImportStatement(element.getContainingFile(), myPackageName, myAsName, AddImportHelper.ImportPriority.THIRD_PARTY, (PsiElement)element)), PyBundle.message("INSP.package.requirements.add.import", new Object[0]), (Object)"Add import");
                    }
                }
            });
            ui2.install(Collections.singletonList(PyRequirementsKt.pyRequirement(this.myPackageName)), Collections.emptyList());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyPackageRequirementsInspection$InstallAndImportQuickFix";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyPackageRequirementsInspection$InstallAndImportQuickFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "installAndImportPackage";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class PyInstallRequirementsFix
    implements LocalQuickFix {
        @NotNull
        private final String myName;
        @NotNull
        private final Module myModule;
        @NotNull
        private final Sdk mySdk;
        @NotNull
        private final List<PyRequirement> myUnsatisfied;
        @NotNull
        private final List<String> myExtraArgs;
        @Nullable
        private final PyPackageManagerUI.Listener myListener;

        public PyInstallRequirementsFix(@Nullable String name, @NotNull Module module, @NotNull Sdk sdk, @NotNull List<PyRequirement> unsatisfied) {
            if (module == null) {
                PyInstallRequirementsFix.$$$reportNull$$$0(0);
            }
            if (sdk == null) {
                PyInstallRequirementsFix.$$$reportNull$$$0(1);
            }
            if (unsatisfied == null) {
                PyInstallRequirementsFix.$$$reportNull$$$0(2);
            }
            this(name, module, sdk, unsatisfied, Collections.emptyList(), null);
        }

        public PyInstallRequirementsFix(@Nullable String name, @NotNull Module module, @NotNull Sdk sdk, @NotNull List<PyRequirement> unsatisfied, @NotNull List<String> extraArgs, @Nullable PyPackageManagerUI.Listener listener2) {
            boolean plural;
            if (module == null) {
                PyInstallRequirementsFix.$$$reportNull$$$0(3);
            }
            if (sdk == null) {
                PyInstallRequirementsFix.$$$reportNull$$$0(4);
            }
            if (unsatisfied == null) {
                PyInstallRequirementsFix.$$$reportNull$$$0(5);
            }
            if (extraArgs == null) {
                PyInstallRequirementsFix.$$$reportNull$$$0(6);
            }
            boolean bl = plural = unsatisfied.size() > 1;
            this.myName = name != null ? name : String.format("Install requirement%s", plural ? "s" : "");
            this.myModule = module;
            this.mySdk = sdk;
            this.myUnsatisfied = unsatisfied;
            this.myExtraArgs = extraArgs;
            this.myListener = listener2;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.myName;
            if (string == null) {
                PyInstallRequirementsFix.$$$reportNull$$$0(7);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            if (project == null) {
                PyInstallRequirementsFix.$$$reportNull$$$0(8);
            }
            if (descriptor2 == null) {
                PyInstallRequirementsFix.$$$reportNull$$$0(9);
            }
            if (!PyPackageRequirementsInspection.checkAdminPermissionsAndConfigureInterpreter(project, descriptor2, this.mySdk)) {
                this.installPackages(project);
            }
        }

        private void installPackages(final @NotNull Project project) {
            boolean hasManagement;
            PyChooseRequirementsDialog dialog;
            PyPackageManager manager;
            List<PyPackage> packages;
            if (project == null) {
                PyInstallRequirementsFix.$$$reportNull$$$0(10);
            }
            if ((packages = (manager = PyPackageManager.getInstance(this.mySdk)).getPackages()) == null) {
                return;
            }
            final List<PyRequirement> chosen = this.myUnsatisfied.size() > 1 ? ((dialog = new PyChooseRequirementsDialog(project, this.myUnsatisfied)).showAndGet() ? dialog.getMarkedElements() : Collections.emptyList()) : this.myUnsatisfied;
            if (chosen.isEmpty()) {
                return;
            }
            try {
                hasManagement = manager.hasManagement();
            }
            catch (ExecutionException e) {
                hasManagement = false;
            }
            if (!hasManagement) {
                PyPackageManagerUI ui2 = new PyPackageManagerUI(project, this.mySdk, new RunningPackagingTasksListener(this.myModule){

                    @Override
                    public void finished(List<ExecutionException> exceptions) {
                        super.finished(exceptions);
                        if (exceptions.isEmpty()) {
                            this.installRequirements(project, chosen);
                        }
                    }
                });
                ui2.installManagement();
            } else {
                this.installRequirements(project, chosen);
            }
        }

        private void installRequirements(Project project, List<PyRequirement> requirements2) {
            RunningPackagingTasksListener listener2 = this.myListener == null ? new RunningPackagingTasksListener(this.myModule) : new RunningPackagingTasksListener(this.myModule){

                @Override
                public void started() {
                    super.started();
                    myListener.started();
                }

                @Override
                public void finished(List<ExecutionException> exceptions) {
                    super.finished(exceptions);
                    myListener.finished(exceptions);
                }
            };
            new PyPackageManagerUI(project, this.mySdk, listener2).install(requirements2, this.myExtraArgs);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdk";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unsatisfied";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extraArgs";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyPackageRequirementsInspection$PyInstallRequirementsFix";
                    break;
                }
                case 8: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyPackageRequirementsInspection$PyInstallRequirementsFix";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 7: {
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "installPackages";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class Visitor
    extends PyInspectionVisitor {
        private final Set<String> myIgnoredPackages;

        Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session, Collection<String> ignoredPackages) {
            if (session == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, session);
            this.myIgnoredPackages = ImmutableSet.copyOf(ignoredPackages);
        }

        @Override
        public void visitPyFile(PyFile node) {
            this.checkPackagesHaveBeenInstalled((PsiElement)node, ModuleUtilCore.findModuleForPsiElement((PsiElement)node));
        }

        public void visitPlainTextFile(@NotNull PsiPlainTextFile file2) {
            Module module;
            if (file2 == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file2)) != null && file2.getVirtualFile().equals(PyPackageUtil.findRequirementsTxt(module))) {
                if (file2.getText().trim().isEmpty()) {
                    this.registerProblem((PsiElement)file2, PyBundle.message("python.requirements.file.empty", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, null, new PyGenerateRequirementsFileQuickFix(module));
                } else {
                    this.checkPackagesHaveBeenInstalled((PsiElement)file2, module);
                }
            }
        }

        private void checkPackagesHaveBeenInstalled(@NotNull PsiElement file2, @Nullable Module module) {
            List unsatisfied;
            Sdk sdk;
            if (file2 == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            if (module != null && !PyPackageRequirementsInspection.isRunningPackagingTasks(module) && (sdk = PythonSdkUtil.findPythonSdk(module)) != null && (unsatisfied = PyPackageRequirementsInspection.findUnsatisfiedRequirements(module, sdk, this.myIgnoredPackages)) != null && !unsatisfied.isEmpty()) {
                boolean plural = unsatisfied.size() > 1;
                String msg = String.format("Package requirement%s %s %s not satisfied", plural ? "s" : "", PyPackageUtil.requirementsToString(unsatisfied), plural ? "are" : "is");
                ArrayList<Object> quickFixes = new ArrayList<Object>();
                if (PipenvKt.isPipEnv(sdk)) {
                    quickFixes.add(new PipEnvInstallQuickFix());
                } else {
                    quickFixes.add(new PyInstallRequirementsFix(null, module, sdk, unsatisfied));
                }
                quickFixes.add(new IgnoreRequirementFix(ContainerUtil.map2Set((Collection)unsatisfied, PyRequirement::getName)));
                this.registerProblem(file2, msg, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, null, quickFixes.toArray(LocalQuickFix.EMPTY_ARRAY));
            }
        }

        @Override
        public void visitPyFromImportStatement(PyFromImportStatement node) {
            PyReferenceExpression expr = node.getImportSource();
            if (expr != null) {
                this.checkPackageNameInRequirements(expr);
            }
        }

        @Override
        public void visitPyImportStatement(PyImportStatement node) {
            for (PyImportElement element : node.getImportElements()) {
                PyReferenceExpression expr = element.getImportReferenceExpression();
                if (expr == null) continue;
                this.checkPackageNameInRequirements(expr);
            }
        }

        private void checkPackageNameInRequirements(@NotNull PyQualifiedExpression importedExpression) {
            block18: {
                PsiReference reference;
                if (importedExpression == null) {
                    Visitor.$$$reportNull$$$0(3);
                }
                for (PyInspectionExtension extension : PyInspectionExtension.EP_NAME.getExtensionList()) {
                    if (!extension.ignorePackageNameInRequirements(importedExpression)) continue;
                    return;
                }
                PyExpression packageReferenceExpression = PyPsiUtils.getFirstQualifier(importedExpression);
                String packageName = packageReferenceExpression.getName();
                if (packageName == null || this.myIgnoredPackages.contains(packageName)) break block18;
                List possiblePyPIPackageNames = (List)PyPsiPackageUtil.PACKAGES_TOPLEVEL.getOrDefault((Object)packageName, Collections.emptyList());
                if (!ApplicationManager.getApplication().isUnitTestMode() && !PyPIPackageUtil.INSTANCE.isInPyPI(packageName)) {
                    if (!ContainerUtil.exists((Iterable)possiblePyPIPackageNames, PyPIPackageUtil.INSTANCE::isInPyPI)) {
                        return;
                    }
                }
                if ("setuptools".equals(packageName)) {
                    return;
                }
                Collection<String> stdlibPackages = PyStdlibUtil.getPackages();
                if (stdlibPackages != null && stdlibPackages.contains(packageName)) {
                    return;
                }
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)packageReferenceExpression);
                if (module == null) {
                    return;
                }
                Sdk sdk = PythonSdkUtil.findPythonSdk(module);
                if (sdk == null) {
                    return;
                }
                PyPackageManager packageManager = PyPackageManager.getInstance(sdk);
                Set requirements2 = PyPackageRequirementsInspection.getRequirementsInclTransitive(packageManager, module);
                if (requirements2 == null) {
                    return;
                }
                for (PyRequirement req : requirements2) {
                    String name;
                    block20: {
                        block19: {
                            name = req.getName();
                            if (name.equalsIgnoreCase(packageName)) break block19;
                            if (!ContainerUtil.exists((Iterable)possiblePyPIPackageNames, name::equalsIgnoreCase)) break block20;
                        }
                        return;
                    }
                    String nameWhereUnderscoreReplacedWithHyphen = name.replaceAll("_", "-");
                    if (ContainerUtil.exists((Iterable)possiblePyPIPackageNames, nameWhereUnderscoreReplacedWithHyphen::equalsIgnoreCase)) {
                        return;
                    }
                    String nameWhereHyphenReplacedWithUnderscore = name.replaceAll("-", "_");
                    if (!nameWhereHyphenReplacedWithUnderscore.equalsIgnoreCase(packageName)) {
                        if (!ContainerUtil.exists((Iterable)possiblePyPIPackageNames, nameWhereHyphenReplacedWithUnderscore::equalsIgnoreCase)) continue;
                    }
                    return;
                }
                if (!ApplicationManager.getApplication().isUnitTestMode() && (reference = packageReferenceExpression.getReference()) != null) {
                    VirtualFile virtualFile2;
                    PsiFile file2;
                    PsiElement element = reference.resolve();
                    if (element instanceof PsiDirectory && ModuleUtilCore.moduleContainsFile((Module)module, (VirtualFile)((PsiDirectory)element).getVirtualFile(), (boolean)false)) {
                        return;
                    }
                    if (element != null && (file2 = element.getContainingFile()) != null && ModuleUtilCore.moduleContainsFile((Module)module, (VirtualFile)(virtualFile2 = file2.getVirtualFile()), (boolean)false)) {
                        return;
                    }
                }
                LocalQuickFix[] fixes = new LocalQuickFix[]{new PyGenerateRequirementsFileQuickFix(module), new IgnoreRequirementFix(Collections.singleton(packageName))};
                this.registerProblem((PsiElement)packageReferenceExpression, String.format("Package containing module '%s' is not listed in project requirements", packageName), ProblemHighlightType.WEAK_WARNING, null, fixes);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "importedExpression";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/inspections/PyPackageRequirementsInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPlainTextFile";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkPackagesHaveBeenInstalled";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkPackageNameInRequirements";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

