/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.MoveFromFutureImportQuickFix;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyFromFutureImportInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyFromFutureImportInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PyFromFutureImportInspection.$$$reportNull$$$0(1);
        }
        return new Visitor(holder, session);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/inspections/PyFromFutureImportInspection";
        objectArray[2] = "buildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Visitor
    extends PyInspectionVisitor {
        Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            if (session == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, session);
        }

        @Override
        public void visitPyFromImportStatement(PyFromImportStatement node) {
            PsiFile file2;
            PyReferenceExpression importSource = node.getImportSource();
            if (importSource != null && "__future__".equals(importSource.getName()) && (file2 = importSource.getContainingFile()) instanceof PyFile) {
                List<PyStatement> statementList = ((PyFile)file2).getStatements();
                boolean skippedDocString = false;
                for (PyStatement statement : statementList) {
                    if (statement instanceof PyExpressionStatement && ((PyExpressionStatement)statement).getExpression() instanceof PyStringLiteralExpression && !skippedDocString) {
                        skippedDocString = true;
                        continue;
                    }
                    if (statement instanceof PyFromImportStatement) {
                        if (statement == node) {
                            return;
                        }
                        PyReferenceExpression source2 = ((PyFromImportStatement)statement).getImportSource();
                        if (source2 != null && "__future__".equals(source2.getName())) continue;
                    }
                    this.registerProblem((PsiElement)node, "from __future__ imports must occur at the beginning of the file", new MoveFromFutureImportQuickFix());
                    return;
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyFromFutureImportInspection$Visitor", "<init>"));
        }
    }
}

