/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.psi.FutureFeature;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyByteLiteralInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyByteLiteralInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PyByteLiteralInspection.$$$reportNull$$$0(1);
        }
        return new Visitor(holder, session);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/inspections/PyByteLiteralInspection";
        objectArray[2] = "buildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Visitor
    extends PyInspectionVisitor {
        Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            if (session == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, session);
        }

        @Override
        public void visitPyStringLiteralExpression(PyStringLiteralExpression node) {
            char first_char;
            boolean isByte;
            String value2 = node.getStringValue();
            PsiFile file2 = node.getContainingFile();
            if (file2 == null) {
                return;
            }
            boolean default_bytes = false;
            if (file2 instanceof PyFile) {
                PyFile pyfile = (PyFile)file2;
                default_bytes = !FutureFeature.UNICODE_LITERALS.requiredAt(pyfile.getLanguageLevel()) && !pyfile.hasImportFromFuture(FutureFeature.UNICODE_LITERALS);
            }
            String charsetString = PythonFileType.getCharsetFromEncodingDeclaration(file2);
            try {
                if (charsetString != null && !Charset.forName(charsetString).equals(Charset.forName("US-ASCII"))) {
                    default_bytes = false;
                }
            }
            catch (IllegalCharsetNameException | UnsupportedCharsetException illegalArgumentException) {
                // empty catch block
            }
            boolean hasNonAscii = false;
            int length = value2.length();
            char c = '\u0000';
            for (int i = 0; i < length; ++i) {
                c = value2.charAt(i);
                if (c <= '\u00ff') continue;
                hasNonAscii = true;
                break;
            }
            boolean bl = isByte = (first_char = Character.toLowerCase(node.getText().charAt(0))) == 'b' || default_bytes && first_char != 'u';
            if (hasNonAscii && isByte) {
                this.registerProblem(node, "Byte literal contains characters > 255");
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyByteLiteralInspection$Visitor", "<init>"));
        }
    }
}

