/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.gherkin.gui;

import com.intellij.DynamicBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.python.gherkin.PyBDDBundle;
import com.jetbrains.python.gherkin.PyBDDFramework;
import com.jetbrains.python.gherkin.api.PyGherkinApi;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PyBDDModuleConfigurable
implements Configurable,
ActionListener {
    @NotNull
    private final Module myModule;
    private JPanel myMainPanel;
    private JComboBox myList;
    private JBLabel myError;
    private String myInitialItem;

    PyBDDModuleConfigurable(@NotNull Module module) {
        if (module == null) {
            PyBDDModuleConfigurable.$$$reportNull$$$0(0);
        }
        this.myModule = module;
        this.$$$setupUI$$$();
    }

    @Nls
    public String getDisplayName() {
        return PyBDDBundle.message("com.jetbrains.python.gherkin.configuration.module.display-name", this.myModule.getName());
    }

    @Nullable
    public JComponent createComponent() {
        this.myList.addItem(PyBDDBundle.message("com.jetbrains.python.gherkin.configuration.prefered", new Object[0]));
        PyGherkinApi api = new PyGherkinApi(this.myModule);
        List<PyBDDFramework> frameworks = api.getAllFrameworks();
        if (frameworks.isEmpty()) {
            this.myError.setVisible(true);
            return this.myError;
        }
        for (PyBDDFramework framework : frameworks) {
            this.myList.addItem(framework.getFrameworkName());
        }
        this.myList.addActionListener(this);
        this.loadFromApi();
        this.ensureInstalled();
        return this.myMainPanel;
    }

    public boolean isModified() {
        return !this.myList.getSelectedItem().equals(this.myInitialItem);
    }

    public void apply() throws ConfigurationException {
        PyGherkinApi api = new PyGherkinApi(this.myModule);
        PyBDDFramework framework = api.findFrameworkByName(this.getSelectedFrameworkName());
        api.setPreferedFramework(framework);
        this.loadFromApi();
    }

    public void reset() {
        this.loadFromApi();
    }

    public void disposeUIResources() {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.ensureInstalled();
    }

    private void ensureInstalled() {
        PyGherkinApi api = new PyGherkinApi(this.myModule);
        PyBDDFramework framework = api.findFrameworkByName(this.getSelectedFrameworkName());
        if (framework != null) {
            this.myError.setVisible(!api.isInstalledFramework(framework));
        } else {
            this.myError.setVisible(false);
        }
    }

    @NotNull
    private String getSelectedFrameworkName() {
        String string = this.myList.getSelectedItem().toString();
        if (string == null) {
            PyBDDModuleConfigurable.$$$reportNull$$$0(1);
        }
        return string;
    }

    private void loadFromApi() {
        PyGherkinApi api = new PyGherkinApi(this.myModule);
        PyBDDFramework preferedFramework = api.getPreferedFramework();
        if (preferedFramework != null) {
            this.myList.setSelectedItem(preferedFramework.getFrameworkName());
        } else {
            this.myList.setSelectedIndex(0);
        }
        this.myInitialItem = this.myList.getSelectedItem().toString();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JBLabel jBLabel;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 5, 0, 2, 1, 6, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/PyBDDBundle", PyBDDModuleConfigurable.class).getString("com.jetbrains.python.gherkin.configuration.choose_framework"));
        jPanel.add((Component)jBLabel2, new GridConstraints(0, 1, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myError = jBLabel = new JBLabel();
        jBLabel.setEnabled(true);
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/PyBDDBundle", PyBDDModuleConfigurable.class).getString("com.jetbrains.python.gherkin.configuration.framework_does_not_exist"));
        jBLabel.setVisible(false);
        jPanel.add((Component)jBLabel, new GridConstraints(0, 4, 1, 1, 8, 0, 4, 0, null, null, null));
        this.myList = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(0, 2, 1, 1, 8, 0, 2, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/gherkin/gui/PyBDDModuleConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/gherkin/gui/PyBDDModuleConfigurable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedFrameworkName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

