/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.gherkin;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.gherkin.matchers.PyBDDMatcher;
import com.jetbrains.python.gherkin.matchers.PyBDDProcessor;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyEvaluator;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.intellij.lang.regexp.RegExpFile;
import org.intellij.lang.regexp.RegExpLanguage;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;
import org.jetbrains.plugins.cucumber.steps.AbstractStepDefinition;

public class PyStepDefinition
extends AbstractStepDefinition {
    private static final String LINE_START_PREFIX = "^";
    private static final String LINE_END_POSTFIX = "$";
    private static final Pattern NAMED_GROUP_PREFIX = Pattern.compile("\\(\\?P<[^>]+>");
    @NotNull
    private final Project myProject;
    @NotNull
    protected final TypeEvalContext myDefaultEvalContext;

    protected PyStepDefinition(@NotNull PyDecorator stepDefinition, @NotNull TypeEvalContext defaultEvalContext) {
        if (stepDefinition == null) {
            PyStepDefinition.$$$reportNull$$$0(0);
        }
        if (defaultEvalContext == null) {
            PyStepDefinition.$$$reportNull$$$0(1);
        }
        super((PsiElement)stepDefinition);
        this.myProject = stepDefinition.getProject();
        this.myDefaultEvalContext = defaultEvalContext;
    }

    protected boolean isCaseSensitive() {
        return false;
    }

    public final List<String> getVariableNames() {
        return ContainerUtil.filter(this.getPlaceHolders(this.myDefaultEvalContext), o -> o != null);
    }

    @NotNull
    public final List<String> getPlaceHolders(@NotNull TypeEvalContext context) {
        RegExpFile regExpFile;
        if (context == null) {
            PyStepDefinition.$$$reportNull$$$0(2);
        }
        if ((regExpFile = this.getAsRegexp(context)) != null) {
            ArrayList<String> varNames = new ArrayList<String>();
            for (RegExpGroup group2 : regExpFile.getGroups()) {
                if (!group2.isCapturing()) continue;
                String groupName = group2.getGroupName();
                varNames.add(groupName);
            }
            ArrayList<String> arrayList = varNames;
            if (arrayList == null) {
                PyStepDefinition.$$$reportNull$$$0(3);
            }
            return arrayList;
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            PyStepDefinition.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Nullable
    protected final String getCucumberRegexFromElement(@NotNull PsiElement element) {
        boolean hasNamedGroups;
        RegExpFile regexp;
        if (element == null) {
            PyStepDefinition.$$$reportNull$$$0(5);
        }
        if ((regexp = this.getAsRegexp(this.myDefaultEvalContext)) == null) {
            return null;
        }
        String regexpText = regexp.getText();
        boolean bl = hasNamedGroups = !regexp.getGroups().isEmpty();
        if (hasNamedGroups) {
            regexpText = NAMED_GROUP_PREFIX.matcher(regexpText).replaceAll("(");
        }
        if (!regexpText.startsWith(LINE_START_PREFIX)) {
            regexpText = LINE_START_PREFIX + regexpText;
        }
        if (!regexpText.endsWith(LINE_END_POSTFIX)) {
            regexpText = regexpText + LINE_END_POSTFIX;
        }
        return regexpText;
    }

    @Nullable
    protected PyStringLiteralExpression getExpression(@NotNull TypeEvalContext context) {
        PyDecorator decorator;
        if (context == null) {
            PyStepDefinition.$$$reportNull$$$0(6);
        }
        if ((decorator = this.getDecorator()) == null) {
            return null;
        }
        if (!context.maySwitchToAST((PsiElement)decorator)) {
            return null;
        }
        PyStringLiteralExpression argument = (PyStringLiteralExpression)ObjectUtils.tryCast((Object)decorator.getArgument(0, PyExpression.class), PyStringLiteralExpression.class);
        if (argument == null) {
            return null;
        }
        return argument;
    }

    @Nullable
    protected final PyDecorator getDecorator() {
        return (PyDecorator)ObjectUtils.tryCast((Object)this.getElement(), PyDecorator.class);
    }

    public final void setCucumberRegex(@NotNull String newValue) {
        PyStringLiteralExpression expression;
        PyDecorator decorator;
        if (newValue == null) {
            PyStepDefinition.$$$reportNull$$$0(7);
        }
        if ((decorator = this.getDecorator()) == null) {
            return;
        }
        PyBDDMatcher matcher = this.getMatcher(decorator);
        String currentValue = this.getAsString(this.myDefaultEvalContext);
        if (currentValue != null) {
            if (!currentValue.startsWith(LINE_START_PREFIX)) {
                newValue = StringUtil.trimStart((String)newValue, (String)LINE_START_PREFIX);
            }
            if (!currentValue.endsWith(LINE_END_POSTFIX)) {
                newValue = StringUtil.trimEnd((String)newValue, (String)LINE_END_POSTFIX);
            }
        }
        if (matcher != null) {
            newValue = matcher.escapeSpecialChars(newValue);
        }
        if ((expression = this.getExpression(this.myDefaultEvalContext)) == null) {
            return;
        }
        PyStringLiteralExpression newLiteral = PyElementGenerator.getInstance(this.myProject).createStringLiteralFromString(newValue);
        expression.replace(newLiteral);
    }

    public final boolean supportsRename(@Nullable String newName) {
        String currentValue;
        if (!super.supportsRename(newName)) {
            return false;
        }
        if (newName == null && ((currentValue = this.getAsString(this.myDefaultEvalContext)) == null || PyBDDMatcher.RE.containsSpecialChars(currentValue))) {
            return false;
        }
        if (newName != null && PyBDDMatcher.RE.containsSpecialChars(newName)) {
            return false;
        }
        RegExpFile currentDefinitionRegexp = this.getAsRegexp(this.myDefaultEvalContext);
        if (currentDefinitionRegexp == null || !currentDefinitionRegexp.getGroups().isEmpty()) {
            return false;
        }
        Collection steps = this.findSteps((SearchScope)GlobalSearchScope.allScope((Project)this.myProject));
        if (steps.size() != 1) {
            return false;
        }
        GherkinStep step = (GherkinStep)steps.iterator().next();
        return step.findDefinitions().size() == 1;
    }

    @Nullable
    protected PyBDDMatcher getMatcher(@NotNull PyDecorator decorator) {
        if (decorator == null) {
            PyStepDefinition.$$$reportNull$$$0(8);
        }
        return PyBDDMatcher.RE;
    }

    @Nullable
    public String getAsString(@NotNull TypeEvalContext evalContext) {
        PyStringLiteralExpression literalExpression;
        if (evalContext == null) {
            PyStepDefinition.$$$reportNull$$$0(9);
        }
        return (literalExpression = this.getExpression(evalContext)) != null ? PyEvaluator.evaluate(literalExpression, String.class) : null;
    }

    @Nullable
    private RegExpFile getAsRegexp(@NotNull TypeEvalContext evalContext) {
        PyDecorator element;
        if (evalContext == null) {
            PyStepDefinition.$$$reportNull$$$0(10);
        }
        if ((element = this.getDecorator()) == null) {
            return null;
        }
        Pair param = Pair.create((Object)element, (Object)evalContext);
        return (RegExpFile)PyUtil.getNullableParameterizedCachedValue((PsiElement)element, param, p -> this.getRegexInternal((TypeEvalContext)p.second, (PyDecorator)p.first));
    }

    @Nullable
    private RegExpFile getRegexInternal(@NotNull TypeEvalContext evalContext, PyDecorator element) {
        PyBDDProcessor processor2;
        if (evalContext == null) {
            PyStepDefinition.$$$reportNull$$$0(11);
        }
        String result = null;
        PyBDDMatcher matcher = this.getMatcher(element);
        PyBDDProcessor pyBDDProcessor = processor2 = matcher != null ? matcher.getPatternProcessor() : this.getProcessorWhenNoMatcher(evalContext);
        if (processor2 != null) {
            String parseResult = processor2.getPythonRegexp(this, evalContext);
            if (parseResult != null) {
                result = parseResult;
            }
        } else {
            String regexAsString = this.getAsString(evalContext);
            if (regexAsString != null) {
                result = '^' + PyBDDMatcher.RE.escapeSpecialChars(regexAsString) + '$';
            }
        }
        if (result == null) {
            return null;
        }
        PsiFile file2 = PsiFileFactory.getInstance((Project)this.myProject).createFileFromText((Language)RegExpLanguage.INSTANCE, (CharSequence)result);
        return (RegExpFile)ObjectUtils.tryCast((Object)file2, RegExpFile.class);
    }

    @Nullable
    protected PyBDDProcessor getProcessorWhenNoMatcher(@NotNull TypeEvalContext evalContext) {
        if (evalContext == null) {
            PyStepDefinition.$$$reportNull$$$0(12);
        }
        return null;
    }

    @Nullable
    public final PyType getType(@NotNull TypeEvalContext evalContext, @Nullable String name, int index) {
        PyBDDProcessor processor2;
        if (evalContext == null) {
            PyStepDefinition.$$$reportNull$$$0(13);
        }
        if (name == null) {
            return null;
        }
        PyDecorator decorator = this.getDecorator();
        if (decorator == null) {
            return null;
        }
        PyBDDMatcher matcher = this.getMatcher(decorator);
        PyBDDProcessor pyBDDProcessor = processor2 = matcher != null ? matcher.getPatternProcessor() : this.getProcessorWhenNoMatcher(evalContext);
        if (processor2 == null) {
            return null;
        }
        return processor2.getParamTypes(this, evalContext, this.getTypeMappings(evalContext, matcher)).get(name);
    }

    @NotNull
    public Map<String, PyType> getTypeMappings(@NotNull TypeEvalContext context, @Nullable PyBDDMatcher matcher) {
        if (context == null) {
            PyStepDefinition.$$$reportNull$$$0(14);
        }
        Map<String, PyType> map2 = Collections.emptyMap();
        if (map2 == null) {
            PyStepDefinition.$$$reportNull$$$0(15);
        }
        return map2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stepDefinition";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultEvalContext";
                break;
            }
            case 2: 
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 4: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/gherkin/PyStepDefinition";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decorator";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evalContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/gherkin/PyStepDefinition";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlaceHolders";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeMappings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPlaceHolders";
                break;
            }
            case 3: 
            case 4: 
            case 15: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCucumberRegexFromElement";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getExpression";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setCucumberRegex";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getMatcher";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getAsString";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getAsRegexp";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getRegexInternal";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getProcessorWhenNoMatcher";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getTypeMappings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

