/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="PythonDocumentationMap", storages={@Storage(value="other.xml")})
public class PythonDocumentationMap
implements PersistentStateComponent<State> {
    private static final ImmutableMap<String, String> DEFAULT_ENTRIES = ImmutableMap.builder().put((Object)"PyQt4", (Object)"http://pyqt.sourceforge.net/Docs/PyQt4/{class.name.lower}.html#{function.name}").put((Object)"PyQt5", (Object)"http://doc.qt.io/qt-5/{class.name.lower}.html#{functionToProperty.name}{functionIsProperty?-prop}").put((Object)"PySide", (Object)"http://pyside.github.io/docs/pyside/{module.name.slashes}/{class.name}.html#{module.name}.{element.qname}").put((Object)"gtk", (Object)"http://library.gnome.org/devel/pygtk/stable/class-gtk{class.name.lower}.html#method-gtk{class.name.lower}--{function.name.dashes}").put((Object)"wx", (Object)"http://www.wxpython.org/docs/api/{module.name}.{class.name}-class.html#{function.name}").put((Object)"kivy", (Object)"http://kivy.org/docs/api-{module.name}.html").put((Object)"matplotlib", (Object)"http://matplotlib.org/api/{module.basename}_api.html#{element.qname}").put((Object)"pyramid", (Object)"http://docs.pylonsproject.org/projects/pyramid/en/latest/api/{module.basename}.html#{element.qname}").put((Object)"flask", (Object)"http://flask.pocoo.org/docs/latest/api/#{element.qname}").put((Object)"pandas", (Object)"https://pandas.pydata.org/pandas-docs/stable/generated/{element.qname}.html").build();
    private State myState = new State();

    public static PythonDocumentationMap getInstance() {
        return (PythonDocumentationMap)ServiceManager.getService(PythonDocumentationMap.class);
    }

    public State getState() {
        return this.myState;
    }

    public void loadState(@NotNull State state2) {
        if (state2 == null) {
            PythonDocumentationMap.$$$reportNull$$$0(0);
        }
        this.myState = state2;
        PythonDocumentationMap.addAbsentEntriesFromDefaultState(this.myState);
        PythonDocumentationMap.removeEntriesThatHandledSpecially(this.myState);
    }

    private static void removeEntriesThatHandledSpecially(@NotNull State state2) {
        if (state2 == null) {
            PythonDocumentationMap.$$$reportNull$$$0(1);
        }
        ArrayList strings = Lists.newArrayList((Object[])new String[]{"django", "numpy", "scipy"});
        state2.setEntries(Maps.filterEntries(state2.getEntries(), entry -> entry != null && !strings.contains(entry.getKey())));
    }

    private static void addAbsentEntriesFromDefaultState(@NotNull State state2) {
        if (state2 == null) {
            PythonDocumentationMap.$$$reportNull$$$0(2);
        }
        state2.getEntries().putAll((Map<String, String>)DEFAULT_ENTRIES);
    }

    public Map<String, String> getEntries() {
        return ImmutableMap.copyOf(this.myState.getEntries());
    }

    public void setEntries(Map<String, String> entries) {
        this.myState.setEntries(entries);
    }

    @Nullable
    public String urlFor(QualifiedName moduleQName, @Nullable PsiNamedElement element, String pyVersion) {
        for (Map.Entry<String, String> entry : this.myState.getEntries().entrySet()) {
            if (!moduleQName.matchesPrefix(QualifiedName.fromDottedString((String)entry.getKey()))) continue;
            return PythonDocumentationMap.transformPattern(entry.getValue(), moduleQName, element, pyVersion);
        }
        return null;
    }

    public boolean isUserDefinedUrl(@NotNull String url) {
        if (url == null) {
            PythonDocumentationMap.$$$reportNull$$$0(3);
        }
        return ContainerUtil.exists(this.getEntries().values(), pattern -> url.startsWith(PythonDocumentationMap.rootForPattern(pattern)) && !DEFAULT_ENTRIES.containsValue(pattern));
    }

    private static String rootForPattern(String urlPattern) {
        int pos = urlPattern.indexOf(123);
        return pos >= 0 ? urlPattern.substring(0, pos) : urlPattern;
    }

    @Nullable
    private static String transformPattern(@NotNull String urlPattern, QualifiedName moduleQName, @Nullable PsiNamedElement element, String pyVersion) {
        if (urlPattern == null) {
            PythonDocumentationMap.$$$reportNull$$$0(4);
        }
        HashMap<String, String> macros = new HashMap<String, String>();
        macros.put("element.name", element == null ? null : element.getName());
        PyClass pyClass = element == null ? null : (PyClass)PsiTreeUtil.getParentOfType((PsiElement)element, PyClass.class, (boolean)false);
        macros.put("class.name", pyClass == null ? null : pyClass.getName());
        if (element != null) {
            StringBuilder qName = new StringBuilder(moduleQName.toString()).append(".");
            if (element instanceof PyFunction && ((PyFunction)element).getContainingClass() != null) {
                qName.append(((PyFunction)element).getContainingClass().getName()).append(".");
            }
            qName.append(element.getName());
            macros.put("element.qname", qName.toString());
        } else {
            macros.put("element.qname", "");
        }
        String functionName = element instanceof PyFunction && element.getName() != null ? element.getName() : "";
        macros.put("function.name", functionName);
        macros.put("functionToProperty.name", PythonDocumentationMap.functionToProperty(functionName));
        macros.put("module.name", moduleQName.toString());
        macros.put("python.version", pyVersion);
        macros.put("module.basename", moduleQName.getLastComponent());
        macros.put("functionIsProperty?", Boolean.toString(!functionName.equals(PythonDocumentationMap.functionToProperty(functionName))));
        String pattern = PythonDocumentationMap.transformPattern(urlPattern, macros);
        if (pattern == null) {
            return PythonDocumentationMap.rootForPattern(urlPattern);
        }
        return pattern;
    }

    private static String functionToProperty(@NotNull String name) {
        String functionOrProp;
        if (name == null) {
            PythonDocumentationMap.$$$reportNull$$$0(5);
        }
        if ((functionOrProp = StringUtil.getPropertyName((String)name)) == null) {
            functionOrProp = name;
        }
        return functionOrProp;
    }

    @Nullable
    private static String transformPattern(@NotNull String urlPattern, Map<String, String> macroValues) {
        if (urlPattern == null) {
            PythonDocumentationMap.$$$reportNull$$$0(6);
        }
        for (Map.Entry<String, String> entry : macroValues.entrySet()) {
            String regex;
            Matcher matcher;
            if (entry.getValue() == null) {
                if (!urlPattern.contains("{" + entry.getKey())) continue;
                return null;
            }
            if (entry.getKey().endsWith("?") && (matcher = Pattern.compile(regex = "\\{" + Pattern.quote(entry.getKey()) + "([^}]+)\\}").matcher(urlPattern)).find()) {
                String value2 = Boolean.valueOf(entry.getValue()) != false ? matcher.group(1) : "";
                urlPattern = urlPattern.replaceAll(regex, value2);
            }
            urlPattern = urlPattern.replace("{" + entry.getKey() + "}", entry.getValue()).replace("{" + entry.getKey() + ".lower}", StringUtil.toLowerCase((String)entry.getValue())).replace("{" + entry.getKey() + ".slashes}", entry.getValue().replace(".", "/")).replace("{" + entry.getKey() + ".dashes}", entry.getValue().replace("_", "-"));
        }
        return urlPattern.replace("{}", "");
    }

    static /* synthetic */ ImmutableMap access$000() {
        return DEFAULT_ENTRIES;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlPattern";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/documentation/PythonDocumentationMap";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "removeEntriesThatHandledSpecially";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addAbsentEntriesFromDefaultState";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isUserDefinedUrl";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "transformPattern";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "functionToProperty";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class State {
        private Map<String, String> myEntries = Maps.newHashMap((Map)PythonDocumentationMap.access$000());

        public Map<String, String> getEntries() {
            return this.myEntries;
        }

        public void setEntries(Map<String, String> entries) {
            this.myEntries = entries;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            State state2 = (State)o;
            return this.myEntries.equals(state2.getEntries());
        }

        public int hashCode() {
            return this.myEntries != null ? this.myEntries.hashCode() : 0;
        }
    }
}

