/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation;

import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.ui.AddEditRemovePanel;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PlatformUtils;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.documentation.PythonDocumentationEntryEditor;
import com.jetbrains.python.documentation.PythonDocumentationMap;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonDocumentationConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    private final PythonDocumentationPanel myPanel = new PythonDocumentationPanel();
    private static final PythonDocumentationTableModel ourModel = new PythonDocumentationTableModel();

    @NotNull
    public String getId() {
        return "com.jetbrains.python.documentation.PythonDocumentationConfigurable";
    }

    @Nls
    public String getDisplayName() {
        return PlatformUtils.isPyCharm() ? PyBundle.message("external.documentation.pycharm", new Object[0]) : PyBundle.message("external.documentation.python.plugin", new Object[0]);
    }

    public String getHelpTopic() {
        return "preferences.ExternalDocumentation";
    }

    public JComponent createComponent() {
        return this.myPanel;
    }

    public void reset() {
        this.myPanel.getData().clear();
        this.myPanel.getData().addAll(PythonDocumentationMap.getInstance().getEntries().entrySet());
    }

    public boolean isModified() {
        ImmutableMap originalEntries = ImmutableMap.copyOf(PythonDocumentationMap.getInstance().getEntries());
        ImmutableMap editedEntries = ImmutableMap.copyOf((Iterable)this.myPanel.getData());
        return !editedEntries.equals(originalEntries);
    }

    public void apply() throws ConfigurationException {
        PythonDocumentationMap.getInstance().setEntries((Map<String, String>)ImmutableMap.copyOf((Iterable)this.myPanel.getData()));
    }

    private static class PythonDocumentationPanel
    extends AddEditRemovePanel<Map.Entry<String, String>> {
        PythonDocumentationPanel() {
            super((AddEditRemovePanel.TableModel)ourModel, new ArrayList());
            this.setRenderer(1, (TableCellRenderer)new ColoredTableCellRenderer(){

                protected void customizeCellRenderer(JTable table, Object value2, boolean selected, boolean hasFocus, int row, int column) {
                    String text2 = value2 == null ? "" : (String)value2;
                    int pos = 0;
                    while (pos < text2.length()) {
                        int openBrace = text2.indexOf(123, pos);
                        if (openBrace == -1) {
                            openBrace = text2.length();
                        }
                        this.append(text2.substring(pos, openBrace));
                        int closeBrace = text2.indexOf(125, openBrace);
                        closeBrace = closeBrace == -1 ? text2.length() : ++closeBrace;
                        this.append(text2.substring(openBrace, closeBrace), new SimpleTextAttributes(1, JBColor.BLUE.darker()));
                        pos = closeBrace;
                    }
                }
            });
        }

        protected Map.Entry<String, String> addItem() {
            return this.showEditor(null);
        }

        @Nullable
        private Map.Entry<String, String> showEditor(Map.Entry<String, String> entry) {
            PythonDocumentationEntryEditor editor2 = new PythonDocumentationEntryEditor((Component)((Object)this));
            if (entry != null) {
                editor2.setEntry(entry);
            }
            editor2.show();
            if (editor2.getExitCode() != 0) {
                return null;
            }
            return editor2.getEntry();
        }

        protected boolean removeItem(Map.Entry<String, String> o) {
            return true;
        }

        protected Map.Entry<String, String> editItem(Map.Entry<String, String> o) {
            return this.showEditor(o);
        }
    }

    private static class PythonDocumentationTableModel
    extends AddEditRemovePanel.TableModel<Map.Entry<String, String>> {
        private PythonDocumentationTableModel() {
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int columnIndex) {
            return columnIndex == 0 ? "Module Name" : "URL/Path Pattern";
        }

        public Object getField(Map.Entry<String, String> o, int columnIndex) {
            return columnIndex == 0 ? o.getKey() : o.getValue();
        }
    }
}

