/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.docker;

import com.google.common.base.Joiner;
import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.compose.cli.DockerComposeCliUtil;
import com.intellij.docker.compose.configuration.beans.common.RestartPolicy;
import com.intellij.docker.compose.remote.process.DockerComposeProcessUtil;
import com.intellij.docker.compose.service.DockerComposeServiceClient;
import com.intellij.docker.compose.service.commands.ComposeServiceRunCmd;
import com.intellij.docker.compose.service.commands.SharedVolume;
import com.intellij.docker.remote.run.common.VolumesBuilder;
import com.intellij.docker.remote.run.runtime.RemoteDockerApplicationRuntime;
import com.intellij.docker.remote.run.runtime.RemoteDockerRuntime;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.CapturingProcessRunner;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessNotCreatedException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.ArrayUtil;
import com.jetbrains.python.docker.PyDockerProcessUtil;
import com.jetbrains.python.docker.PyDockerSkeletonGeneratorBase;
import com.jetbrains.python.docker.compose.PyDockerComposeProcessConnectionData;
import com.jetbrains.python.remote.PyRemoteInterpreterCommandLineUtil;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalData;
import com.jetbrains.python.sdk.InvalidSdkException;
import com.jetbrains.python.sdk.skeletons.LineWiseProcessOutputListener;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyDockerComposeSkeletonGenerator
extends PyDockerSkeletonGeneratorBase {
    private static final String ROOT_USER_ID = "0";

    public PyDockerComposeSkeletonGenerator(@Nullable Project project, @NotNull String skeletonsPath, @NotNull Sdk sdk) {
        if (skeletonsPath == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(0);
        }
        if (sdk == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(1);
        }
        super(project, skeletonsPath, sdk);
    }

    @Override
    @NotNull
    protected ProcessOutput getProcessOutput(@NotNull String homePath, String @NotNull [] commandLine, @Nullable String stdin, @Nullable Map<String, String> extraEnv, int timeout) throws InvalidSdkException {
        if (homePath == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(2);
        }
        if (commandLine == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(3);
        }
        ProcessOutput processOutput = this.runProcessWithOptionalLineOutputListener(homePath, Arrays.asList(commandLine), extraEnv, stdin, timeout, null);
        if (processOutput == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(4);
        }
        return processOutput;
    }

    @Override
    @NotNull
    protected ProcessOutput runProcessWithLineOutputListener(@NotNull String homePath, @NotNull List<String> cmd, @NotNull Map<String, String> env, @Nullable String stdin, int timeout, @NotNull LineWiseProcessOutputListener listener2) throws ExecutionException, InvalidSdkException {
        if (homePath == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(5);
        }
        if (cmd == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(6);
        }
        if (env == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(7);
        }
        if (listener2 == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(8);
        }
        ProcessOutput processOutput = this.runProcessWithOptionalLineOutputListener(homePath, cmd, env, stdin, timeout, listener2);
        if (processOutput == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(9);
        }
        return processOutput;
    }

    private ProcessOutput runProcessWithOptionalLineOutputListener(@NotNull String path, @NotNull List<String> cmd, @Nullable Map<String, String> env, @Nullable String stdin, int timeout, @Nullable LineWiseProcessOutputListener listener2) throws InvalidSdkException {
        if (path == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(10);
        }
        if (cmd == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(11);
        }
        Object[] extendedCommandLine = PyDockerComposeSkeletonGenerator.addUnbuffered(path, ArrayUtil.toStringArray(cmd));
        try {
            ComposeServiceRunCmd serviceRunCmd = this.buildDockerComposeRunCmd(env, (String[])extendedCommandLine).withRemove(true).withNoPty(Boolean.valueOf(true));
            KillableColoredProcessHandler handler = serviceRunCmd.execute();
            if (listener2 != null) {
                handler.addProcessListener((ProcessListener)new LineWiseProcessOutputListener.Adapter(listener2));
            }
            if (stdin != null) {
                PyDockerComposeSkeletonGenerator.sendLineToProcessInput(handler, stdin);
            }
            return new CapturingProcessRunner((BaseProcessHandler)handler).runProcess(timeout);
        }
        catch (ProcessNotCreatedException e) {
            LOG.debug("Unable to execute command ", new Object[]{Joiner.on((String)" ").join(extendedCommandLine), e});
            DockerComposeCliUtil.notifyDockerComposeExecutionFailed((Project)this.getProject(), (ProcessNotCreatedException)e);
            throw PyDockerComposeSkeletonGenerator.propagateRecoverableException((Exception)((Object)e));
        }
        catch (ExecutionException | ServerRuntimeException | IOException e) {
            LOG.debug("Unable to execute command ", new Object[]{Joiner.on((String)" ").join(extendedCommandLine), e});
            throw PyDockerComposeSkeletonGenerator.propagateRecoverableException((Exception)e);
        }
    }

    @NotNull
    private ComposeServiceRunCmd buildDockerComposeRunCmd(@Nullable Map<String, String> extraEnv, String @NotNull [] extendedCommandLine) throws ServerRuntimeException, RemoteSdkException, IOException {
        if (extendedCommandLine == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(12);
        }
        PyDockerComposeProcessConnectionData data = this.getProcessConnectionData();
        PyRemotePathMapper pathMapper = this.createPathMappings(this.getProject(), this.getRemoteSdkAdditionalData());
        Pair<String[], String> commandWithWorkingDir = PyRemoteInterpreterCommandLineUtil.buildRemoteCommandLine(pathMapper, extendedCommandLine, null, data.getInterpreterPath());
        RemoteDockerRuntime dockerRuntime = RemoteDockerRuntime.create((DockerCloudConfiguration)data.getAccount(), (Project)this.getProject());
        SharedVolume helpersSharedVolume = PyDockerProcessUtil.getPyCharmHelpersSharedVolume(dockerRuntime);
        String skeletonsVolume = this.prepareSkeletonsVolume();
        VolumesBuilder volumesBinds = VolumesBuilder.builder();
        volumesBinds.addBoundVolume("/opt/pycharm/skeletons", skeletonsVolume);
        ComposeServiceRunCmd composeServiceRunCmd = (ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)DockerComposeServiceClient.getInstance((RemoteDockerRuntime)dockerRuntime).runServiceCmd().withConfigurationPath(data.getComposeFilePaths())).withEnvs(data.getEnvs())).withServiceName(data.getComposeServiceName())).withCommand((String[])commandWithWorkingDir.getFirst())).withWorkingDir((String)commandWithWorkingDir.getSecond())).withEnvironment(extraEnv)).withSharedVolume(helpersSharedVolume)).withVolumes(volumesBinds.build())).withRestartPolicy((RestartPolicy)RestartPolicy.noRestart());
        if (composeServiceRunCmd == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(13);
        }
        return composeServiceRunCmd;
    }

    @Override
    @NotNull
    protected String setupSkeletonsVolume() throws ExecutionException, ServerRuntimeException {
        String volumeName = this.getSkeletonsVolumeName();
        PyDockerComposeProcessConnectionData data = this.getProcessConnectionData();
        String serviceName = data.getComposeServiceName();
        RemoteDockerRuntime dockerRuntime = RemoteDockerRuntime.create((DockerCloudConfiguration)data.getAccount(), (Project)this.getProject());
        String user = PyDockerComposeSkeletonGenerator.getServiceUser(dockerRuntime, data, serviceName);
        if (StringUtil.isNotEmpty((String)user)) {
            LOG.debug("User for service \"" + serviceName + "\" is " + user + ", permissions setup for skeletons volume \"" + volumeName + "\" required");
            this.changeOwnerForVolume(dockerRuntime, data, user, volumeName);
        } else {
            LOG.debug("User for service \"" + serviceName + "\" is default (root)");
        }
        String string = volumeName;
        if (string == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(14);
        }
        return string;
    }

    private void changeOwnerForVolume(@NotNull RemoteDockerRuntime dockerComposeClient, @NotNull PyDockerComposeProcessConnectionData data, @NotNull String user, @NotNull String volumeName) throws RemoteSdkException {
        if (dockerComposeClient == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(15);
        }
        if (data == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(16);
        }
        if (user == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(17);
        }
        if (volumeName == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(18);
        }
        try {
            String serviceName = data.getComposeServiceName();
            VolumesBuilder volumesBinds = VolumesBuilder.builder();
            volumesBinds.addBoundVolume("/opt/pycharm/skeletons", volumeName);
            DockerComposeServiceClient serviceClient = DockerComposeServiceClient.getInstance((RemoteDockerRuntime)dockerComposeClient);
            ComposeServiceRunCmd runServiceCmd = (ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)serviceClient.runServiceCmd().withConfigurationPath(data.getComposeFilePaths())).withEnvs(data.getEnvs())).withUser("root")).withRemove(true).withServiceName(serviceName)).withCommand(new String[]{"chown", "-R", user, "/opt/pycharm/skeletons"})).withVolumes(volumesBinds.build())).withRestartPolicy((RestartPolicy)RestartPolicy.noRestart());
            ProcessOutput serviceOutput = new CapturingProcessRunner((BaseProcessHandler)runServiceCmd.execute()).runProcess();
            if (!serviceOutput.checkSuccess(LOG)) {
                throw new RemoteSdkException("Failed to change permissions for skeletons volume");
            }
        }
        catch (ExecutionException | IOException e) {
            throw PyDockerComposeSkeletonGenerator.propagateRemoteSdkException("Failed to change owner of skeletons volume", e);
        }
    }

    @NotNull
    private static String getServiceUser(@NotNull RemoteDockerRuntime dockerRuntime, @NotNull PyDockerComposeProcessConnectionData data, @NotNull String serviceName) throws ExecutionException {
        if (dockerRuntime == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(19);
        }
        if (data == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(20);
        }
        if (serviceName == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(21);
        }
        try {
            DockerComposeServiceClient serviceClient = DockerComposeServiceClient.getInstance((RemoteDockerRuntime)dockerRuntime);
            ComposeServiceRunCmd runServiceCmd = (ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)serviceClient.runServiceCmd().withConfigurationPath(data.getComposeFilePaths())).withEnvs(data.getEnvs())).withRemove(true).withServiceName(serviceName)).withCommand(new String[]{"id", "-u"});
            ProcessOutput processOutput = new CapturingProcessRunner((BaseProcessHandler)runServiceCmd.execute()).runProcess();
            return PyDockerComposeSkeletonGenerator.extractServiceUserId(processOutput);
        }
        catch (IOException e) {
            throw PyDockerComposeSkeletonGenerator.propagateRemoteSdkException("Failed to get effective user for docker-compose service", e);
        }
    }

    @Contract(value="_, _ -> fail")
    @NotNull
    private static RemoteSdkException propagateRemoteSdkException(@NotNull String message, @NotNull Throwable t) throws RemoteSdkException {
        if (message == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(22);
        }
        if (t == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(23);
        }
        StringBuilder builder = new StringBuilder(message);
        String localizedMessageOfCause = t.getLocalizedMessage();
        if (StringUtil.isNotEmpty((String)localizedMessageOfCause)) {
            builder.append(":\n").append(localizedMessageOfCause);
        }
        throw new RemoteSdkException(builder.toString(), t);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    static String extractServiceUserId(@NotNull ProcessOutput processOutput) {
        String string;
        Throwable throwable;
        Scanner scanner;
        block20: {
            if (processOutput == null) {
                PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(24);
            }
            if (!processOutput.checkSuccess(LOG)) return ROOT_USER_ID;
            String stdout = processOutput.getStdout().trim();
            scanner = new Scanner(stdout);
            throwable = null;
            try {
                String lastLine = null;
                while (scanner.hasNextLine()) {
                    lastLine = scanner.nextLine();
                }
                if (lastLine != null) {
                    try {
                        String string2 = String.valueOf(Long.parseLong(lastLine));
                        string = string2;
                        break block20;
                    }
                    catch (NumberFormatException e) {
                        LOG.debug("The last line of Docker Compose stdout does not contain effective user ID: " + lastLine);
                        return ROOT_USER_ID;
                    }
                }
                LOG.debug("Docker Compose stdout of the command to get effective user ID is empty");
                return ROOT_USER_ID;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        if (string != null) return string;
        PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(25);
        return string;
        finally {
            if (scanner != null) {
                if (throwable != null) {
                    try {
                        scanner.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                } else {
                    scanner.close();
                }
            }
        }
    }

    @NotNull
    private PyDockerComposeProcessConnectionData getProcessConnectionData() {
        PyRemoteSdkAdditionalData sdkAdditionalData = this.getRemoteSdkAdditionalData();
        PyDockerComposeProcessConnectionData pyDockerComposeProcessConnectionData = PyDockerProcessUtil.getPyDockerComposeProcessConnectionData(sdkAdditionalData);
        if (pyDockerComposeProcessConnectionData == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(26);
        }
        return pyDockerComposeProcessConnectionData;
    }

    @Override
    @NotNull
    protected RemoteDockerRuntime createDockerRuntime() throws ServerRuntimeException, RemoteSdkException {
        RemoteDockerRuntime remoteDockerRuntime = RemoteDockerRuntime.create((DockerCloudConfiguration)this.getProcessConnectionData().getAccount(), (Project)this.getProject());
        if (remoteDockerRuntime == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(27);
        }
        return remoteDockerRuntime;
    }

    @Override
    protected void doDownloadSources(@NotNull String srcRemotePath, @NotNull File targetLocalDir, @NotNull VolumesBuilder volumesBinds, @Nullable Map<String, String> map2) throws IOException, RemoteSdkException, ServerRuntimeException {
        RemoteDockerApplicationRuntime serviceApplicationRuntime;
        if (srcRemotePath == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(28);
        }
        if (targetLocalDir == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(29);
        }
        if (volumesBinds == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(30);
        }
        PyDockerComposeProcessConnectionData data = this.getProcessConnectionData();
        RemoteDockerRuntime dockerRuntime = RemoteDockerRuntime.create((DockerCloudConfiguration)data.getAccount(), (Project)this.getProject());
        DockerComposeServiceClient serviceClient = DockerComposeServiceClient.getInstance((RemoteDockerRuntime)dockerRuntime);
        ComposeServiceRunCmd runServiceCmd = (ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)serviceClient.runServiceCmd().withConfigurationPath(data.getComposeFilePaths())).withEnvs(data.getEnvs())).withServiceName(data.getComposeServiceName())).withCommand(new String[]{"/bin/true"})).withVolumes(volumesBinds.build())).withRestartPolicy((RestartPolicy)RestartPolicy.noRestart());
        try {
            String containerName = runServiceCmd.execDetached();
            serviceApplicationRuntime = DockerComposeProcessUtil.getDockerComposeContainer((RemoteDockerRuntime)dockerRuntime, (String)containerName);
        }
        catch (RemoteSdkException e) {
            throw e;
        }
        catch (ExecutionException e) {
            throw new RemoteSdkException("Download failed");
        }
        serviceApplicationRuntime.downloadDirectoryAndRemove(srcRemotePath, targetLocalDir, map2, data.getAccount().getMachine());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 9: 
            case 13: 
            case 14: 
            case 25: 
            case 26: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 9: 
            case 13: 
            case 14: 
            case 25: 
            case 26: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skeletonsPath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homePath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 4: 
            case 9: 
            case 13: 
            case 14: 
            case 25: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/docker/PyDockerComposeSkeletonGenerator";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmd";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extendedCommandLine";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dockerComposeClient";
                break;
            }
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "user";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "volumeName";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dockerRuntime";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceName";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processOutput";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "srcRemotePath";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetLocalDir";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "volumesBinds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/docker/PyDockerComposeSkeletonGenerator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessOutput";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "runProcessWithLineOutputListener";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "buildDockerComposeRunCmd";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "setupSkeletonsVolume";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "extractServiceUserId";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessConnectionData";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createDockerRuntime";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getProcessOutput";
                break;
            }
            case 4: 
            case 9: 
            case 13: 
            case 14: 
            case 25: 
            case 26: 
            case 27: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "runProcessWithLineOutputListener";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "runProcessWithOptionalLineOutputListener";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "buildDockerComposeRunCmd";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "changeOwnerForVolume";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getServiceUser";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "propagateRemoteSdkException";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "extractServiceUserId";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "doDownloadSources";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 9: 
            case 13: 
            case 14: 
            case 25: 
            case 26: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

