/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.devmode;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiUtilCore;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.StructuredDocString;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeParser;
import org.jetbrains.annotations.NotNull;

public class AnalyzeTypeParserAction
extends AnAction {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AnalyzeTypeParserAction.$$$reportNull$$$0(0);
        }
        PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        e.getPresentation().setEnabledAndVisible(psiFile != null && psiFile.getFileType() instanceof PythonFileType);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        VirtualFile vFile;
        Project project;
        PsiFileSystemItem fsItem;
        if (e == null) {
            AnalyzeTypeParserAction.$$$reportNull$$$0(1);
        }
        if ((fsItem = PsiUtilCore.findFileSystemItem((Project)(project = (Project)e.getData(CommonDataKeys.PROJECT)), (VirtualFile)(vFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE)))) != null) {
            TypeParserVisitor visitor2 = new TypeParserVisitor();
            fsItem.accept((PsiElementVisitor)visitor2);
            visitor2.dumpStats();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/jetbrains/python/devmode/AnalyzeTypeParserAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class TypeParserVisitor
    extends PyRecursiveElementVisitor {
        private int myTotal = 0;
        private int mySuccessful = 0;

        private TypeParserVisitor() {
        }

        public void visitDirectory(@NotNull PsiDirectory dir) {
            if (dir == null) {
                TypeParserVisitor.$$$reportNull$$$0(0);
            }
            super.visitDirectory(dir);
            System.out.println(dir.getName());
        }

        @Override
        public void visitPyFile(PyFile node) {
            System.out.println(node.getName());
            super.visitPyFile(node);
        }

        @Override
        public void visitPyFunction(PyFunction node) {
            super.visitPyFunction(node);
            StructuredDocString structuredDocString = node.getStructuredDocString();
            if (structuredDocString != null) {
                for (PyParameter parameter : node.getParameterList().getParameters()) {
                    if (!(parameter instanceof PyNamedParameter)) continue;
                    String type = structuredDocString.getParamType(parameter.getName());
                    this.visitType((PsiElement)parameter, type);
                }
                this.visitType(node, structuredDocString.getReturnType());
            }
        }

        @Override
        public void visitPyTargetExpression(PyTargetExpression node) {
            super.visitPyTargetExpression(node);
            StructuredDocString docString = node.getStructuredDocString();
            if (docString != null) {
                this.visitType(node, docString.getParamType(null));
            }
        }

        private void visitType(PsiElement element, String type) {
            if (type == null) {
                return;
            }
            PyType pyType = PyTypeParser.getTypeByName(element, type);
            ++this.myTotal;
            if (pyType != null) {
                ++this.mySuccessful;
            } else {
                System.out.println("Failed to parse type: " + type);
            }
        }

        public void dumpStats() {
            System.out.println("Total type declarations: " + this.myTotal);
            System.out.println("Successfully parsed type declarations: " + this.mySuccessful);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/jetbrains/python/devmode/AnalyzeTypeParserAction$TypeParserVisitor", "visitDirectory"));
        }
    }
}

