/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.devmode;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyLambdaExpression;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.types.PyNoneType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import org.jetbrains.annotations.NotNull;

public class AnalyzeReturnsAction
extends AnAction {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AnalyzeReturnsAction.$$$reportNull$$$0(0);
        }
        PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        e.getPresentation().setEnabledAndVisible(psiFile != null && psiFile.getFileType() instanceof PythonFileType);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            AnalyzeReturnsAction.$$$reportNull$$$0(1);
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VirtualFile vFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (project != null && vFile != null) {
            new ReturnTypeAnalyzer(project, vFile).run();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/jetbrains/python/devmode/AnalyzeReturnsAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ReturnTypeAnalyzer
    extends PyRecursiveElementVisitor {
        private final Project myProject;
        private final VirtualFile myRoot;
        private int myTotalFunctions;
        private int myKnownReturns;
        private int myUnknownReturns;
        private int myNoneReturns;
        private int myFailures;
        private long myDuration;

        ReturnTypeAnalyzer(Project project, VirtualFile vFile) {
            this.myProject = project;
            this.myRoot = vFile;
        }

        public void run() {
            long startTime = System.nanoTime();
            this.analyze(this.myRoot);
            long endTime = System.nanoTime();
            this.myDuration = (endTime - startTime) / 1000000L;
            this.reportResults();
        }

        private void analyze(VirtualFile root) {
            VfsUtilCore.visitChildrenRecursively((VirtualFile)root, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

                public boolean visitFile(@NotNull VirtualFile file2) {
                    PsiFile psiFile;
                    if (file2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (!file2.isDirectory() && (psiFile = PsiManager.getInstance((Project)myProject).findFile(file2)) instanceof PyFile) {
                        System.out.println(file2.getName());
                        psiFile.accept((PsiElementVisitor)this);
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/devmode/AnalyzeReturnsAction$ReturnTypeAnalyzer$1", "visitFile"));
                }
            });
        }

        @Override
        public void visitPyFunction(PyFunction node) {
            super.visitPyFunction(node);
            this.accountFor(node);
        }

        @Override
        public void visitPyLambdaExpression(PyLambdaExpression node) {
            super.visitPyLambdaExpression(node);
            this.accountFor(node);
        }

        private void accountFor(PyCallable node) {
            ++this.myTotalFunctions;
            try {
                TypeEvalContext context = TypeEvalContext.userInitiated(node.getProject(), node.getContainingFile());
                PyType returnType = context.getReturnType(node);
                if (returnType == null) {
                    ++this.myUnknownReturns;
                } else if (returnType instanceof PyNoneType) {
                    ++this.myNoneReturns;
                } else {
                    ++this.myKnownReturns;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                ++this.myFailures;
            }
        }

        private void reportResults() {
            System.out.println("Total functions: " + this.myTotalFunctions);
            System.out.println("Known returns: " + this.myKnownReturns);
            System.out.println("Unknown returns: " + this.myUnknownReturns);
            System.out.println("None returns: " + this.myNoneReturns);
            System.out.println("Failures: " + this.myFailures);
            System.out.println("Duration: " + this.myDuration + " ms");
        }
    }
}

