/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.devmode;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.types.PyNoneType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnalyzeParameterTypesAction
extends AnAction {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AnalyzeParameterTypesAction.$$$reportNull$$$0(0);
        }
        PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        e.getPresentation().setEnabledAndVisible(psiFile != null && psiFile.getFileType() instanceof PythonFileType);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            AnalyzeParameterTypesAction.$$$reportNull$$$0(1);
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VirtualFile file2 = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (project != null && file2 != null) {
            new ParametersAnalyzer(project, file2).run();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/jetbrains/python/devmode/AnalyzeParameterTypesAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ParametersAnalyzer
    extends PyRecursiveElementVisitor {
        private final Project myProject;
        private final VirtualFile myFile;
        private long myDuration;
        private int myTotal;
        private int mySelfOrCls;
        private int myArgs;
        private int myKwArgs;
        private int myInferred;
        private int myLocalUsages;
        private int myUnknown;
        private int myDefaultValue;

        ParametersAnalyzer(@NotNull Project project, @NotNull VirtualFile file2) {
            if (project == null) {
                ParametersAnalyzer.$$$reportNull$$$0(0);
            }
            if (file2 == null) {
                ParametersAnalyzer.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            this.myFile = file2;
        }

        public void run() {
            long startTime = System.nanoTime();
            this.analyze(this.myFile);
            long endTime = System.nanoTime();
            this.myDuration = (endTime - startTime) / 1000000L;
            this.reportResults();
        }

        private void analyze(@NotNull VirtualFile root) {
            if (root == null) {
                ParametersAnalyzer.$$$reportNull$$$0(2);
            }
            VfsUtilCore.visitChildrenRecursively((VirtualFile)root, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

                public boolean visitFile(@NotNull VirtualFile file2) {
                    PsiFile psiFile;
                    if (file2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ("venv".equals(file2.getName())) {
                        return false;
                    }
                    if (!file2.isDirectory() && (psiFile = PsiManager.getInstance((Project)myProject).findFile(file2)) instanceof PyFile) {
                        System.out.println(file2.getName());
                        psiFile.accept((PsiElementVisitor)this);
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/devmode/AnalyzeParameterTypesAction$ParametersAnalyzer$1", "visitFile"));
                }
            });
        }

        @Override
        public void visitPyNamedParameter(@NotNull PyNamedParameter node) {
            if (node == null) {
                ParametersAnalyzer.$$$reportNull$$$0(3);
            }
            ++this.myTotal;
            if (node.isSelf()) {
                ++this.mySelfOrCls;
                return;
            }
            if (node.isPositionalContainer()) {
                ++this.myArgs;
                return;
            }
            if (node.isKeywordContainer()) {
                ++this.myKwArgs;
                return;
            }
            TypeEvalContext userWithoutUsagesContext = TypeEvalContext.userInitiated(node.getProject(), null);
            if (!ParametersAnalyzer.isUnknown(userWithoutUsagesContext.getType(node))) {
                PyType type;
                PyExpression defaultValue = node.getDefaultValue();
                if (defaultValue != null && !ParametersAnalyzer.isUnknown(type = userWithoutUsagesContext.getType(defaultValue)) && !(type instanceof PyNoneType)) {
                    ++this.myDefaultValue;
                    return;
                }
                ++this.myInferred;
                return;
            }
            if (!ParametersAnalyzer.isUnknown(TypeEvalContext.userInitiated(node.getProject(), node.getContainingFile()).getType(node))) {
                ++this.myLocalUsages;
                return;
            }
            ++this.myUnknown;
        }

        private static boolean isUnknown(@Nullable PyType type) {
            if (type == null) {
                return true;
            }
            if (type instanceof PyUnionType) {
                for (PyType t : ((PyUnionType)type).getMembers()) {
                    if (ParametersAnalyzer.isUnknown(t)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        private void reportResults() {
            System.out.println(this.counter("Total", this.myTotal));
            System.out.println(this.counter("Self or cls", this.mySelfOrCls));
            System.out.println(this.counter("Args", this.myArgs));
            System.out.println(this.counter("KwArgs", this.myKwArgs));
            System.out.println(this.counter("Default value", this.myDefaultValue));
            System.out.println(this.counter("Inferred", this.myInferred));
            System.out.println(this.counter("Local usages", this.myLocalUsages));
            System.out.println(this.counter("Unknown", this.myUnknown));
            System.out.println("Duration: " + this.myDuration + " ms");
        }

        private String counter(@NotNull String title, int n) {
            if (title == null) {
                ParametersAnalyzer.$$$reportNull$$$0(4);
            }
            return String.format("%s: %d (%d%%)", title, n, this.myTotal != 0 ? n * 100 / this.myTotal : 0);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/devmode/AnalyzeParameterTypesAction$ParametersAnalyzer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "analyze";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyNamedParameter";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "counter";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

