/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.remote.vfs;

import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.pom.Navigatable;
import com.intellij.util.PathMapper;
import com.intellij.util.PathMappingSettings;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.XSourcePositionWrapper;
import com.jetbrains.python.debugger.PyDebugProcess;
import com.jetbrains.python.debugger.PyLocalPositionConverter;
import com.jetbrains.python.debugger.PySignature;
import com.jetbrains.python.debugger.PySourcePosition;
import com.jetbrains.python.debugger.remote.vfs.PyRemoteDebugVirtualFS;
import com.jetbrains.python.remote.PyRemotePathMapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyRemotePositionConverter
extends PyLocalPositionConverter {
    private static final String[] EGG_EXTENSIONS = new String[]{".egg", ".zip"};
    @NotNull
    private final PyRemotePathMapper myPathMapper;
    private final PyRemoteDebugVirtualFS myVirtualFS;

    public PyRemotePositionConverter(PyDebugProcess debugProcess, @NotNull PathMappingSettings pathMappingSettings) {
        if (pathMappingSettings == null) {
            PyRemotePositionConverter.$$$reportNull$$$0(0);
        }
        this(debugProcess, PyRemotePathMapper.fromSettings(pathMappingSettings, PyRemotePathMapper.PyPathMappingType.USER_DEFINED));
    }

    public PyRemotePositionConverter(PyDebugProcess debugProcess, @NotNull PyRemotePathMapper pathMapper) {
        if (pathMapper == null) {
            PyRemotePositionConverter.$$$reportNull$$$0(1);
        }
        this.myPathMapper = pathMapper;
        this.myVirtualFS = new PyRemoteDebugVirtualFS(debugProcess, pathMapper, this);
    }

    @NotNull
    public PathMapper getPathMapper() {
        PyRemotePathMapper pyRemotePathMapper = this.myPathMapper;
        if (pyRemotePathMapper == null) {
            PyRemotePositionConverter.$$$reportNull$$$0(2);
        }
        return pyRemotePathMapper;
    }

    @Override
    @NotNull
    protected PySourcePosition convertToPython(@NotNull String filePath, int line2) {
        if (filePath == null) {
            PyRemotePositionConverter.$$$reportNull$$$0(3);
        }
        String path = this.myPathMapper.convertToRemote(filePath);
        return new PyLocalPositionConverter.PyRemoteSourcePosition(path, line2);
    }

    @Override
    public XSourcePosition convertFromPython(@NotNull PySourcePosition position, String frameName) {
        if (position == null) {
            PyRemotePositionConverter.$$$reportNull$$$0(4);
        }
        String path = position.getFile();
        int line2 = position.getLine();
        return this.convert(path, line2);
    }

    @Override
    protected VirtualFileSystem getLocalFileSystem() {
        return this.myVirtualFS;
    }

    protected VirtualFile findLocalEggEntry(String file2) {
        String ext;
        int ind = -1;
        String[] stringArray = EGG_EXTENSIONS;
        int n = stringArray.length;
        for (int i = 0; i < n && (ind = file2.indexOf(ext = stringArray[i])) == -1; ++i) {
        }
        if (ind != -1) {
            String jarPath = file2.substring(0, ind + 4);
            VirtualFile jarFile = LocalFileSystem.getInstance().findFileByPath(jarPath);
            if (jarFile != null) {
                String innerPath = file2.substring(ind + 4);
                VirtualFile jarRoot = JarFileSystem.getInstance().getJarRootForLocalFile(jarFile);
                if (jarRoot != null) {
                    return jarRoot.findFileByRelativePath(innerPath);
                }
            }
        }
        return null;
    }

    @Override
    public PySignature convertSignature(PySignature signature) {
        String localPath = this.getPathMapper().convertToLocal(signature.getFile());
        return new PySignature(localPath, signature.getFunctionName()).addAllArgs(signature);
    }

    @Nullable
    private XSourcePosition convert(String path, int line2) {
        VirtualFile file2 = this.getVirtualFile(path);
        XSourcePosition xPosition = PyRemotePositionConverter.createXSourcePosition(file2, line2);
        if (xPosition != null) {
            return new XRemoteSourcePosition(xPosition);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMappingSettings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMapper";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/remote/vfs/PyRemotePositionConverter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/remote/vfs/PyRemotePositionConverter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathMapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "convertToPython";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "convertFromPython";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class XRemoteSourcePosition
    extends XSourcePositionWrapper {
        private VirtualFile myFile;

        public XRemoteSourcePosition(@NotNull XSourcePosition xPosition) {
            if (xPosition == null) {
                XRemoteSourcePosition.$$$reportNull$$$0(0);
            }
            super(xPosition);
            this.myFile = xPosition.getFile();
        }

        @NotNull
        public VirtualFile getFile() {
            VirtualFile virtualFile2 = this.myFile;
            if (virtualFile2 == null) {
                XRemoteSourcePosition.$$$reportNull$$$0(1);
            }
            return virtualFile2;
        }

        public void setFile(VirtualFile file2) {
            this.myFile = file2;
        }

        @NotNull
        public Navigatable createNavigatable(@NotNull Project project) {
            if (project == null) {
                XRemoteSourcePosition.$$$reportNull$$$0(2);
            }
            return this.getOffset() != -1 ? PsiNavigationSupport.getInstance().createNavigatable(project, this.myFile, this.getOffset()) : new OpenFileDescriptor(project, this.myFile, this.getLine(), 0);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "xPosition";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/debugger/remote/vfs/PyRemotePositionConverter$XRemoteSourcePosition";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/debugger/remote/vfs/PyRemotePositionConverter$XRemoteSourcePosition";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createNavigatable";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

