/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.remote.vfs;

import com.intellij.DynamicBundle;
import com.intellij.execution.impl.EditConfigurationsDialog;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ClickListener;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.jetbrains.python.debugger.PyDebugProcess;
import com.jetbrains.python.debugger.PyLineBreakpointHandler;
import com.jetbrains.python.debugger.PyStackFrame;
import com.jetbrains.python.debugger.remote.vfs.PyPathMapper;
import com.jetbrains.python.debugger.remote.vfs.PyRemoteDebugVirtualFile;
import com.jetbrains.python.debugger.remote.vfs.PyRemoteFileStubEditor;
import com.jetbrains.python.debugger.remote.vfs.PyRemotePositionConverter;
import com.jetbrains.python.remote.PyRemotePathMapper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.text.html.HTMLDocument;
import org.jetbrains.annotations.NotNull;

public class PyRemoteFileEditorPanel {
    private final Project myProject;
    private final PyRemotePathMapper myPathMapper;
    private final String myPath;
    private final PyRemoteFileStubEditor myRemoteFileStubEditor;
    private JLabel myLabel3;
    private JLabel mySearchFileLink;
    private JLabel myLabel4;
    private JLabel myDownloadLink;
    private JPanel myEditorHolder;
    private JLabel myEditConfigurationLink;
    private JPanel myPanel;
    private JPanel myDownloadHolder;
    private JEditorPane myTextPane;
    private JBCheckBox myRememberForDebugSession;
    private JLabel mySourceStateLabel;
    private JPanel mySourceStatePanel;
    private JPanel myInfoPanel;
    private static final String REMOTE_PATH = "$REMOTE_PATH$";
    private static final String LOCAL_PATH = "$LOCAL_PATH$";
    private static final String TEXT = "<html>Remote file <b>$REMOTE_PATH$</b> is mapped to the local path <b>$LOCAL_PATH$</b> and can't be found.<br/>";
    private static final String TEXT2 = "<html>Couldn't apply path mapping to the remote file. <b>$REMOTE_PATH$</b> can't be found in project.<br/>";
    private static final String TEXT3 = "<html><b>$REMOTE_PATH$</b> can't be found in project. <br/>";
    private static final String TEXT4 = "You can continue debugging, but without the source. <br/> To fix that you can do one of the following: </html>";

    public PyRemoteFileEditorPanel(Project project, PyRemotePathMapper pathMapper, String path, PyRemoteFileStubEditor pyRemoteFileStubEditor) {
        this.myProject = project;
        this.myPathMapper = pathMapper;
        this.myPath = path;
        this.myRemoteFileStubEditor = pyRemoteFileStubEditor;
        this.$$$setupUI$$$();
        this.init();
    }

    public void init() {
        this.initEditorPane(this.myTextPane);
        this.myTextPane.setText(this.getText());
        PyRemoteFileEditorPanel.addLinkOnClick(this.mySearchFileLink, () -> {
            if (PyPathMapper.detectLocalPath(this.myProject, this.myPath, this.myPathMapper)) {
                this.closeEditorAndShowExecutionPoint();
            }
        });
        PyRemoteFileEditorPanel.addLinkOnClick(this.myEditConfigurationLink, () -> {
            EditConfigurationsDialog dialog = new EditConfigurationsDialog(this.myProject);
            boolean ok2 = dialog.showAndGet();
            if (ok2) {
                this.closeEditorAndShowExecutionPoint();
            }
        });
        PyRemoteFileEditorPanel.addLinkOnClick(this.myDownloadLink, () -> {
            if (this.myRememberForDebugSession.isSelected()) {
                this.myRemoteFileStubEditor.getRemoteDebugProcess().setDownloadSources(true);
            }
            this.downloadContent();
        });
        this.mySourceStatePanel.setVisible(false);
    }

    public void downloadContent() {
        this.mySourceStatePanel.setVisible(true);
        this.myDownloadHolder.setVisible(false);
        PyDebugProcess process2 = this.myRemoteFileStubEditor.getRemoteDebugProcess();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            String source2 = process2.loadSource(this.myPath);
            if (source2 != null) {
                UIUtil.invokeLaterIfNeeded(() -> {
                    this.myRemoteFileStubEditor.setSource(source2);
                    this.myEditorHolder.add(this.myRemoteFileStubEditor.getEditor().getComponent());
                    this.mySourceStatePanel.setVisible(false);
                    this.myInfoPanel.setVisible(false);
                    this.myRemoteFileStubEditor.showExecutionPoint();
                });
            }
        });
    }

    private void initEditorPane(JEditorPane editorPane) {
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        Font font = UIManager.getFont("Label.font");
        String bodyRule = "body { font-family: " + font.getFamily() + "; font-size: " + font.getSize() + "pt; }";
        ((HTMLDocument)editorPane.getDocument()).getStyleSheet().addRule(bodyRule);
        editorPane.setBackground(scheme.getDefaultBackground());
    }

    private String getText() {
        if (!this.myPathMapper.isEmpty()) {
            if (this.myPathMapper.canReplaceRemote(this.myPath)) {
                return "<html>Remote file <b>$REMOTE_PATH$</b> is mapped to the local path <b>$LOCAL_PATH$</b> and can't be found.<br/>You can continue debugging, but without the source. <br/> To fix that you can do one of the following: </html>".replace(REMOTE_PATH, this.myPath).replace(LOCAL_PATH, FileUtil.toSystemDependentName((String)this.myPathMapper.convertToLocal(this.myPath)));
            }
            return "<html>Couldn't apply path mapping to the remote file. <b>$REMOTE_PATH$</b> can't be found in project.<br/>You can continue debugging, but without the source. <br/> To fix that you can do one of the following: </html>".replace(REMOTE_PATH, this.myPath);
        }
        return "<html><b>$REMOTE_PATH$</b> can't be found in project. <br/>You can continue debugging, but without the source. <br/> To fix that you can do one of the following: </html>".replace(REMOTE_PATH, this.myPath);
    }

    private void closeEditorAndShowExecutionPoint() {
        PyDebugProcess process2 = this.myRemoteFileStubEditor.getRemoteDebugProcess();
        this.myRemoteFileStubEditor.close();
        PyStackFrame stackFrame = (PyStackFrame)process2.getSession().getCurrentStackFrame();
        if (stackFrame != null && stackFrame.getSourcePosition() instanceof PyRemotePositionConverter.XRemoteSourcePosition) {
            PyRemotePositionConverter.XRemoteSourcePosition remotePosition = (PyRemotePositionConverter.XRemoteSourcePosition)stackFrame.getSourcePosition();
            VirtualFile file2 = this.myRemoteFileStubEditor.getFile().getFileSystem().getRemotePositionConverter().getVirtualFile(this.myPath);
            boolean updateBreakpoints = !(file2 instanceof PyRemoteDebugVirtualFile);
            remotePosition.setFile(file2);
            process2.getSession().updateExecutionPosition();
            if (updateBreakpoints) {
                PyRemoteFileEditorPanel.reregisterBreakpoints(process2);
            }
        }
    }

    private static void reregisterBreakpoints(PyDebugProcess process2) {
        for (XBreakpointHandler<?> handler : process2.getBreakpointHandlers()) {
            if (!(handler instanceof PyLineBreakpointHandler)) continue;
            ((PyLineBreakpointHandler)handler).reregisterBreakpoints();
        }
    }

    private static void addLinkOnClick(final JLabel l, final Runnable onClick) {
        l.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent me) {
                l.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent me) {
                l.setCursor(Cursor.getDefaultCursor());
            }
        });
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                onClick.run();
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/python/debugger/remote/vfs/PyRemoteFileEditorPanel$2", "onClick"));
            }
        }.installOn((Component)l);
    }

    public JPanel getPanel() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JEditorPane jEditorPane;
        JLabel jLabel;
        JLabel jLabel2;
        JPanel jPanel2;
        JBCheckBox jBCheckBox;
        JLabel jLabel3;
        JPanel jPanel3;
        JLabel jLabel4;
        JLabel jLabel5;
        JLabel jLabel6;
        JPanel jPanel4;
        JPanel jPanel5;
        this.myPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myInfoPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), 0, -1, false, false));
        jPanel4.add((Component)jPanel6, new GridConstraints(3, 1, 1, 1, 0, 3, 3, 3, null, null, null, 1));
        this.myLabel3 = jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, DynamicBundle.getBundle((String)"messages/PythonProBundle", PyRemoteFileEditorPanel.class).getString("python.debug.autodetect.sentence"));
        jPanel6.add((Component)jLabel6, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel6.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.mySearchFileLink = jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, DynamicBundle.getBundle((String)"messages/PythonProBundle", PyRemoteFileEditorPanel.class).getString("python.debug.autodetect.link"));
        jPanel6.add((Component)jLabel5, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), 0, -1, false, false));
        jPanel4.add((Component)jPanel7, new GridConstraints(2, 1, 1, 1, 0, 3, 3, 3, null, null, null, 1));
        JLabel jLabel7 = new JLabel();
        this.$$$loadLabelText$$$(jLabel7, DynamicBundle.getBundle((String)"messages/PythonProBundle", PyRemoteFileEditorPanel.class).getString("python.debug.edit.settings.sentence"));
        jPanel7.add((Component)jLabel7, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel7.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myEditConfigurationLink = jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, DynamicBundle.getBundle((String)"messages/PythonProBundle", PyRemoteFileEditorPanel.class).getString("python.debug.edit.settings.link"));
        jPanel7.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel4.add((Component)spacer3, new GridConstraints(0, 1, 1, 1, 0, 2, 1, 0, new Dimension(-1, 10), null, null));
        Spacer spacer4 = new Spacer();
        jPanel4.add((Component)spacer4, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 1, null, null, new Dimension(-1, 6), 1));
        this.myDownloadHolder = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 5, new Insets(0, 0, 0, 0), 0, -1, false, false));
        jPanel4.add((Component)jPanel3, new GridConstraints(4, 1, 1, 1, 0, 3, 3, 3, null, null, null, 1));
        this.myDownloadLink = jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/PythonProBundle", PyRemoteFileEditorPanel.class).getString("python.debug.download.link"));
        jPanel3.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer5 = new Spacer();
        jPanel3.add((Component)spacer5, new GridConstraints(0, 4, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myRememberForDebugSession = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/PythonProBundle", PyRemoteFileEditorPanel.class).getString("python.debug.remember.for.session"));
        jPanel3.add((Component)jBCheckBox, new GridConstraints(0, 2, 1, 2, 0, 0, 0, 0, null, null, null));
        this.mySourceStatePanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.mySourceStateLabel = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/PythonProBundle", PyRemoteFileEditorPanel.class).getString("python.debug.downloading.sources"));
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer6 = new Spacer();
        jPanel2.add((Component)spacer6, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myLabel4 = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/PythonProBundle", PyRemoteFileEditorPanel.class).getString("python.debug.download.sources.sentence"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTextPane = jEditorPane = new JEditorPane();
        ((Component)jEditorPane).setBackground(SystemColor.control);
        jEditorPane.setContentType("text/html");
        jEditorPane.setEditable(false);
        jEditorPane.setText(DynamicBundle.getBundle((String)"messages/PythonProBundle", PyRemoteFileEditorPanel.class).getString("python.debug.text.pane.text"));
        jPanel4.add((Component)jEditorPane, new GridConstraints(1, 1, 1, 1, 0, 3, 6, 6, null, new Dimension(150, 50), null));
        Spacer spacer7 = new Spacer();
        jPanel5.add((Component)spacer7, new GridConstraints(1, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myEditorHolder = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

