/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.remote;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.python.debugger.PyDebugProcess;
import com.jetbrains.python.debugger.PyDebugRunner;
import com.jetbrains.python.debugger.PyRemoteDebugProcess;
import com.jetbrains.python.debugger.remote.PyRemoteDebugConfiguration;
import com.jetbrains.python.debugger.remote.vfs.PyRemotePositionConverter;
import java.io.IOException;
import java.net.ServerSocket;
import org.jetbrains.annotations.NotNull;

public class PyRemoteDebugRunner
extends PyDebugRunner {
    public static final String PY_REMOTE_DEBUG_RUNNER = "PyRemoteDebugRunner";

    @Override
    @NotNull
    public String getRunnerId() {
        return PY_REMOTE_DEBUG_RUNNER;
    }

    @Override
    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            PyRemoteDebugRunner.$$$reportNull$$$0(0);
        }
        if (profile == null) {
            PyRemoteDebugRunner.$$$reportNull$$$0(1);
        }
        return "Debug".equals(executorId) && profile instanceof PyRemoteDebugConfiguration;
    }

    @Override
    protected RunContentDescriptor doExecute(@NotNull RunProfileState profileState, final @NotNull ExecutionEnvironment env) throws ExecutionException {
        ServerSocket serverSocket;
        if (profileState == null) {
            PyRemoteDebugRunner.$$$reportNull$$$0(2);
        }
        if (env == null) {
            PyRemoteDebugRunner.$$$reportNull$$$0(3);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        final PyRemoteDebugConfiguration conf = (PyRemoteDebugConfiguration)env.getRunProfile();
        try {
            serverSocket = new ServerSocket(conf.getPort());
        }
        catch (IOException e) {
            throw new ExecutionException("Failed to find free socket port", (Throwable)e);
        }
        final ExecutionResult result = profileState.execute(env.getExecutor(), (ProgramRunner)this);
        XDebugSession session = XDebuggerManager.getInstance((Project)env.getProject()).startSession(env, new XDebugProcessStarter(){

            @NotNull
            public XDebugProcess start(@NotNull XDebugSession session) {
                if (session == null) {
                    1.$$$reportNull$$$0(0);
                }
                PyRemoteDebugProcess pyDebugProcess = new PyRemoteDebugProcess(session, serverSocket, result.getExecutionConsole(), result.getProcessHandler(), conf.getSettraceCall(serverSocket.getLocalPort()));
                pyDebugProcess.setPositionConverter(new PyRemotePositionConverter((PyDebugProcess)pyDebugProcess, conf.getMappingSettings()));
                PyDebugRunner.createConsoleCommunicationAndSetupActions(env.getProject(), result, pyDebugProcess, session);
                PyRemoteDebugProcess pyRemoteDebugProcess = pyDebugProcess;
                if (pyRemoteDebugProcess == null) {
                    1.$$$reportNull$$$0(1);
                }
                return pyRemoteDebugProcess;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "session";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/python/debugger/remote/PyRemoteDebugRunner$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/python/debugger/remote/PyRemoteDebugRunner$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "start";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "start";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        return session.getRunContentDescriptor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profileState";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/debugger/remote/PyRemoteDebugRunner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canRun";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "doExecute";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

