/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.concurrency.tool;

import com.jetbrains.python.debugger.PyConcurrencyEvent;
import com.jetbrains.python.debugger.PyLockEvent;
import com.jetbrains.python.debugger.concurrency.model.ConcurrencyGraphElement;
import com.jetbrains.python.debugger.concurrency.model.ConcurrencyGraphModel;
import com.jetbrains.python.debugger.concurrency.model.ConcurrencyThreadState;
import com.jetbrains.python.debugger.concurrency.tool.ConcurrencyStat;
import java.util.HashMap;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConcurrencyGraphAnalyser {
    @NotNull
    private final ConcurrencyGraphModel myGraphModel;
    @NotNull
    private HashMap<String, ThreadLocksInfo> myLocksInfo;
    private int lastInd;
    @NotNull
    private HashMap<String, int[]> myLocksForThreads;

    public ConcurrencyGraphAnalyser(@NotNull ConcurrencyGraphModel graphModel) {
        if (graphModel == null) {
            ConcurrencyGraphAnalyser.$$$reportNull$$$0(0);
        }
        this.lastInd = 0;
        this.myLocksInfo = new HashMap();
        this.myGraphModel = graphModel;
        this.myLocksForThreads = new HashMap();
    }

    private void updateLocksInfo(int ind) {
        if (this.lastInd == 0) {
            this.myLocksInfo = new HashMap();
        }
        for (int i = this.lastInd; i <= ind; ++i) {
            @Nullable PyConcurrencyEvent event2 = this.myGraphModel.getEventAt(i);
            if (event2 == null || !(event2 instanceof PyLockEvent)) continue;
            @NotNull PyLockEvent lockEvent = (PyLockEvent)event2;
            @NotNull String threadId = lockEvent.getThreadId();
            @NotNull String lockId = lockEvent.getLockId();
            if (!this.myLocksInfo.containsKey(threadId)) {
                this.myLocksInfo.put(threadId, new ThreadLocksInfo());
            }
            @NotNull ThreadLocksInfo info = this.myLocksInfo.get(threadId);
            if (lockEvent.getType() == PyConcurrencyEvent.EventType.ACQUIRE_BEGIN && !info.isOwning(lockId)) {
                info.setLockWait(lockId);
            }
            if (lockEvent.getType() == PyConcurrencyEvent.EventType.ACQUIRE_END) {
                info.setLockWait("");
                info.addOwn(lockId);
            }
            if (lockEvent.getType() != PyConcurrencyEvent.EventType.RELEASE) continue;
            info.removeOwn(lockId);
        }
        this.lastInd = ind;
    }

    @Nullable
    public HashSet<String> checkForDeadlocks(int ind) {
        try {
            PyConcurrencyEvent event2;
            if (this.lastInd != ind) {
                this.updateLocksInfo(ind);
            }
            if ((event2 = this.myGraphModel.getEventAt(ind)) == null) {
                return null;
            }
            @NotNull String startThreadId = event2.getThreadId();
            @Nullable ThreadLocksInfo locksInfo = this.myLocksInfo.get(startThreadId);
            if (locksInfo == null) {
                return null;
            }
            @NotNull String startWait = locksInfo.getLockWait();
            @NotNull HashSet<String> threadsInsideDeadlock = new HashSet<String>();
            threadsInsideDeadlock.add(startThreadId);
            String wait = startWait;
            while (!wait.isEmpty()) {
                boolean isOwnedBySmb = false;
                for (String thread : this.myLocksInfo.keySet()) {
                    @Nullable ThreadLocksInfo info = this.myLocksInfo.get(thread);
                    if (info == null || !info.isOwning(wait) || info.getLockWait().isEmpty()) continue;
                    if (threadsInsideDeadlock.contains(thread)) {
                        if (threadsInsideDeadlock.size() == 1) {
                            return null;
                        }
                        return threadsInsideDeadlock;
                    }
                    threadsInsideDeadlock.add(thread);
                    wait = info.getLockWait();
                    isOwnedBySmb = true;
                }
                if (isOwnedBySmb) continue;
                return null;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static void updateStatistics(@NotNull PyConcurrencyEvent event2, @NotNull String threadId, @NotNull HashMap<String, ConcurrencyStat> statInfo) {
        if (event2 == null) {
            ConcurrencyGraphAnalyser.$$$reportNull$$$0(1);
        }
        if (threadId == null) {
            ConcurrencyGraphAnalyser.$$$reportNull$$$0(2);
        }
        if (statInfo == null) {
            ConcurrencyGraphAnalyser.$$$reportNull$$$0(3);
        }
        if (event2.isThreadEvent() && event2.getType() == PyConcurrencyEvent.EventType.START) {
            ConcurrencyStat stat = new ConcurrencyStat(event2.getTime());
            statInfo.put(threadId, stat);
        } else {
            ConcurrencyStat stat;
            if (!statInfo.containsKey(threadId)) {
                stat = new ConcurrencyStat(event2.getTime());
                statInfo.put(threadId, stat);
            }
            stat = statInfo.get(threadId);
            if (event2.getType() == PyConcurrencyEvent.EventType.STOP) {
                stat.setFinishTime(event2.getTime());
            } else if (event2.getType() == PyConcurrencyEvent.EventType.ACQUIRE_BEGIN) {
                stat.setLastAcquireStartTime(event2.getTime());
            } else if (event2.getType() == PyConcurrencyEvent.EventType.ACQUIRE_END && stat.getLastAcquireStartTime() > 0L) {
                stat.incWaitTime(event2.getTime() - stat.getLastAcquireStartTime());
                stat.setLastAcquireStartTime(0L);
            }
        }
    }

    private void updateThreadStates(@NotNull PyConcurrencyEvent event2, @NotNull String threadId, int logSize, int index) {
        if (event2 == null) {
            ConcurrencyGraphAnalyser.$$$reportNull$$$0(4);
        }
        if (threadId == null) {
            ConcurrencyGraphAnalyser.$$$reportNull$$$0(5);
        }
        if (!this.myLocksForThreads.containsKey(threadId)) {
            this.myLocksForThreads.put(threadId, new int[logSize]);
        }
        int @NotNull [] locks = this.myLocksForThreads.get(threadId);
        if (event2 instanceof PyLockEvent) {
            PyLockEvent lockEvent = (PyLockEvent)event2;
            if (lockEvent.getType() == PyConcurrencyEvent.EventType.ACQUIRE_END) {
                int n = index;
                locks[n] = locks[n] + 1;
            }
            if (lockEvent.getType() == PyConcurrencyEvent.EventType.RELEASE) {
                int n = index;
                locks[n] = locks[n] - 1;
            }
        }
    }

    public void prepareThreadStatesAndUpdateStatistics(int logSize) {
        this.myLocksForThreads = new HashMap();
        @NotNull HashMap<String, ConcurrencyStat> statInfo = this.myGraphModel.getStatInfo();
        for (int i = 0; i < logSize; ++i) {
            @Nullable PyConcurrencyEvent event2 = this.myGraphModel.getEventAt(i);
            if (event2 == null) continue;
            @NotNull String threadId = event2.getThreadId();
            this.updateThreadStates(event2, threadId, logSize, i);
            ConcurrencyGraphAnalyser.updateStatistics(event2, threadId, statInfo);
        }
    }

    @NotNull
    public ConcurrencyGraphElement getThreadStateAt(int index, @NotNull String threadId) {
        int[] locks;
        if (threadId == null) {
            ConcurrencyGraphAnalyser.$$$reportNull$$$0(6);
        }
        if (this.myLocksForThreads.containsKey(threadId) && (locks = this.myLocksForThreads.get(threadId))[index] > 0) {
            return new ConcurrencyGraphElement(ConcurrencyThreadState.LockOwn, index);
        }
        return new ConcurrencyGraphElement(ConcurrencyThreadState.Run, index);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphModel";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statInfo";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/debugger/concurrency/tool/ConcurrencyGraphAnalyser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "updateStatistics";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "updateThreadStates";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getThreadStateAt";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ThreadLocksInfo {
        @NotNull
        private String lockWait = "";
        @NotNull
        private final HashSet<String> locksOwn = new HashSet();

        ThreadLocksInfo() {
        }

        public void setLockWait(@NotNull String lockWait) {
            if (lockWait == null) {
                ThreadLocksInfo.$$$reportNull$$$0(0);
            }
            this.lockWait = lockWait;
        }

        public void addOwn(@NotNull String lockId) {
            if (lockId == null) {
                ThreadLocksInfo.$$$reportNull$$$0(1);
            }
            this.locksOwn.add(lockId);
        }

        public void removeOwn(@NotNull String lockId) {
            if (lockId == null) {
                ThreadLocksInfo.$$$reportNull$$$0(2);
            }
            this.locksOwn.remove(lockId);
        }

        @NotNull
        public String getLockWait() {
            String string = this.lockWait;
            if (string == null) {
                ThreadLocksInfo.$$$reportNull$$$0(3);
            }
            return string;
        }

        public boolean isOwning(@NotNull String lockId) {
            if (lockId == null) {
                ThreadLocksInfo.$$$reportNull$$$0(4);
            }
            return this.locksOwn.contains(lockId);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lockWait";
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lockId";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/debugger/concurrency/tool/ConcurrencyGraphAnalyser$ThreadLocksInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/debugger/concurrency/tool/ConcurrencyGraphAnalyser$ThreadLocksInfo";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLockWait";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "setLockWait";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "addOwn";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "removeOwn";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isOwning";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

