/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.array;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.python.debugger.containerview.ColoredCellRenderer;
import com.jetbrains.python.debugger.containerview.PyNumericViewUtil;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.border.LineBorder;
import javax.swing.table.DefaultTableCellRenderer;
import org.jetbrains.annotations.NotNull;

class ArrayTableCellRenderer
extends DefaultTableCellRenderer
implements ColoredCellRenderer {
    private static final Logger LOG = Logger.getInstance(ArrayTableCellRenderer.class);
    private double myMin = Double.MIN_VALUE;
    private double myMax = Double.MIN_VALUE;
    private String myComplexMin;
    private String myComplexMax;
    private boolean myColored = true;
    private final String myType;

    ArrayTableCellRenderer(double min, double max, String type) {
        this.setHorizontalAlignment(2);
        this.setHorizontalTextPosition(2);
        this.setVerticalAlignment(0);
        this.myMin = min;
        this.myMax = max;
        this.myType = type;
    }

    @Override
    public void setColored(boolean colored) {
        this.myColored = colored;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, int col) {
        super.getTableCellRendererComponent(table, value2, isSelected, hasFocus, row, col);
        if (value2 != null) {
            this.setText(value2.toString());
        }
        if (hasFocus) {
            this.setBorder(new LineBorder((Color)JBColor.BLUE, 2));
        }
        if (this.myMax != this.myMin) {
            if (this.myColored && value2 != null) {
                try {
                    double rangedValue = PyNumericViewUtil.getRangedValue(value2.toString(), this.myType, this.myMin, this.myMax, this.myComplexMax, this.myComplexMin);
                    this.setBackground(PyNumericViewUtil.rangedValueToColor(rangedValue));
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                this.setBackground(UIUtil.getBgFillColor((Component)table));
            }
        }
        return this;
    }

    public void setMin(double min) {
        this.myMin = min;
    }

    public void setMax(double max) {
        this.myMax = max;
    }

    public double getMin() {
        return this.myMin;
    }

    public double getMax() {
        return this.myMax;
    }

    public void fillColorRange(@NotNull String minValue, @NotNull String maxValue) {
        if (minValue == null) {
            ArrayTableCellRenderer.$$$reportNull$$$0(0);
        }
        if (maxValue == null) {
            ArrayTableCellRenderer.$$$reportNull$$$0(1);
        }
        if ("c".equals(this.myType)) {
            this.myMin = 0.0;
            this.myMax = 1.0;
            this.myComplexMin = minValue;
            this.myComplexMax = maxValue;
            return;
        }
        if ("b".equals(this.myType)) {
            this.myMin = "True".equals(minValue) ? 1.0 : 0.0;
            this.myMax = "True".equals(maxValue) ? 1.0 : 0.0;
            return;
        }
        try {
            this.myMin = Double.parseDouble(minValue);
            this.myMax = Double.parseDouble(maxValue);
        }
        catch (NumberFormatException e) {
            LOG.error(String.format("Wrong bounds for '%s' type: minValue = %s, maxValue = %s", this.myType, minValue, maxValue));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "minValue";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "maxValue";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/debugger/array/ArrayTableCellRenderer";
        objectArray[2] = "fillColorRange";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

