/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.jetbrains.python.debugger.ArrayChunk;
import com.jetbrains.python.debugger.PyDebugValue;
import java.util.List;

public class ArrayChunkBuilder {
    private PyDebugValue myValue;
    private String myPresentation;
    private int myRows;
    private int myColumns;
    private String myMax;
    private String myMin;
    private String myFormat;
    private String myType;
    private Object[][] myData = null;
    private List<String> myRowLabels = null;
    private List<ArrayChunk.ColHeader> myColHeaders = null;

    public ArrayChunkBuilder setValue(PyDebugValue value2) {
        this.myValue = value2;
        return this;
    }

    public ArrayChunkBuilder setSlicePresentation(String presentation) {
        this.myPresentation = presentation;
        return this;
    }

    public ArrayChunkBuilder setRows(int rows) {
        this.myRows = rows;
        return this;
    }

    public ArrayChunkBuilder setColumns(int columns) {
        this.myColumns = columns;
        return this;
    }

    public ArrayChunkBuilder setMax(String max) {
        this.myMax = max;
        return this;
    }

    public ArrayChunkBuilder setMin(String min) {
        this.myMin = min;
        return this;
    }

    public ArrayChunkBuilder setFormat(String format) {
        this.myFormat = format;
        return this;
    }

    public ArrayChunkBuilder setType(String type) {
        this.myType = type;
        return this;
    }

    public ArrayChunkBuilder setData(Object[][] data) {
        this.myData = data;
        return this;
    }

    public void setRowLabels(List<String> rowLabels) {
        this.myRowLabels = rowLabels;
    }

    public void setColHeaders(List<ArrayChunk.ColHeader> colHeaders) {
        this.myColHeaders = colHeaders;
    }

    public ArrayChunk createArrayChunk() {
        return new ArrayChunk(this.myValue, this.myPresentation, this.myRows, this.myColumns, this.myMax, this.myMin, this.myFormat, this.myType, this.myData, this.myRowLabels, this.myColHeaders);
    }
}

