/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.coverage;

import com.google.common.collect.Lists;
import com.intellij.codeEditor.printing.ExportToHTMLSettings;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessAdapter;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.django.ui.DjangoBundle;
import com.jetbrains.python.PythonHelper;
import com.jetbrains.python.PythonProBundle;
import com.jetbrains.python.coverage.PyCoverageEngine;
import com.jetbrains.python.coverage.PyCoverageOptionsProvider;
import com.jetbrains.python.run.PythonProcessHandler;
import com.jetbrains.python.sdk.PythonEnvUtil;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyCoverageUtil {
    private static final Logger LOG = Logger.getInstance(PyCoverageEngine.class);

    private PyCoverageUtil() {
    }

    public static void generateReport(final @NotNull Project project, DataContext dataContext, CoverageSuitesBundle currentSuite) {
        if (project == null) {
            PyCoverageUtil.$$$reportNull$$$0(0);
        }
        ExportToHTMLSettings settings = ExportToHTMLSettings.getInstance((Project)project);
        final String outputDir = settings.OUTPUT_DIRECTORY;
        final boolean openInBrowser = settings.OPEN_IN_BROWSER;
        final Module module = PyCoverageUtil.getModuleWithPySdk(project);
        if (module == null) {
            Messages.showErrorDialog((Project)project, (String)PythonProBundle.message("python.coverage.module.not.found"), (String)PythonProBundle.message("python.coverage.module.not.found"));
            return;
        }
        Sdk sdk = PythonSdkUtil.findPythonSdk(module);
        assert (sdk != null);
        final String coverageDataFileName = currentSuite.getSuites()[0].getCoverageDataFileName();
        Task.Modal generateReportTask = new Task.Modal(project, PythonProBundle.message("python.coverage.generating.report"), false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    GeneralCommandLine cmd = PyCoverageUtil.createCommandLine(module, Lists.newArrayList((Object[])new String[]{"html", "-d", outputDir}));
                    PyCoverageUtil.addCoverageFileEnv(cmd, coverageDataFileName);
                    PyCoverageUtil.addRunCoverageEnv(cmd);
                    if (PyCoverageOptionsProvider.getInstance(project).isUseBundledCoveragePy()) {
                        PythonHelper.COVERAGEPY.addToPythonPath(cmd.getEnvironment());
                    }
                    PythonProcessHandler processHandler2 = new PythonProcessHandler(cmd);
                    ProcessOutput output = new ProcessOutput();
                    processHandler2.addProcessListener((ProcessListener)new CapturingProcessAdapter(output));
                    processHandler2.startNotify();
                    processHandler2.waitFor();
                    output.setExitCode(processHandler2.getProcess().exitValue());
                    if (output.getExitCode() == 0) {
                        ApplicationManager.getApplication().invokeLater(() -> {
                            File file2 = new File(outputDir, "index.html");
                            if (!file2.exists()) {
                                String error = "Report wasn't generated in " + outputDir;
                                if (StringUtil.isNotEmpty((String)output.getStdout())) {
                                    error = error + "\n" + output.getStdout();
                                }
                                if (StringUtil.isNotEmpty((String)output.getStderr())) {
                                    error = error + "\n" + output.getStderr();
                                }
                                Messages.showErrorDialog((String)error, (String)PythonProBundle.message("python.coverage.error"));
                            } else if (openInBrowser) {
                                BrowserUtil.browse((File)file2);
                            } else {
                                ApplicationManager.getApplication().invokeLater(() -> Messages.showInfoMessage((String)PythonProBundle.message("python.coverage.report.generated.in", outputDir), (String)PythonProBundle.message("python.coverage.report.generated")));
                            }
                        });
                    } else {
                        ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((String)PythonProBundle.message("python.coverage.exit.code", output.getExitCode()), (String)PythonProBundle.message("python.coverage.error.generating.report")));
                    }
                }
                catch (Exception e) {
                    LOG.error("epic fail", (Throwable)e);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/coverage/PyCoverageUtil$1", "run"));
            }
        };
        ProgressManager.getInstance().run((Task)generateReportTask);
    }

    @Nullable
    private static Module getModuleWithPySdk(@NotNull Project project) {
        Module[] modules;
        if (project == null) {
            PyCoverageUtil.$$$reportNull$$$0(1);
        }
        for (Module m : modules = ModuleManager.getInstance((Project)project).getModules()) {
            Sdk sdk = PythonSdkUtil.findPythonSdk(m);
            if (sdk == null) continue;
            return m;
        }
        return null;
    }

    private static GeneralCommandLine createCommandLine(Module module, List<String> params) throws ExecutionException {
        Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
        if (sdk == null) {
            throw new ExecutionException(DjangoBundle.message("manage.run.error.no-python", new Object[0]));
        }
        String homePath = sdk.getHomePath();
        if (homePath != null) {
            homePath = FileUtil.toSystemDependentName((String)homePath);
        }
        GeneralCommandLine cmd = PythonHelper.COVERAGE.newCommandLine(homePath, params);
        PythonEnvUtil.setPythonUnbuffered(cmd.getEnvironment());
        return cmd;
    }

    static void addCoverageFileEnv(GeneralCommandLine cmdLine, String coverageFilePath) {
        cmdLine.getEnvironment().put("PYCHARM_COVERAGE_FILE", coverageFilePath);
    }

    static void addRunCoverageEnv(GeneralCommandLine cmdLine) {
        cmdLine.getEnvironment().put("PYCHARM_RUN_COVERAGE", "1");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "com/jetbrains/python/coverage/PyCoverageUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "generateReport";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getModuleWithPySdk";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

