/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.console.PyConsoleProcessFinishedException;
import com.jetbrains.python.console.PythonConsoleBackendServiceDisposable;
import com.jetbrains.python.console.PythonConsoleClientUtil;
import com.jetbrains.python.console.protocol.CompletionOption;
import com.jetbrains.python.console.protocol.DebugValue;
import com.jetbrains.python.console.protocol.GetArrayResponse;
import com.jetbrains.python.console.protocol.PythonConsoleBackendService;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a1\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0010\u0010\u0002\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0001\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010\u0007\u001a\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u000f"}, d2={"invokeOriginalMethod", "", "args", "", "method", "Ljava/lang/reflect/Method;", "delegate", "([Ljava/lang/Object;Ljava/lang/reflect/Method;Ljava/lang/Object;)Ljava/lang/Object;", "synchronizedPythonConsoleClient", "Lcom/jetbrains/python/console/PythonConsoleBackendServiceDisposable;", "loader", "Ljava/lang/ClassLoader;", "Lcom/jetbrains/python/console/protocol/PythonConsoleBackendService$Iface;", "pythonConsoleProcess", "Ljava/lang/Process;", "intellij.python.community.impl"})
@JvmName(name="PythonConsoleClientUtil")
public final class PythonConsoleClientUtil {
    @NotNull
    public static final PythonConsoleBackendServiceDisposable synchronizedPythonConsoleClient(@NotNull ClassLoader loader, @NotNull PythonConsoleBackendService.Iface delegate, @NotNull Process pythonConsoleProcess) {
        Intrinsics.checkParameterIsNotNull((Object)loader, (String)"loader");
        Intrinsics.checkParameterIsNotNull((Object)delegate, (String)"delegate");
        Intrinsics.checkParameterIsNotNull((Object)pythonConsoleProcess, (String)"pythonConsoleProcess");
        ExecutorService executorService = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)PyBundle.message("console.command.executor", new Object[0]));
        Intrinsics.checkExpressionValueIsNotNull((Object)executorService, (String)"SequentialTaskExecutor.c\u2026nsole.command.executor\"))");
        ExecutorService executorService2 = executorService;
        Object object = Proxy.newProxyInstance(loader, new Class[]{PythonConsoleBackendService.Iface.class}, new InvocationHandler(executorService2, delegate, pythonConsoleProcess){
            final /* synthetic */ ExecutorService $executorService;
            final /* synthetic */ PythonConsoleBackendService.Iface $delegate;
            final /* synthetic */ Process $pythonConsoleProcess;

            @Nullable
            public final Object invoke(Object $noName_0, Method method, Object[] args2) {
                Future<T> future2 = this.$executorService.submit((Callable)new Callable<Object>(this, args2, method){
                    final /* synthetic */ synchronizedPythonConsoleClient.proxy.1 this$0;
                    final /* synthetic */ Object[] $args;
                    final /* synthetic */ Method $method;

                    @Nullable
                    public final Object call() {
                        Method method = this.$method;
                        Intrinsics.checkExpressionValueIsNotNull((Object)method, (String)"method");
                        return PythonConsoleClientUtil.access$invokeOriginalMethod(this.$args, method, this.this$0.$delegate);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$args = objectArray;
                        this.$method = method;
                    }
                });
                while (true) {
                    try {
                        return future2.get(10L, TimeUnit.MILLISECONDS);
                    }
                    catch (TimeoutException e) {
                        if (this.$pythonConsoleProcess.isAlive()) continue;
                        int exitValue = this.$pythonConsoleProcess.exitValue();
                        throw (Throwable)new PyConsoleProcessFinishedException(exitValue);
                    }
                    catch (ExecutionException e) {
                        if (!this.$pythonConsoleProcess.isAlive()) {
                            int exitValue = this.$pythonConsoleProcess.exitValue();
                            throw (Throwable)new PyConsoleProcessFinishedException(exitValue);
                        }
                        Throwable throwable = e.getCause();
                        if (throwable == null) {
                            throwable = e;
                        }
                        throw throwable;
                    }
                    break;
                }
            }
            {
                this.$executorService = executorService;
                this.$delegate = iface;
                this.$pythonConsoleProcess = process2;
            }
        });
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.jetbrains.python.console.protocol.PythonConsoleBackendService.Iface");
        }
        PythonConsoleBackendService.Iface proxy2 = (PythonConsoleBackendService.Iface)object;
        return new PythonConsoleBackendServiceDisposable(executorService2, proxy2){
            private final /* synthetic */ PythonConsoleBackendService.Iface $$delegate_0;
            final /* synthetic */ ExecutorService $executorService;
            final /* synthetic */ PythonConsoleBackendService.Iface $proxy;

            public void dispose() {
                this.$executorService.shutdownNow();
                try {
                    while (!this.$executorService.awaitTermination(1L, TimeUnit.SECONDS)) {
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            {
                this.$executorService = $captured_local_variable$0;
                this.$proxy = $captured_local_variable$1;
                this.$$delegate_0 = $captured_local_variable$1;
            }

            public void changeVariable(String evaluationExpression, String value2) {
                this.$$delegate_0.changeVariable(evaluationExpression, value2);
            }

            public void close() {
                this.$$delegate_0.close();
            }

            public void connectToDebugger(int localPort, String host, Map<String, Boolean> opts, Map<String, String> extraEnvs) {
                this.$$delegate_0.connectToDebugger(localPort, host, opts, extraEnvs);
            }

            public List<DebugValue> evaluate(String expression, boolean doTrunc) {
                return this.$$delegate_0.evaluate(expression, doTrunc);
            }

            public boolean execLine(String line2) {
                return this.$$delegate_0.execLine(line2);
            }

            public boolean execMultipleLines(String lines) {
                return this.$$delegate_0.execMultipleLines(lines);
            }

            public GetArrayResponse getArray(String vars, int rowOffset, int colOffset, int rows, int cols, String format) {
                return this.$$delegate_0.getArray(vars, rowOffset, colOffset, rows, cols, format);
            }

            public List<CompletionOption> getCompletions(String text2, String actTok) {
                return this.$$delegate_0.getCompletions(text2, actTok);
            }

            public String getDescription(String text2) {
                return this.$$delegate_0.getDescription(text2);
            }

            public List<DebugValue> getFrame() {
                return this.$$delegate_0.getFrame();
            }

            public List<DebugValue> getVariable(String variable) {
                return this.$$delegate_0.getVariable(variable);
            }

            public String handshake() {
                return this.$$delegate_0.handshake();
            }

            public void interrupt() {
                this.$$delegate_0.interrupt();
            }

            public void loadFullValue(int seq, List<String> variables) {
                this.$$delegate_0.loadFullValue(seq, variables);
            }
        };
    }

    private static final Object invokeOriginalMethod(Object[] args2, Method method, Object delegate) {
        Object object;
        try {
            object = args2 != null ? method.invoke(delegate, Arrays.copyOf(args2, args2.length)) : method.invoke(delegate, new Object[0]);
        }
        catch (InvocationTargetException e) {
            Throwable throwable = e.getCause();
            if (throwable == null) {
                throwable = e;
            }
            throw throwable;
        }
        return object;
    }

    public static final /* synthetic */ Object access$invokeOriginalMethod(Object[] args2, Method method, Object delegate) {
        return PythonConsoleClientUtil.invokeOriginalMethod(args2, method, delegate);
    }
}

