/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.google.common.collect.ImmutableList;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.FoldingListener;
import com.intellij.util.DocumentUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.console.PythonConsoleView;
import com.jetbrains.python.console.pydev.ConsoleCommunicationListener;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PyConsoleStartFolding
implements ConsoleCommunicationListener,
FoldingListener,
DocumentListener {
    private final PythonConsoleView myConsoleView;
    private int myNumberOfCommandExecuted = 0;
    private int myNumberOfCommandToStop = 2;
    private boolean doNotAddFoldingAgain = false;
    private FoldRegion myStartFoldRegion;
    private final boolean myAddOnce;
    private final String DEFAULT_FOLDING_MESSAGE = PyBundle.message("python.console", new Object[0]);
    private static final String PYTHON_PREFIX = "Python";
    private int myStartLineOffset = 0;
    private final List<String> firstLinePrefix = ImmutableList.of((Object)"Python", (Object)"PyDev console");
    private final List<String> lastLinePrefix = ImmutableList.of((Object)"IPython", (Object)"[", (Object)"PyDev console");

    public PyConsoleStartFolding(PythonConsoleView consoleView, boolean addOnce) {
        this.myConsoleView = consoleView;
        this.myAddOnce = addOnce;
    }

    public void setStartLineOffset(int startLineOffset) {
        this.myStartLineOffset = startLineOffset;
    }

    public void setNumberOfCommandToStop(int numberOfCommandToStop) {
        this.myNumberOfCommandToStop = numberOfCommandToStop;
    }

    private int getStartDefaultValue() {
        return this.myStartLineOffset;
    }

    public void documentChanged(@NotNull DocumentEvent event2) {
        if (event2 == null) {
            PyConsoleStartFolding.$$$reportNull$$$0(0);
        }
        this.addFolding();
    }

    private void addFolding() {
        Document document = this.myConsoleView.getEditor().getDocument();
        if (this.doNotAddFoldingAgain || document.getTextLength() == 0) {
            return;
        }
        if (this.myNumberOfCommandExecuted >= this.myNumberOfCommandToStop) {
            document.removeDocumentListener((DocumentListener)this);
            return;
        }
        FoldingModel foldingModel = this.myConsoleView.getEditor().getFoldingModel();
        foldingModel.runBatchFoldingOperation(() -> {
            int firstLine;
            int start = this.getStartDefaultValue();
            int startLine = 0;
            int finish = start;
            int finishLine = 0;
            String placeholderText = this.DEFAULT_FOLDING_MESSAGE;
            block0: for (int line2 = firstLine = document.getLineNumber(this.myStartLineOffset); line2 < document.getLineCount(); ++line2) {
                String lineText = document.getText(DocumentUtil.getLineTextRange((Document)document, (int)line2));
                String prevLineText = null;
                if (line2 > 0) {
                    prevLineText = document.getText(DocumentUtil.getLineTextRange((Document)document, (int)(line2 - 1)));
                }
                if (start == this.getStartDefaultValue()) {
                    for (String prefix : this.firstLinePrefix) {
                        if (!lineText.startsWith(prefix)) continue;
                        start = document.getLineStartOffset(line2);
                        startLine = line2;
                        if (!prefix.equals(PYTHON_PREFIX)) break;
                        placeholderText = lineText;
                        break;
                    }
                }
                if (this.doNotAddFoldingAgain) continue;
                for (String prefix : this.lastLinePrefix) {
                    if ((!lineText.startsWith(prefix) || prefix.equals("[")) && (!prefix.equals("[") || prevLineText == null || !prevLineText.startsWith(PYTHON_PREFIX))) continue;
                    finish = document.getLineEndOffset(line2);
                    finishLine = line2;
                    this.doNotAddFoldingAgain = this.myAddOnce;
                    continue block0;
                }
            }
            if (this.myStartFoldRegion != null) {
                foldingModel.removeFoldRegion(this.myStartFoldRegion);
            }
            if (start >= finish || startLine == finishLine) {
                return;
            }
            FoldRegion foldRegion = foldingModel.addFoldRegion(start, finish, placeholderText);
            if (foldRegion != null) {
                foldRegion.setExpanded(false);
                this.myStartFoldRegion = foldRegion;
            }
        });
    }

    @Override
    public void commandExecuted(boolean more) {
        ++this.myNumberOfCommandExecuted;
    }

    @Override
    public void inputRequested() {
    }

    public void onFoldRegionStateChange(@NotNull FoldRegion region) {
        if (region == null) {
            PyConsoleStartFolding.$$$reportNull$$$0(1);
        }
        if (region.equals(this.myStartFoldRegion) && region.isExpanded()) {
            this.myConsoleView.getEditor().getComponent().updateUI();
            this.doNotAddFoldingAgain = true;
        }
    }

    public void onFoldProcessingEnd() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "region";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/console/PyConsoleStartFolding";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "documentChanged";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "onFoldRegionStateChange";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

