/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.codeInsight.intentions.TypeIntention;
import com.jetbrains.python.debugger.PySignature;
import com.jetbrains.python.debugger.PySignatureCacheManager;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import org.jetbrains.annotations.NotNull;

public class SpecifyTypeInPy3AnnotationsIntention
extends TypeIntention {
    private String myText = PyBundle.message("INTN.specify.type.in.annotation", new Object[0]);

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            SpecifyTypeInPy3AnnotationsIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("INTN.specify.type.in.annotation", new Object[0]);
        if (string == null) {
            SpecifyTypeInPy3AnnotationsIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor2, PsiFile file2) {
        if (project == null) {
            SpecifyTypeInPy3AnnotationsIntention.$$$reportNull$$$0(2);
        }
        if (LanguageLevel.forElement((PsiElement)file2).isPython2()) {
            return false;
        }
        return super.isAvailable(project, editor2, file2);
    }

    @Override
    public void doInvoke(@NotNull Project project, Editor editor2, PsiFile file2) throws IncorrectOperationException {
        PyNamedParameter parameter;
        if (project == null) {
            SpecifyTypeInPy3AnnotationsIntention.$$$reportNull$$$0(3);
        }
        if ((parameter = this.findOnlySuitableParameter(editor2, file2)) != null) {
            SpecifyTypeInPy3AnnotationsIntention.annotateParameter(project, editor2, parameter);
            return;
        }
        PyFunction function = this.findOnlySuitableFunction(editor2, file2);
        if (function != null) {
            SpecifyTypeInPy3AnnotationsIntention.annotateReturnType(project, function);
        }
    }

    private static void annotateParameter(Project project, Editor editor2, @NotNull PyNamedParameter parameter) {
        if (parameter == null) {
            SpecifyTypeInPy3AnnotationsIntention.$$$reportNull$$$0(4);
        }
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)parameter)) {
            return;
        }
        WriteAction.run(() -> SpecifyTypeInPy3AnnotationsIntention.annotateParameter(project, editor2, parameter, true));
    }

    private static void annotateReturnType(Project project, PyFunction function) {
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)function)) {
            return;
        }
        WriteAction.run(() -> SpecifyTypeInPy3AnnotationsIntention.annotateReturnType(project, function, true));
    }

    public boolean startInWriteAction() {
        return false;
    }

    public static PyNamedParameter annotateParameter(Project project, Editor editor2, @NotNull PyNamedParameter parameter, boolean createTemplate) {
        if (parameter == null) {
            SpecifyTypeInPy3AnnotationsIntention.$$$reportNull$$$0(5);
        }
        PyExpression defaultParamValue = parameter.getDefaultValue();
        String paramName = StringUtil.notNullize((String)parameter.getName());
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
        String defaultParamText = defaultParamValue == null ? null : defaultParamValue.getText();
        String paramType = SpecifyTypeInPy3AnnotationsIntention.parameterType(parameter);
        PyNamedParameter namedParameter = elementGenerator.createParameter(paramName, defaultParamText, paramType, LanguageLevel.forElement(parameter));
        assert (namedParameter != null);
        parameter = (PyNamedParameter)parameter.replace(namedParameter);
        parameter = (PyNamedParameter)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)parameter);
        editor2.getCaretModel().moveToOffset(parameter.getTextOffset());
        PyAnnotation annotation = parameter.getAnnotation();
        if (annotation != null && createTemplate) {
            PyExpression annotationValue = annotation.getValue();
            TemplateBuilder builder = TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)parameter);
            assert (annotationValue != null) : "Generated parameter must have annotation";
            int replacementStart = annotation.getStartOffsetInParent() + annotationValue.getStartOffsetInParent();
            builder.replaceRange(TextRange.from((int)replacementStart, (int)annotationValue.getTextLength()), paramType);
            Template template = ((TemplateBuilderImpl)builder).buildInlineTemplate();
            TemplateManager.getInstance((Project)project).startTemplate(editor2, template);
        }
        return parameter;
    }

    static String parameterType(PyParameter parameter) {
        String paramType = "object";
        PyFunction function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)parameter, PyFunction.class);
        if (function != null) {
            PySignature signature = PySignatureCacheManager.getInstance(parameter.getProject()).findSignature(function);
            String parameterName = parameter.getName();
            if (signature != null && parameterName != null) {
                paramType = (String)ObjectUtils.chooseNotNull((Object)signature.getArgTypeQualifiedName(parameterName), (Object)paramType);
            }
        }
        return paramType;
    }

    static String returnType(@NotNull PyFunction function) {
        if (function == null) {
            SpecifyTypeInPy3AnnotationsIntention.$$$reportNull$$$0(6);
        }
        String returnType = "object";
        PySignature signature = PySignatureCacheManager.getInstance(function.getProject()).findSignature(function);
        if (signature != null) {
            returnType = (String)ObjectUtils.chooseNotNull((Object)signature.getReturnTypeQualifiedName(), (Object)returnType);
        }
        return returnType;
    }

    public static PyExpression annotateReturnType(Project project, PyFunction function, boolean createTemplate) {
        String returnType = SpecifyTypeInPy3AnnotationsIntention.returnType(function);
        String annotationText = "-> " + returnType;
        PyFunction annotatedFunction = (PyFunction)PyUtil.updateDocumentUnblockedAndCommitted((PsiElement)function, document -> {
            PyAnnotation oldAnnotation = function.getAnnotation();
            if (oldAnnotation != null) {
                TextRange oldRange = oldAnnotation.getTextRange();
                document.replaceString(oldRange.getStartOffset(), oldRange.getEndOffset(), (CharSequence)annotationText);
            } else {
                PsiElement prevElem = PyPsiUtils.getPrevNonCommentSibling((PsiElement)function.getStatementList(), true);
                assert (prevElem != null);
                TextRange range = prevElem.getTextRange();
                if (prevElem.getNode().getElementType() == PyTokenTypes.COLON) {
                    document.insertString(range.getStartOffset(), (CharSequence)(" " + annotationText));
                } else {
                    document.insertString(range.getEndOffset(), (CharSequence)(" " + annotationText + ":"));
                }
            }
            return (PyFunction)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)function);
        });
        if (annotatedFunction == null) {
            return null;
        }
        PyAnnotation annotation = annotatedFunction.getAnnotation();
        assert (annotation != null);
        PyExpression annotationValue = annotation.getValue();
        assert (annotationValue != null) : "Generated function must have annotation";
        if (createTemplate) {
            int offset = annotationValue.getTextOffset();
            TemplateBuilder builder = TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)annotationValue);
            builder.replaceRange(TextRange.create((int)0, (int)returnType.length()), returnType);
            Template template = ((TemplateBuilderImpl)builder).buildInlineTemplate();
            OpenFileDescriptor descriptor2 = new OpenFileDescriptor(project, annotatedFunction.getContainingFile().getVirtualFile(), offset);
            Editor targetEditor = FileEditorManager.getInstance((Project)project).openTextEditor(descriptor2, true);
            if (targetEditor != null) {
                targetEditor.getCaretModel().moveToOffset(offset);
                TemplateManager.getInstance((Project)project).startTemplate(targetEditor, template);
            }
        }
        return annotationValue;
    }

    @Override
    protected boolean isParamTypeDefined(@NotNull PyNamedParameter parameter) {
        if (parameter == null) {
            SpecifyTypeInPy3AnnotationsIntention.$$$reportNull$$$0(7);
        }
        return parameter.getAnnotation() != null;
    }

    @Override
    protected boolean isReturnTypeDefined(@NotNull PyFunction function) {
        if (function == null) {
            SpecifyTypeInPy3AnnotationsIntention.$$$reportNull$$$0(8);
        }
        return function.getAnnotation() != null;
    }

    @Override
    protected void updateText(boolean isReturn) {
        this.myText = isReturn ? PyBundle.message("INTN.specify.return.type.in.annotation", new Object[0]) : PyBundle.message("INTN.specify.type.in.annotation", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/intentions/SpecifyTypeInPy3AnnotationsIntention";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/intentions/SpecifyTypeInPy3AnnotationsIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doInvoke";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "annotateParameter";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "returnType";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isParamTypeDefined";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isReturnTypeDefined";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

