/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.editorActions;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.BackspaceHandlerDelegate;
import com.intellij.codeInsight.editorActions.QuoteHandler;
import com.intellij.codeInsight.editorActions.TypedHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.editor.BaseQuoteHandler;

public class PyTripleQuoteBackspaceDelegate
extends BackspaceHandlerDelegate {
    private boolean isTripleQuote;

    public void beforeCharDeleted(char c, PsiFile file2, Editor editor2) {
        this.isTripleQuote = false;
        if (c == '\"' || c == '\'' && CodeInsightSettings.getInstance().AUTOINSERT_PAIR_QUOTE) {
            boolean mayBeTripleQuote;
            QuoteHandler quoteHandler = TypedHandler.getQuoteHandler((PsiFile)file2, (Editor)editor2);
            if (!(quoteHandler instanceof BaseQuoteHandler)) {
                return;
            }
            int offset = editor2.getCaretModel().getCurrentCaret().getOffset();
            CharSequence text2 = editor2.getDocument().getCharsSequence();
            boolean bl = mayBeTripleQuote = offset >= 3 && offset + 2 < text2.length();
            if (mayBeTripleQuote) {
                int quoteOffset = offset - 1;
                HighlighterIterator iterator = ((EditorEx)editor2).getHighlighter().createIterator(quoteOffset);
                boolean hasTripleQuoteAfter = offset + 2 < text2.length() && text2.charAt(offset) == c && text2.charAt(offset + 1) == c && text2.charAt(offset + 2) == c;
                this.isTripleQuote = quoteHandler.isOpeningQuote(iterator, quoteOffset) && hasTripleQuoteAfter;
            }
        }
    }

    public boolean charDeleted(char c, PsiFile file2, Editor editor2) {
        if (this.isTripleQuote) {
            int offset = editor2.getCaretModel().getCurrentCaret().getOffset();
            editor2.getDocument().deleteString(offset - 2, offset + 3);
            return true;
        }
        return false;
    }
}

