/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.mako.validation;

import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.jetbrains.mako.MakoTokenTypes;
import com.jetbrains.mako.highlighting.MakoSyntaxHighlighter;
import com.jetbrains.mako.psi.impl.MakoCodeBlock;
import com.jetbrains.mako.psi.impl.MakoSubstitution;
import com.jetbrains.mako.psi.impl.MakoTagAttributeValue;
import com.jetbrains.mako.validation.MakoAnnotator;
import com.jetbrains.python.PyTokenTypes;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class MakoHighlightingAnnotator
extends MakoAnnotator {
    @Override
    public void visitMakoSubstitution(MakoSubstitution node) {
        this.getHolder().newSilentAnnotation(HighlightSeverity.INFORMATION).textAttributes(MakoSyntaxHighlighter.SUBSTITUTION).create();
    }

    @Override
    public void visitMakoCodeBlock(MakoCodeBlock node) {
        this.getHolder().newSilentAnnotation(HighlightSeverity.INFORMATION).textAttributes(EditorColors.INJECTED_LANGUAGE_FRAGMENT).create();
    }

    @Override
    public void visitMakoAttributeValue(MakoTagAttributeValue node) {
        PsiTreeUtil.processElements((PsiElement)node, (PsiElementProcessor)new PsiElementProcessor(){

            public boolean execute(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                IElementType type = element.getNode().getElementType();
                PsiElement[] children2 = MakoHighlightingAnnotator.this.getAllChildren(element);
                if (children2.length != 0) {
                    return true;
                }
                PsiElement child = element.getFirstChild();
                if (child != null && child.getTextRange().equals((Object)element.getTextRange())) {
                    return true;
                }
                if (type != PyTokenTypes.LPAR && type != PyTokenTypes.RPAR && type != PyTokenTypes.COMMA && type != PyTokenTypes.EQ && type != MakoTokenTypes.ATTR_END_DELIM && type != MakoTokenTypes.ATTR_START_DELIM) {
                    MakoHighlightingAnnotator.this.getHolder().newSilentAnnotation(HighlightSeverity.INFORMATION).range(element).textAttributes(MakoSyntaxHighlighter.ATTRIBUTE_VALUE).create();
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/mako/validation/MakoHighlightingAnnotator$1", "execute"));
            }
        });
    }

    public PsiElement @NotNull [] getAllChildren(PsiElement element) {
        PsiElement psiChild = element.getFirstChild();
        if (psiChild == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                MakoHighlightingAnnotator.$$$reportNull$$$0(0);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        while (psiChild != null) {
            result.add(psiChild);
            psiChild = psiChild.getNextSibling();
        }
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(result);
        if (psiElementArray == null) {
            MakoHighlightingAnnotator.$$$reportNull$$$0(1);
        }
        return psiElementArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/mako/validation/MakoHighlightingAnnotator", "getAllChildren"));
    }
}

