/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.mako.validation;

import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.mako.MakoTokenTypes;
import com.jetbrains.mako.psi.impl.MakoCall;
import com.jetbrains.mako.psi.impl.MakoFunction;
import com.jetbrains.mako.psi.impl.MakoTagAttribute;
import com.jetbrains.mako.ref.MakoCallReference;
import com.jetbrains.mako.validation.MakoAnnotator;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyParameterList;
import java.util.HashSet;
import java.util.Set;

public class MakoCallArgumentsAnnotator
extends MakoAnnotator {
    @Override
    public void visitMakoCall(MakoCall call) {
        this.highlightMissedArguments(call);
        this.highlightIncorrectArguments(call);
    }

    private void highlightIncorrectArguments(MakoCall call) {
        MakoCallReference reference = call.getReference();
        PsiElement resolved = reference.resolve();
        if (resolved instanceof MakoFunction) {
            MakoTagAttribute[] arguments;
            MakoFunction makoFunction = (MakoFunction)resolved;
            PyParameterList paramList = makoFunction.getParameterList();
            if (paramList.hasKeywordContainer() || paramList.hasPositionalContainer()) {
                return;
            }
            PyParameter[] params = paramList.getParameters();
            HashSet<String> paramNames = new HashSet<String>();
            for (PyParameter parameter : params) {
                paramNames.add(parameter.getName());
            }
            for (MakoTagAttribute argument : arguments = call.getArguments()) {
                if (paramNames.contains(argument.getName())) continue;
                this.getHolder().newAnnotation(HighlightSeverity.WARNING, PyBundle.message("INSP.unexpected.arg", new Object[0])).range((PsiElement)argument).create();
            }
        }
    }

    private void highlightMissedArguments(MakoCall call) {
        ASTNode node;
        ASTNode tagEnd;
        MakoCallReference reference = call.getReference();
        PsiElement resolved = reference.resolve();
        HashSet<String> missedArgs = new HashSet<String>();
        if (resolved instanceof MakoFunction) {
            MakoFunction makoFunction = (MakoFunction)resolved;
            PyParameterList paramList = makoFunction.getParameterList();
            PyParameter[] params = paramList.getParameters();
            Set<String> arguments = call.getArgumentsNames();
            for (PyParameter parameter : params) {
                String paramName;
                if (parameter.hasDefaultValue() || parameter instanceof PyNamedParameter && (((PyNamedParameter)parameter).isKeywordContainer() || ((PyNamedParameter)parameter).isPositionalContainer()) || arguments.contains(paramName = parameter.getName())) continue;
                missedArgs.add(paramName);
            }
        }
        if ((tagEnd = (node = call.getNode()).findChildByType((IElementType)MakoTokenTypes.TAG_END)) != null) {
            for (String missedArg : missedArgs) {
                this.getHolder().newAnnotation(HighlightSeverity.WARNING, PyBundle.message("INSP.parameter.$0.unfilled", missedArg)).range(tagEnd).create();
            }
        }
    }
}

