/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.mako.ref;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveResult;
import com.jetbrains.mako.MakoUtil;
import com.jetbrains.mako.psi.impl.MakoCall;
import com.jetbrains.mako.psi.impl.MakoPsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class MakoCallReference
extends PsiReferenceBase<MakoPsiElement>
implements PsiPolyVariantReference {
    public MakoCallReference(MakoCall element) {
        super((PsiElement)element);
    }

    public PsiElement resolve() {
        ResolveResult[] results = this.multiResolve(false);
        return results.length == 1 ? results[0].getElement() : null;
    }

    @NotNull
    public TextRange getRangeInElement() {
        MakoCall call = (MakoCall)this.myElement;
        int start = call.getNameRange().getStartOffset() - call.getTextRange().getStartOffset();
        return new TextRange(start, start + call.getNameRange().getLength());
    }

    public boolean isSoft() {
        return true;
    }

    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        ArrayList<PsiElementResolveResult> result = new ArrayList<PsiElementResolveResult>();
        MakoCall call = (MakoCall)this.myElement;
        for (Map.Entry entry : MakoUtil.getAvailableFunctions((PsiElement)call).entrySet()) {
            String qualifiedCallName = call.getName();
            if (call.getNamespace() != null && !"self".equals(call.getNamespace()) && !"local".equals(call.getNamespace())) {
                qualifiedCallName = call.getNamespace() + "." + call.getName();
            }
            if (!((String)entry.getKey()).equals(qualifiedCallName)) continue;
            for (PsiElement element : (Collection)entry.getValue()) {
                result.add(new PsiElementResolveResult(element));
            }
        }
        ResolveResult[] resolveResultArray = result.toArray(ResolveResult.EMPTY_ARRAY);
        if (resolveResultArray == null) {
            MakoCallReference.$$$reportNull$$$0(0);
        }
        return resolveResultArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/mako/ref/MakoCallReference", "multiResolve"));
    }
}

