/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.mako.parser;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.mako.MakoElementTypes;
import com.jetbrains.mako.MakoTokenTypes;
import com.jetbrains.python.PythonProBundle;
import com.jetbrains.python.parsing.ExpressionParsing;
import com.jetbrains.python.parsing.ParsingContext;

public class MakoExpressionParsing
extends ExpressionParsing {
    public MakoExpressionParsing(ParsingContext context) {
        super(context);
    }

    @Override
    protected IElementType getReferenceType() {
        return MakoElementTypes.REFERENCE;
    }

    @Override
    public boolean parsePrimaryExpression(boolean isTargetExpression) {
        IElementType firstToken;
        boolean parsed = super.parsePrimaryExpression(isTargetExpression);
        if (!parsed && (firstToken = this.myBuilder.getTokenType()) == MakoTokenTypes.SUBSTITUTION_START) {
            this.parseSubstitution();
            return true;
        }
        return parsed;
    }

    public void parseSubstitution() {
        PsiBuilder.Marker marker = this.myBuilder.mark();
        this.myBuilder.advanceLexer();
        while (!this.myBuilder.eof() && this.myBuilder.getTokenType() != MakoTokenTypes.SUBSTITUTION_END) {
            ExpressionParsing expressionParser = this.myContext.getExpressionParser();
            ParsingContext context = this.getParsingContext();
            context.pushScope(context.emptyParsingScope());
            boolean parsed = expressionParser.parseMemberExpression(false);
            context.popScope();
            if (parsed) continue;
            this.myBuilder.error(PythonProBundle.message("mako.end.of.substitution.expected"));
            break;
        }
        this.myBuilder.advanceLexer();
        marker.done((IElementType)MakoElementTypes.EXPRESSION_SUBSTITUTION);
    }
}

