/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.mako.highlighting;

import com.google.common.collect.Maps;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.XmlHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.mako.MakoTokenTypes;
import com.jetbrains.mako.lexer.MakoFlexLexer;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonDialectsTokenSetProvider;
import com.jetbrains.python.highlighting.PyHighlighter;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class MakoSyntaxHighlighter
extends SyntaxHighlighterBase
implements MakoTokenTypes {
    private static volatile boolean ourInitialized;
    public static final TextAttributesKey LINE_COMMENT;
    public static final TextAttributesKey TAG_ID;
    public static final TextAttributesKey CONTROL_STRUCTURE_ID;
    public static final TextAttributesKey SUBSTITUTION;
    public static final TextAttributesKey ATTRIBUTE_NAME;
    public static final TextAttributesKey ATTRIBUTE_VALUE;
    public static final TextAttributesKey TAG;
    private static final Map<IElementType, TextAttributesKey> ATTRIBUTES;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MakoSyntaxHighlighter() {
        if (ourInitialized) return;
        Class<MakoSyntaxHighlighter> clazz = MakoSyntaxHighlighter.class;
        synchronized (MakoSyntaxHighlighter.class) {
            if (ourInitialized) return;
            MakoSyntaxHighlighter.fillMap(ATTRIBUTES, (TokenSet)PythonDialectsTokenSetProvider.INSTANCE.getKeywordTokens(), (TextAttributesKey)PyHighlighter.PY_KEYWORD);
            ATTRIBUTES.put(PyTokenTypes.SINGLE_QUOTED_STRING, PyHighlighter.PY_BYTE_STRING);
            ourInitialized = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public TextAttributesKey @NotNull [] getTokenHighlights(IElementType tokenType) {
        TextAttributesKey[] textAttributesKeyArray = SyntaxHighlighterBase.pack((TextAttributesKey)ATTRIBUTES.get(tokenType));
        if (textAttributesKeyArray == null) {
            MakoSyntaxHighlighter.$$$reportNull$$$0(0);
        }
        return textAttributesKeyArray;
    }

    @NotNull
    public Lexer getHighlightingLexer() {
        return new MakoFlexLexer();
    }

    static {
        LINE_COMMENT = TextAttributesKey.createTextAttributesKey((String)"MAKO.LINE_COMMENT", (TextAttributesKey)DefaultLanguageHighlighterColors.LINE_COMMENT);
        TAG_ID = TextAttributesKey.createTextAttributesKey((String)"MAKO.TAG_ID", (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD);
        CONTROL_STRUCTURE_ID = TextAttributesKey.createTextAttributesKey((String)"MAKO.CONTROL_STRUCTURE_ID", (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD);
        SUBSTITUTION = TextAttributesKey.createTextAttributesKey((String)"MAKO.SUBSTITUTION", (TextAttributesKey)DefaultLanguageHighlighterColors.TEMPLATE_LANGUAGE_COLOR);
        ATTRIBUTE_NAME = TextAttributesKey.createTextAttributesKey((String)"MAKO.ATTRIBUTE_NAME", (TextAttributesKey)XmlHighlighterColors.HTML_ATTRIBUTE_NAME);
        ATTRIBUTE_VALUE = TextAttributesKey.createTextAttributesKey((String)"MAKO.ATTRIBUTE_VALUE", (TextAttributesKey)XmlHighlighterColors.HTML_ATTRIBUTE_VALUE);
        TAG = TextAttributesKey.createTextAttributesKey((String)"MAKO.TAG", (TextAttributesKey)DefaultLanguageHighlighterColors.MARKUP_TAG);
        ATTRIBUTES = Maps.newHashMap();
        ATTRIBUTES.put(COMMENT, LINE_COMMENT);
        ATTRIBUTES.put(MAKO_TAG_NAME, TAG_ID);
        ATTRIBUTES.put(CONTROL_STRUCTURE, CONTROL_STRUCTURE_ID);
        ATTRIBUTES.put(CONTROL_STRUCTURE_END, CONTROL_STRUCTURE_ID);
        ATTRIBUTES.put(ATTR_NAME, ATTRIBUTE_NAME);
        ATTRIBUTES.put(MAKO_EQ, ATTRIBUTE_NAME);
        ATTRIBUTES.put(ATTR_VALUE, ATTRIBUTE_VALUE);
        ATTRIBUTES.put(ATTR_END_DELIM, ATTRIBUTE_VALUE);
        ATTRIBUTES.put(ATTR_START_DELIM, ATTRIBUTE_VALUE);
        ATTRIBUTES.put(ATTR_ID, ATTRIBUTE_VALUE);
        ATTRIBUTES.put(MAKO_TAG_START, TAG);
        ATTRIBUTES.put(MAKO_TAG_END, TAG);
        ATTRIBUTES.put(MAKO_END_TAG_START, TAG);
        ATTRIBUTES.put(TAG_END, TAG);
        ATTRIBUTES.put(EMPTY_TAG_END, TAG);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/mako/highlighting/MakoSyntaxHighlighter", "getTokenHighlights"));
    }
}

