/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.mako.highlighting;

import com.intellij.codeInsight.highlighting.XmlAwareBraceMatcher;
import com.intellij.lang.BracePair;
import com.intellij.lang.PairedBraceMatcher;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.mako.MakoTokenTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MakoBraceMatcher
implements PairedBraceMatcher,
MakoTokenTypes,
XmlAwareBraceMatcher {
    private static final BracePair[] PAIRS = new BracePair[]{new BracePair((IElementType)MAKO_TAG_START, (IElementType)TAG_END, true), new BracePair((IElementType)MAKO_TAG_START, (IElementType)EMPTY_TAG_END, true), new BracePair((IElementType)MAKO_TAG_START, (IElementType)MAKO_TAG_END, true), new BracePair((IElementType)CONTROL_STRUCTURE, (IElementType)CONTROL_STRUCTURE_END, true)};

    public BracePair @NotNull [] getPairs() {
        if (PAIRS == null) {
            MakoBraceMatcher.$$$reportNull$$$0(0);
        }
        return PAIRS;
    }

    public boolean isStrictTagMatching(FileType fileType, int braceGroupId) {
        return false;
    }

    public boolean areTagsCaseSensitive(FileType fileType, int braceGroupId) {
        return true;
    }

    public String getTagName(CharSequence fileText, HighlighterIterator iterator) {
        IElementType tokenType = iterator.getTokenType();
        String name = null;
        if (tokenType == MAKO_TAG_START) {
            IElementType tokenType1;
            iterator.advance();
            IElementType iElementType = tokenType1 = iterator.atEnd() ? null : iterator.getTokenType();
            if (tokenType1 == MAKO_TAG_NAME) {
                name = fileText.subSequence(iterator.getStart(), iterator.getEnd()).toString();
            }
            iterator.retreat();
        } else if (tokenType == TAG_END) {
            int balance = 0;
            int count = 0;
            IElementType tokenType1 = iterator.getTokenType();
            while (balance >= 0) {
                iterator.retreat();
                ++count;
                if (iterator.atEnd()) break;
                tokenType1 = iterator.getTokenType();
                if (tokenType1 == TAG_END) {
                    ++balance;
                    continue;
                }
                if (tokenType1 != MAKO_TAG_NAME) continue;
                --balance;
            }
            if (tokenType1 == MAKO_TAG_NAME) {
                name = fileText.subSequence(iterator.getStart(), iterator.getEnd()).toString();
            }
            while (count-- > 0) {
                iterator.advance();
            }
        } else if (tokenType == EMPTY_TAG_END) {
            IElementType tokenType1 = iterator.getTokenType();
            int count = 0;
            while (tokenType1 != MAKO_TAG_NAME) {
                iterator.retreat();
                ++count;
                if (iterator.atEnd()) break;
                tokenType1 = iterator.getTokenType();
            }
            if (tokenType1 == MAKO_TAG_NAME) {
                name = fileText.subSequence(iterator.getStart(), iterator.getEnd()).toString();
            }
            while (count-- > 0) {
                iterator.advance();
            }
        } else if (tokenType == CONTROL_STRUCTURE) {
            name = fileText.subSequence(iterator.getStart() + 1, iterator.getEnd()).toString().trim();
        } else if (tokenType == CONTROL_STRUCTURE_END) {
            name = fileText.subSequence(iterator.getStart() + 1, iterator.getEnd()).toString().trim().substring(3);
        }
        return name;
    }

    public int getBraceTokenGroupId(IElementType tokenType) {
        if (tokenType == MAKO_TAG_START || tokenType == TAG_END || tokenType == EMPTY_TAG_END || tokenType == MAKO_TAG_END) {
            return 1;
        }
        if (tokenType == CONTROL_STRUCTURE || tokenType == CONTROL_STRUCTURE_END) {
            return 2;
        }
        return 0;
    }

    public boolean isLBraceToken(HighlighterIterator iterator, CharSequence fileText, FileType fileType) {
        IElementType tokenType = iterator.getTokenType();
        return tokenType == MAKO_TAG_START || tokenType == CONTROL_STRUCTURE && !"else".equals(fileText.subSequence(iterator.getStart() + 1, iterator.getEnd()).toString().trim());
    }

    public boolean isRBraceToken(HighlighterIterator iterator, CharSequence fileText, FileType fileType) {
        IElementType tokenType = iterator.getTokenType();
        return tokenType == TAG_END ? MakoBraceMatcher.findEndTagStart(iterator) : (tokenType == EMPTY_TAG_END ? MakoBraceMatcher.findEmptyTagStart(iterator) : tokenType == MAKO_TAG_END || tokenType == CONTROL_STRUCTURE_END);
    }

    public boolean isPairBraces(IElementType tokenType1, IElementType tokenType2) {
        if (tokenType1 == MAKO_TAG_START) {
            return tokenType2 == EMPTY_TAG_END || tokenType2 == TAG_END || tokenType2 == MAKO_TAG_END;
        }
        if (tokenType2 == MAKO_TAG_START) {
            return tokenType1 == EMPTY_TAG_END || tokenType1 == TAG_END || tokenType1 == MAKO_TAG_END;
        }
        if (tokenType1 == CONTROL_STRUCTURE) {
            return tokenType2 == CONTROL_STRUCTURE_END;
        }
        if (tokenType2 == CONTROL_STRUCTURE) {
            return tokenType1 == CONTROL_STRUCTURE_END;
        }
        return false;
    }

    public boolean isStructuralBrace(HighlighterIterator iterator, CharSequence text2, FileType fileType) {
        return true;
    }

    public IElementType getOppositeBraceTokenType(@NotNull IElementType type) {
        BracePair[] pairs;
        if (type == null) {
            MakoBraceMatcher.$$$reportNull$$$0(1);
        }
        for (BracePair pair : pairs = this.getPairs()) {
            if (pair.getLeftBraceType() == type) {
                return pair.getRightBraceType();
            }
            if (pair.getRightBraceType() != type) continue;
            return pair.getLeftBraceType();
        }
        return null;
    }

    public boolean isPairedBracesAllowedBeforeType(@NotNull IElementType lbraceType, @Nullable IElementType contextType) {
        if (lbraceType == null) {
            MakoBraceMatcher.$$$reportNull$$$0(2);
        }
        return true;
    }

    public int getCodeConstructStart(PsiFile file2, int openingBraceOffset) {
        return openingBraceOffset;
    }

    private static boolean findEndTagStart(HighlighterIterator iterator) {
        IElementType tokenType = iterator.getTokenType();
        int balance = 0;
        int count = 0;
        while (balance >= 0) {
            iterator.retreat();
            ++count;
            if (iterator.atEnd()) break;
            tokenType = iterator.getTokenType();
            if (tokenType == TAG_END || tokenType == EMPTY_TAG_END) {
                ++balance;
                continue;
            }
            if (tokenType != MAKO_TAG_START && tokenType != MAKO_END_TAG_START) continue;
            --balance;
        }
        while (count-- > 0) {
            iterator.advance();
        }
        return tokenType == MAKO_END_TAG_START;
    }

    private static boolean findEmptyTagStart(HighlighterIterator iterator) {
        IElementType tokenType = iterator.getTokenType();
        int count = 0;
        while (tokenType != MAKO_TAG_START) {
            iterator.retreat();
            ++count;
            if (iterator.atEnd()) break;
            tokenType = iterator.getTokenType();
        }
        while (count-- > 0) {
            iterator.advance();
        }
        return tokenType == MAKO_TAG_START;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/mako/highlighting/MakoBraceMatcher";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lbraceType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPairs";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/mako/highlighting/MakoBraceMatcher";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getOppositeBraceTokenType";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isPairedBracesAllowedBeforeType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

