/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.mako.editor;

import com.google.common.collect.Sets;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.mako.MakoFileViewProvider;
import com.jetbrains.mako.MakoLanguage;
import com.jetbrains.mako.MakoTokenTypes;
import com.jetbrains.mako.psi.impl.MakoControlBlock;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class MakoControlCompletionContributor
extends CompletionContributor {
    public static final Set<String> PREDEFINED = Sets.newHashSet();

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        PsiElement original;
        PsiFile file2;
        FileViewProvider provider;
        if (parameters == null) {
            MakoControlCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result == null) {
            MakoControlCompletionContributor.$$$reportNull$$$0(1);
        }
        if ((provider = (file2 = parameters.getOriginalFile()).getViewProvider()) instanceof MakoFileViewProvider && (original = provider.findElementAt(parameters.getOffset() - 1, MakoLanguage.class)) != null && MakoControlCompletionContributor.inControlStructure(original)) {
            PsiElement prevElement;
            PsiElement firstChild;
            String type;
            int offset = parameters.getOffset();
            String prefix = MakoControlCompletionContributor.getPrefix(offset, file2);
            if (prefix.length() > 0) {
                result = result.withPrefixMatcher(prefix);
            }
            boolean pref = false;
            if (original.getNode().getElementType() == MakoTokenTypes.CONTROL_STRUCTURE && !original.getText().startsWith("% ") || original.getNode().getElementType() == MakoTokenTypes.TEMPLATE_CHARACTERS && "%".equals(MakoControlCompletionContributor.getPrevSibling(original).getText())) {
                pref = true;
            }
            for (String tag : PREDEFINED) {
                result.addElement((LookupElement)LookupElementBuilder.create((String)((pref ? "%" : "") + tag)));
            }
            MakoControlBlock block = (MakoControlBlock)PsiTreeUtil.getParentOfType((PsiElement)original, MakoControlBlock.class);
            if (block != null && (type = this.getControlType(firstChild = block.getFirstChild())) != null && !StringUtil.isEmptyOrSpaces((String)type) && firstChild != original) {
                result.addElement((LookupElement)LookupElementBuilder.create((String)((pref ? "%" : "") + "end" + type)));
                if ("if".equals(type)) {
                    result.addElement((LookupElement)LookupElementBuilder.create((String)((pref ? "%" : "") + "elif")));
                    result.addElement((LookupElement)LookupElementBuilder.create((String)((pref ? "%" : "") + "else")));
                }
            }
            if ((prevElement = MakoControlCompletionContributor.getPrevSibling(original)).getNode().getElementType() == MakoTokenTypes.CONTROL_STRUCTURE) {
                type = this.getControlType(prevElement);
                if (!("elif".equals(type) || "else".equals(type) || StringUtil.isEmptyOrSpaces((String)type))) {
                    result.addElement((LookupElement)LookupElementBuilder.create((String)((pref ? "%" : "") + "end" + type)));
                }
                if ("if".equals(type)) {
                    result.addElement((LookupElement)LookupElementBuilder.create((String)((pref ? "%" : "") + "elif")));
                    result.addElement((LookupElement)LookupElementBuilder.create((String)((pref ? "%" : "") + "else")));
                }
            }
        }
    }

    public String getControlType(PsiElement element) {
        String text2 = element.getText();
        if (text2.length() > 1) {
            return text2.substring(1).trim();
        }
        return null;
    }

    private static boolean inControlStructure(PsiElement original) {
        PsiElement prev;
        if (original.getNode().getElementType() == MakoTokenTypes.CONTROL_STRUCTURE || original.getNode().getElementType() == MakoTokenTypes.CONTROL_STRUCTURE_END) {
            return true;
        }
        return original.getNode().getElementType() == MakoTokenTypes.TEMPLATE_CHARACTERS && (prev = MakoControlCompletionContributor.getPrevSibling(original)).getNode().getElementType() == MakoTokenTypes.CONTROL_STRUCTURE;
    }

    private static PsiElement getPrevSibling(PsiElement original) {
        PsiElement prev = original.getPrevSibling();
        if (prev == null && original.getParent() != null) {
            prev = original.getParent().getPrevSibling();
        }
        return prev;
    }

    private static String getPrefix(int offset, PsiFile file2) {
        if (offset > 0) {
            --offset;
        }
        String text2 = file2.getText();
        StringBuilder prefixBuilder = new StringBuilder();
        while (offset >= 0 && (Character.isLetterOrDigit(text2.charAt(offset)) || text2.charAt(offset) == '%')) {
            prefixBuilder.insert(0, text2.charAt(offset));
            --offset;
        }
        return prefixBuilder.toString();
    }

    static {
        PREDEFINED.add("if");
        PREDEFINED.add("for");
        PREDEFINED.add("while");
        PREDEFINED.add("def");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/mako/editor/MakoControlCompletionContributor";
        objectArray[2] = "fillCompletionVariants";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

