/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.mako.editor;

import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.mako.MakoFileViewProvider;
import com.jetbrains.mako.MakoTokenTypes;
import com.jetbrains.mako.psi.impl.MakoCall;
import com.jetbrains.mako.psi.impl.MakoPsiElement;
import com.jetbrains.mako.psi.impl.MakoTag;
import com.jetbrains.mako.psi.impl.MakoTagAttribute;
import org.jetbrains.annotations.NotNull;

public class MakoBracesHandler
extends TypedHandlerDelegate {
    static void typeInStringAndMoveCaret(Editor editor2, String str, int caretShift) {
        EditorModificationUtil.insertStringAtCaret((Editor)editor2, (String)str, (boolean)true, (int)caretShift);
    }

    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char c, @NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile file2, @NotNull FileType fileType) {
        if (project == null) {
            MakoBracesHandler.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            MakoBracesHandler.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            MakoBracesHandler.$$$reportNull$$$0(2);
        }
        if (fileType == null) {
            MakoBracesHandler.$$$reportNull$$$0(3);
        }
        if (file2.getViewProvider() instanceof MakoFileViewProvider) {
            Document document = editor2.getDocument();
            int offset = editor2.getCaretModel().getOffset();
            CharSequence chars = document.getCharsSequence();
            if (offset > 0 && chars.charAt(offset - 1) == '$' && c == '{') {
                String interpolation = "{}";
                MakoBracesHandler.typeInStringAndMoveCaret(editor2, interpolation, 1);
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                if (result == null) {
                    MakoBracesHandler.$$$reportNull$$$0(4);
                }
                return result;
            }
        }
        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
        if (result == null) {
            MakoBracesHandler.$$$reportNull$$$0(5);
        }
        return result;
    }

    @NotNull
    public TypedHandlerDelegate.Result charTyped(char c, @NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile file2) {
        if (project == null) {
            MakoBracesHandler.$$$reportNull$$$0(6);
        }
        if (editor2 == null) {
            MakoBracesHandler.$$$reportNull$$$0(7);
        }
        if (file2 == null) {
            MakoBracesHandler.$$$reportNull$$$0(8);
        }
        if (file2.getViewProvider() instanceof MakoFileViewProvider) {
            int offset = editor2.getCaretModel().getOffset();
            Document document = editor2.getDocument();
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
            PsiElement token = file2.findElementAt(offset - 2);
            if (token == null) {
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                if (result == null) {
                    MakoBracesHandler.$$$reportNull$$$0(9);
                }
                return result;
            }
            CharSequence chars = document.getCharsSequence();
            ASTNode tokenNode = token.getNode();
            if (offset > 0 && tokenNode != null && tokenNode.getElementType() == MakoTokenTypes.CONTROL_STRUCTURE) {
                String name = tokenNode.getText().substring(1).trim();
                if (!("if".equals(name) || "for".equals(name) || "while".equals(name) || "def".equals(name))) {
                    TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                    if (result == null) {
                        MakoBracesHandler.$$$reportNull$$$0(10);
                    }
                    return result;
                }
                int counter = 0;
                int index = offset - counter - name.length() - 2;
                while (index >= 0 && chars.charAt(index) == ' ') {
                    index = offset - ++counter - name.length() - 2;
                }
                if (index >= 0 && chars.charAt(index) == '%' && c == ' ') {
                    int space = editor2.getCaretModel().getVisualPosition().column - token.getTextLength() - 1;
                    String spaceString = space <= 0 ? "" : StringUtil.repeatSymbol((char)' ', (int)space);
                    String interpolation = ":\n" + spaceString + "%" + StringUtil.repeatSymbol((char)' ', (int)counter) + "end" + name;
                    MakoBracesHandler.typeInStringAndMoveCaret(editor2, interpolation, 0);
                    TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                    if (result == null) {
                        MakoBracesHandler.$$$reportNull$$$0(11);
                    }
                    return result;
                }
            }
            TextRange tokenRange = token.getTextRange();
            if (token instanceof PsiComment && !StringUtil.endsWith((CharSequence)token.getText(), (CharSequence)"</%doc>") && document.getText().substring(tokenRange.getStartOffset(), offset).equals("<%doc>")) {
                MakoBracesHandler.typeInStringAndMoveCaret(editor2, "</%doc>", 0);
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                if (result == null) {
                    MakoBracesHandler.$$$reportNull$$$0(12);
                }
                return result;
            }
            MakoPsiElement tag = (MakoPsiElement)PsiTreeUtil.getParentOfType((PsiElement)token, (Class[])new Class[]{MakoTag.class, MakoCall.class});
            MakoPsiElement tagAttribute = (MakoPsiElement)PsiTreeUtil.getParentOfType((PsiElement)token, MakoTagAttribute.class);
            if ((tagAttribute == null || offset - 1 == tagAttribute.getTextRange().getEndOffset()) && tag != null) {
                String name = tag.getName();
                if (StringUtil.isEmptyOrSpaces((String)name)) {
                    TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                    if (result == null) {
                        MakoBracesHandler.$$$reportNull$$$0(13);
                    }
                    return result;
                }
                if (tag instanceof MakoCall) {
                    name = ((MakoCall)tag).getQualifiedName();
                }
                if (offset > 0 && c == '>' && chars.charAt(offset - 1) != '/') {
                    MakoBracesHandler.typeInStringAndMoveCaret(editor2, "</%" + name + ">", 0);
                    TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                    if (result == null) {
                        MakoBracesHandler.$$$reportNull$$$0(14);
                    }
                    return result;
                }
                if (offset > 0 && c == '/' && chars.charAt(offset - 1) != '<') {
                    MakoBracesHandler.typeInStringAndMoveCaret(editor2, ">", 1);
                    TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                    if (result == null) {
                        MakoBracesHandler.$$$reportNull$$$0(15);
                    }
                    return result;
                }
            }
        }
        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
        if (result == null) {
            MakoBracesHandler.$$$reportNull$$$0(16);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/mako/editor/MakoBracesHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/mako/editor/MakoBracesHandler";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "beforeCharTyped";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "charTyped";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "beforeCharTyped";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "charTyped";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

