/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.mako;

import com.google.common.collect.Sets;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.mako.psi.impl.MakoControlBlock;
import com.jetbrains.mako.psi.impl.MakoFunction;
import com.jetbrains.mako.psi.impl.MakoNamespace;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.resolve.ResolveImportUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class MakoUtil {
    private MakoUtil() {
    }

    public static MultiMap<String, PsiElement> getAvailableLocalFunctions(PsiElement call) {
        MakoFunction def;
        MultiMap result = new MultiMap();
        MakoFunction[] functions = (MakoFunction[])PsiTreeUtil.getChildrenOfType((PsiElement)call.getContainingFile(), MakoFunction.class);
        if (functions != null) {
            for (MakoFunction func : functions) {
                result.putValue((Object)func.getName(), (Object)func);
            }
        }
        if ((def = (MakoFunction)PsiTreeUtil.getParentOfType((PsiElement)call, MakoFunction.class)) != null && (functions = (MakoFunction[])PsiTreeUtil.getChildrenOfType((PsiElement)def, MakoFunction.class)) != null) {
            for (MakoFunction func : functions) {
                result.putValue((Object)func.getName(), (Object)func);
            }
        }
        return result;
    }

    public static MultiMap<String, PsiElement> getAvailableImportedFunctions(PsiElement call) {
        return MakoUtil.getAvailableImportedFunctions(call, false);
    }

    public static MultiMap<String, PsiElement> getFunctionsFromNamespace(PsiElement call, String qualifier) {
        MultiMap result = new MultiMap();
        MakoNamespace[] namespaces = (MakoNamespace[])PsiTreeUtil.getChildrenOfType((PsiElement)call.getContainingFile(), MakoNamespace.class);
        if (namespaces != null) {
            for (MakoNamespace namespace : namespaces) {
                String module;
                String fileName;
                if (!qualifier.equals(namespace.getName())) continue;
                MakoFunction[] functions = (MakoFunction[])PsiTreeUtil.getChildrenOfType((PsiElement)namespace, MakoFunction.class);
                if (functions != null) {
                    for (MakoFunction func : functions) {
                        result.putValue((Object)func.getName(), (Object)func);
                    }
                }
                if ((fileName = namespace.getFile()) == null && (module = namespace.getModule()) == null) continue;
                result.putAllValues(MakoUtil.functionsFromNamespace(namespace, namespace.getImport(), false, call.getProject(), false));
            }
        }
        return result;
    }

    public static MultiMap<String, PsiElement> getAvailableImportedFunctions(PsiElement call, boolean forCompletion) {
        MultiMap result = new MultiMap();
        MakoNamespace[] namespaces = (MakoNamespace[])PsiTreeUtil.getChildrenOfType((PsiElement)call.getContainingFile(), MakoNamespace.class);
        if (namespaces != null) {
            for (MakoNamespace namespace : namespaces) {
                String fileName;
                MakoFunction[] functions = (MakoFunction[])PsiTreeUtil.getChildrenOfType((PsiElement)namespace, MakoFunction.class);
                if (functions != null) {
                    for (MakoFunction func : functions) {
                        if (forCompletion) {
                            result.putValue((Object)(namespace.getName() + ":" + func.getName()), (Object)func);
                            continue;
                        }
                        result.putValue((Object)(namespace.getName() + "." + func.getName()), (Object)func);
                    }
                }
                if ((fileName = namespace.getFile()) == null && namespace.getModule() == null) continue;
                result.putAllValues(MakoUtil.functionsFromNamespace(namespace, forCompletion, call.getProject()));
            }
        }
        return result;
    }

    public static MultiMap<String, PsiElement> functionsFromNamespace(MakoNamespace namespace, boolean forCompletion, Project project) {
        return MakoUtil.functionsFromNamespace(namespace, namespace.getImport(), forCompletion, project);
    }

    public static MultiMap<String, PsiElement> functionsFromNamespace(MakoNamespace namespace, @Nullable String importString, boolean forCompletion, Project project) {
        return MakoUtil.functionsFromNamespace(namespace, importString, forCompletion, project, true);
    }

    public static MultiMap<String, PsiElement> functionsFromNamespace(MakoNamespace namespace, @Nullable String importString, boolean forCompletion, Project project, boolean addNamespace) {
        MultiMap result;
        block4: {
            block3: {
                PsiFile[] files;
                result = new MultiMap();
                String nameString = namespace.getName();
                if (nameString == null && importString == null) {
                    return result;
                }
                if (namespace.getFile() == null) break block3;
                for (PsiFile file2 : files = FilenameIndex.getFilesByName((Project)project, (String)namespace.getFile(), (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project))) {
                    result.putAllValues(MakoUtil.getFunctionsFromFile(namespace, file2, importString, addNamespace, forCompletion));
                }
                break block4;
            }
            if (namespace.getModule() == null) break block4;
            List<PsiElement> modules = ResolveImportUtil.resolveModule(QualifiedName.fromDottedString((String)namespace.getModule()), namespace.getContainingFile(), false, 0);
            for (PsiElement m : modules) {
                if (!(m instanceof PsiFile)) continue;
                result.putAllValues(MakoUtil.getFunctionsFromFile(namespace, (PsiFile)m, importString, addNamespace, forCompletion));
            }
        }
        return result;
    }

    private static MultiMap<String, PsiElement> getFunctionsFromFile(MakoNamespace namespace, PsiFile file2, String importString, boolean addNamespace, boolean forCompletion) {
        MultiMap result;
        block4: {
            result = new MultiMap();
            PyFunction[] functions = (PyFunction[])PsiTreeUtil.getChildrenOfType((PsiElement)file2, PyFunction.class);
            if (functions == null) break block4;
            String nameString = namespace.getName();
            if (importString == null) {
                for (PyFunction func : functions) {
                    String qualifiedName = addNamespace ? (forCompletion ? nameString + ":" + func.getName() : nameString + "." + func.getName()) : func.getName();
                    result.putValue((Object)qualifiedName, (Object)func);
                }
            } else {
                for (PyFunction func : functions) {
                    String funcName = func.getName();
                    if (!"*".equals(importString) && (funcName == null || !importString.contains(funcName))) continue;
                    result.putValue((Object)funcName, (Object)func);
                }
            }
        }
        return result;
    }

    public static MultiMap<String, PsiElement> getAvailableFunctions(PsiElement call) {
        MultiMap<String, PsiElement> result = MakoUtil.getAvailableLocalFunctions(call);
        result.putAllValues(MakoUtil.getAvailableImportedFunctions(call));
        return result;
    }

    public static List<ResolveResult> resolveFunctionCall(PsiElement psiElement) {
        ArrayList<ResolveResult> result = new ArrayList<ResolveResult>();
        MakoNamespace namespace = (MakoNamespace)PsiTreeUtil.getParentOfType((PsiElement)psiElement, MakoNamespace.class);
        if (namespace != null) {
            for (Map.Entry entry : MakoUtil.functionsFromNamespace(namespace, false, psiElement.getProject()).entrySet()) {
                String qualifiedCallName = psiElement.getText();
                if (!((String)entry.getKey()).equals(qualifiedCallName)) continue;
                for (PsiElement element : (Collection)entry.getValue()) {
                    result.add((ResolveResult)new PsiElementResolveResult(element));
                }
            }
            return result;
        }
        for (Map.Entry entry : MakoUtil.getAvailableFunctions(psiElement).entrySet()) {
            String qualifiedCallName = psiElement.getText();
            if (!((String)entry.getKey()).equals(qualifiedCallName)) continue;
            for (PsiElement element : (Collection)entry.getValue()) {
                result.add((ResolveResult)new PsiElementResolveResult(element));
            }
        }
        for (PsiElement psiElement2 : MakoUtil.elementsFromControl(psiElement)) {
            if (!psiElement2.getText().equals(psiElement.getText())) continue;
            result.add((ResolveResult)new PsiElementResolveResult(psiElement2));
        }
        return result;
    }

    public static List<PyTargetExpression> elementsFromControl(PsiElement element) {
        ArrayList<PyTargetExpression> result = new ArrayList<PyTargetExpression>();
        MakoControlBlock controlBlock = (MakoControlBlock)PsiTreeUtil.getParentOfType((PsiElement)element, MakoControlBlock.class);
        while (controlBlock != null) {
            List targets = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)controlBlock, PyTargetExpression.class);
            result.addAll(targets);
            controlBlock = (MakoControlBlock)PsiTreeUtil.getParentOfType((PsiElement)controlBlock, MakoControlBlock.class);
        }
        return result;
    }

    public static Set<String> getDefaultNamespaces() {
        return Sets.newHashSet((Object[])new String[]{"self", "parent", "local", "next"});
    }
}

