/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.flask.project;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.DirectoryProjectConfigurator;
import com.jetbrains.extensions.ModuleExtKt;
import com.jetbrains.flask.FlaskFinder;
import com.jetbrains.flask.configuration.FlaskConfigurationKt;
import com.jetbrains.flask.runServer.FlaskRunServerConfiguration;
import com.jetbrains.flask.runServer.FlaskRunServerConfigurationKt;
import com.jetbrains.flask.runServer.FlaskRunServerConfigurationType;
import com.jetbrains.flask.runServer.FlaskVersion;
import com.jetbrains.jinja2.Jinja2Language;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.run.PyRunConfigurationFactory;
import com.jetbrains.python.run.PyRunConfigurationFactoryEx;
import com.jetbrains.python.run.targetBasedConfiguration.PyRunTargetVariant;
import com.jetbrains.python.templateLanguages.TemplatesService;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlaskProjectConfigurator
implements DirectoryProjectConfigurator {
    public void configureProject(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull Ref<Module> moduleRef, boolean newProject) {
        Module module;
        if (project == null) {
            FlaskProjectConfigurator.$$$reportNull$$$0(0);
        }
        if (baseDir == null) {
            FlaskProjectConfigurator.$$$reportNull$$$0(1);
        }
        if (moduleRef == null) {
            FlaskProjectConfigurator.$$$reportNull$$$0(2);
        }
        if ((module = (Module)moduleRef.get()) == null) {
            return;
        }
        VirtualFile appFile = FlaskFinder.findFlaskAppFile(baseDir);
        if (FlaskProjectConfigurator.projectRequiresFlask(module) || appFile != null) {
            VirtualFile packageTemplatesDir;
            TemplatesService templatesService = TemplatesService.getInstance(module);
            templatesService.setTemplateLanguage(Jinja2Language.INSTANCE.getTemplateLanguageName());
            VirtualFile templatesDir = baseDir.findChild("templates");
            if (templatesDir != null) {
                templatesService.setTemplateFolders(templatesDir);
            } else if (appFile != null && (packageTemplatesDir = appFile.getParent().findChild("templates")) != null) {
                templatesService.setTemplateFolders(packageTemplatesDir);
            }
            if (appFile != null) {
                FlaskProjectConfigurator.createFlaskRunConfiguration(module, appFile, null);
            }
        }
    }

    static void createFlaskRunConfiguration(Module module, VirtualFile appFile, @Nullable Sdk sdk) {
        FlaskVersion version;
        if (sdk == null) {
            sdk = ModuleExtKt.getSdk(module);
        }
        FlaskConfigurationKt.getFlaskConfiguration(module).setEnabled(true);
        PyRunConfigurationFactory runFactory = PyRunConfigurationFactory.getInstance();
        boolean createFlaskConfiguration = sdk != null ? (version = FlaskRunServerConfigurationKt.getFlaskVersion(sdk)) == null || version.compareTo(FlaskVersion.V_0_12) >= 0 : false;
        if (createFlaskConfiguration) {
            RunnerAndConfigurationSettings settings = ((PyRunConfigurationFactoryEx)runFactory).createRunConfiguration(module, (ConfigurationFactory)ConfigurationTypeUtil.findConfigurationType(FlaskRunServerConfigurationType.class));
            FlaskRunServerConfiguration conf = (FlaskRunServerConfiguration)settings.getConfiguration();
            conf.getFlaskOptions().setTargetType(PyRunTargetVariant.PATH);
            conf.getFlaskOptions().setTarget(appFile.getPath());
        } else {
            PyRunConfigurationFactory factory = PyRunConfigurationFactory.getInstance();
            factory.createPythonScriptRunConfiguration(module, appFile.getPath());
        }
    }

    private static boolean projectRequiresFlask(@NotNull Module module) {
        List<PyRequirement> requirements2;
        if (module == null) {
            FlaskProjectConfigurator.$$$reportNull$$$0(3);
        }
        if ((requirements2 = PyPackageUtil.getRequirementsFromTxt(module)) != null) {
            for (PyRequirement requirement : requirements2) {
                if (!requirement.getName().equalsIgnoreCase("flask")) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleRef";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/flask/project/FlaskProjectConfigurator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "configureProject";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "projectRequiresFlask";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

